/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.filewrappers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.InvalidFileTypeException;
import jp.crestmuse.cmx.filewrappers.MusicXMLWrapper;
import jp.crestmuse.cmx.filewrappers.NodeInterface;
import jp.crestmuse.cmx.filewrappers.NoteGroup;
import jp.crestmuse.cmx.misc.ProgramBugException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MusicApexWrapper
extends CMXFileWrapper {
    public static final String TOP_TAG = "music-apex";
    private MusicXMLWrapper targetMusicXML = null;
    private String targetMusicXMLFileName = null;
    private HashMap<String, MusicXMLWrapper.Note> xpathNoteView = null;
    private boolean inherited;
    private String aspect = null;
    private ApexWrapedGroup toplevel = null;
    private List<NoteGroup> depthFirstView = null;
    private List<NoteGroup> breadthFirstView = null;

    public static MusicApexWrapper createMusicApexWrapperFor(MusicXMLWrapper musicXMLWrapper) {
        try {
            MusicApexWrapper musicApexWrapper = (MusicApexWrapper)MusicApexWrapper.createDocument(TOP_TAG);
            musicApexWrapper.targetMusicXML = musicXMLWrapper;
            return musicApexWrapper;
        }
        catch (InvalidFileTypeException invalidFileTypeException) {
            throw new ProgramBugException(invalidFileTypeException.toString());
        }
    }

    public MusicXMLWrapper getTargetMusicXML() throws IOException {
        if (this.targetMusicXML == null) {
            if (this.getParentPath() != null) {
                MusicApexWrapper.addPathFirst(this.getParentPath());
            }
            this.targetMusicXML = (MusicXMLWrapper)MusicApexWrapper.readfile(this.getTargetMusicXMLFileName());
        }
        return this.targetMusicXML;
    }

    public String getTargetMusicXMLFileName() {
        if (this.targetMusicXMLFileName == null) {
            File file = new File(this.getTopTagAttribute("target"));
            if (file.getParent() != null) {
                MusicApexWrapper.addPathFirst(file.getParent());
            }
            this.targetMusicXMLFileName = file.getName();
        }
        return this.targetMusicXMLFileName;
    }

    public List<NoteGroup> getDepthFirstGroupView() {
        if (this.depthFirstView == null) {
            this.depthFirstView = this.makeDepthFirst(this.toplevel);
        }
        return this.depthFirstView;
    }

    private List<NoteGroup> makeDepthFirst(ApexWrapedGroup apexWrapedGroup) {
        ArrayList<NoteGroup> arrayList = new ArrayList<NoteGroup>();
        arrayList.add(apexWrapedGroup);
        for (NoteGroup noteGroup : apexWrapedGroup.getSubgroups()) {
            arrayList.addAll(this.makeDepthFirst((ApexWrapedGroup)noteGroup));
        }
        return arrayList;
    }

    public List<NoteGroup> getBreadthFirstView() {
        if (this.breadthFirstView == null) {
            this.breadthFirstView = this.makeBreadthFirst(this.toplevel);
        }
        return this.breadthFirstView;
    }

    private List<NoteGroup> makeBreadthFirst(ApexWrapedGroup apexWrapedGroup) {
        ArrayList<NoteGroup> arrayList = new ArrayList<NoteGroup>();
        LinkedList<ApexWrapedGroup> linkedList = new LinkedList<ApexWrapedGroup>();
        linkedList.offer(apexWrapedGroup);
        while (!linkedList.isEmpty()) {
            ApexWrapedGroup apexWrapedGroup2 = (ApexWrapedGroup)linkedList.poll();
            arrayList.add(apexWrapedGroup2);
            for (NoteGroup noteGroup : apexWrapedGroup2.getSubgroups()) {
                linkedList.offer((ApexWrapedGroup)noteGroup);
            }
        }
        return arrayList;
    }

    public String getAspect() {
        return this.aspect;
    }

    @Override
    protected void analyze() throws IOException {
        try {
            this.addLinks("//note", this.getTargetMusicXML());
            this.addLinks("//apex", this.getTargetMusicXML());
            Node node = this.selectSingleNode("/music-apex");
            if (NodeInterface.hasAttribute(node, "apex-inherited")) {
                boolean bl = this.inherited = NodeInterface.getAttribute(node, "apex-inherited").equals("yes");
            }
            if (NodeInterface.hasAttribute(node, "aspect")) {
                this.aspect = NodeInterface.getAttribute(node, "aspect");
            }
            if (NodeInterface.hasAttribute(node, "target")) {
                this.targetMusicXMLFileName = NodeInterface.getAttribute(node, "target");
            }
            this.toplevel = this.analyzeGroups((Element)this.selectSingleNode("/music-apex/group"), null);
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
        }
    }

    private HashMap<String, MusicXMLWrapper.Note> getXPathNoteView() {
        try {
            MusicXMLWrapper.Part[] partArray;
            this.xpathNoteView = new HashMap();
            MusicXMLWrapper musicXMLWrapper = this.getTargetMusicXML();
            for (MusicXMLWrapper.Part part : partArray = musicXMLWrapper.getPartList()) {
                MusicXMLWrapper.Measure[] measureArray;
                for (MusicXMLWrapper.Measure measure : measureArray = part.getMeasureList()) {
                    MusicXMLWrapper.MusicData[] musicDataArray;
                    for (MusicXMLWrapper.MusicData musicData : musicDataArray = measure.getMusicDataList()) {
                        if (!(musicData instanceof MusicXMLWrapper.Note)) continue;
                        MusicXMLWrapper.Note note = (MusicXMLWrapper.Note)musicData;
                        this.xpathNoteView.put(note.getXPathExpression(), note);
                    }
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this.xpathNoteView;
    }

    private ApexWrapedGroup analyzeGroups(Element element, ApexWrapedGroup apexWrapedGroup) {
        if (!element.getNodeName().equals("group")) {
            throw new RuntimeException("Node is not group Element");
        }
        if (this.xpathNoteView == null) {
            this.xpathNoteView = this.getXPathNoteView();
        }
        ApexWrapedGroup apexWrapedGroup2 = new ApexWrapedGroup();
        apexWrapedGroup2.depth = Integer.parseInt(element.getAttribute("depth"));
        String string = this.getXPathPosition(element);
        NodeList nodeList = this.selectNodeList(string + "/note");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            apexWrapedGroup2.ownnotes.add(this.xpathNoteView.get(this.cutXPath(nodeList.item(i))));
        }
        NodeList nodeList2 = this.selectNodeList(string + "//note");
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            apexWrapedGroup2.undernotes.add(this.xpathNoteView.get(this.cutXPath(nodeList2.item(i))));
        }
        Element element2 = (Element)this.selectSingleNode(string + "/apex[1]");
        if (element2 != null) {
            apexWrapedGroup2.apex = this.xpathNoteView.get(this.cutXPath(element2));
            apexWrapedGroup2.saliency = element2.hasAttribute("saliency") ? Double.parseDouble(element2.getAttribute("saliency")) : Double.NaN;
        }
        apexWrapedGroup2.groupParent = apexWrapedGroup;
        NodeList nodeList3 = this.selectNodeList(string + "/group");
        for (int i = 0; i < nodeList3.getLength(); ++i) {
            apexWrapedGroup2.subGroups.add(this.analyzeGroups((Element)nodeList3.item(i), apexWrapedGroup2));
        }
        return apexWrapedGroup2;
    }

    private String cutXPath(Node node) {
        if (!(node instanceof Element)) {
            throw new UnsupportedOperationException();
        }
        String string = ((Element)node).getAttribute("xlink:href");
        if (string == null) {
            throw new RuntimeException("This Element has no xpointer : " + node.toString());
        }
        string = string.substring(string.indexOf("(") + 1, string.indexOf(")"));
        return string;
    }

    private String getXPathPosition(Node node) {
        if (node.getParentNode() == null) {
            return "";
        }
        return this.getXPathPosition(node.getParentNode()) + "/" + node.getNodeName() + "[" + this.getNodeSiblingPosition(node) + "]";
    }

    private int getNodeSiblingPosition(Node node) {
        int n = 1;
        String string = node.getNodeName();
        short s = node.getNodeType();
        while (node.getPreviousSibling() != null) {
            if (node.getPreviousSibling().getNodeName().equals(string) && node.getPreviousSibling().getNodeType() == s) {
                ++n;
            }
            node = node.getPreviousSibling();
        }
        return n;
    }

    public static void main(String[] stringArray) {
        try {
            MusicApexWrapper musicApexWrapper = (MusicApexWrapper)MusicApexWrapper.readfile("sampleapex.xml");
            for (NoteGroup noteGroup : musicApexWrapper.getDepthFirstGroupView()) {
                ((ApexWrapedGroup)noteGroup).printGroupStat();
            }
            System.out.println(musicApexWrapper.getAspect());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Deprecated
    public static void printNodeStat(Node node) {
        int n;
        System.out.print("Name:" + node.getNodeName() + " Value:" + node.getNodeValue());
        System.out.println("Text:" + node.getTextContent());
        System.out.print("Attrs: ");
        for (n = 0; n < node.getAttributes().getLength(); ++n) {
            System.out.print(node.getAttributes().item(n) + ",");
        }
        System.out.print("Childs: ");
        for (n = 0; n < node.getChildNodes().getLength(); ++n) {
            System.out.print(node.getChildNodes().item(n).getNodeName() + ",");
        }
        System.out.println("\n");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ApexWrapedGroup
    implements NoteGroup {
        private int depth = -1;
        private List<MusicXMLWrapper.Note> ownnotes = new ArrayList<MusicXMLWrapper.Note>();
        private List<MusicXMLWrapper.Note> undernotes = new ArrayList<MusicXMLWrapper.Note>();
        private List<NoteGroup> subGroups = new ArrayList<NoteGroup>();
        private NoteGroup groupParent = null;
        private MusicXMLWrapper.Note apex = null;
        private double saliency = Double.NaN;

        private ApexWrapedGroup() {
        }

        @Override
        public int depth() {
            return this.depth;
        }

        @Override
        public boolean isApexInherited() {
            return MusicApexWrapper.this.inherited;
        }

        @Override
        public double getApexSaliency() {
            return this.saliency;
        }

        @Override
        public List<MusicXMLWrapper.Note> getNotes() {
            return this.ownnotes;
        }

        @Override
        public List<MusicXMLWrapper.Note> getAllNotes() {
            return this.undernotes;
        }

        @Override
        public MusicXMLWrapper.Note getApex() {
            return this.apex;
        }

        @Override
        public List<NoteGroup> getSubgroups() {
            return this.subGroups;
        }

        @Override
        public void addNote(MusicXMLWrapper.Note note) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeNote(MusicXMLWrapper.Note note) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addSubgroup(NoteGroup noteGroup) {
            throw new UnsupportedOperationException();
        }

        @Override
        public NoteGroup makeSubgroup(List<MusicXMLWrapper.Note> list) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setApex(MusicXMLWrapper.Note note) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeSubgroup(NoteGroup noteGroup) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAttribute(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAttribute(String string, String string2) {
            throw new UnsupportedOperationException();
        }

        public NoteGroup getParentGroup() {
            return this.groupParent;
        }

        @Deprecated
        public void printGroupStat() {
            System.out.println("toString:" + this.toString());
            System.out.println("depth:" + this.depth() + " subgroups:" + this.subGroups.size());
            System.out.println("notes:" + this.getNotes().size() + " parent:" + (this.groupParent != null ? this.groupParent.toString() : "null"));
            System.out.println();
        }

        @Override
        public List<MusicXMLWrapper.Note> getImplicitGroupNotes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isImplicit() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public MusicXMLWrapper.Note getApexStart() {
            return null;
        }

        @Override
        public double getApexStartTime() {
            return 0.0;
        }

        @Override
        public MusicXMLWrapper.Note getApexStop() {
            return null;
        }

        @Override
        public double getApexStopTime() {
            return 0.0;
        }

        @Override
        public void setApexStart(MusicXMLWrapper.Note note, double d) {
        }

        @Override
        public void setApexStop(MusicXMLWrapper.Note note, double d) {
        }

        @Override
        public void setApexSaliency(double d) {
        }

        @Override
        public void setImplicit(boolean bl) {
        }
    }
}

