/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.inference;

import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.math.DoubleMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LtoRHMMChain<O extends Observation> {
    Hmm<O>[] hmms;
    String[] labels;
    DoubleArray initprob;
    DoubleMatrix transprob;
    private boolean approx = true;

    public LtoRHMMChain(Hmm<O>[] hmmArray, String[] stringArray, DoubleArray doubleArray, DoubleMatrix doubleMatrix) {
        this.hmms = hmmArray;
        this.labels = stringArray;
        this.initprob = doubleArray;
        this.transprob = doubleMatrix;
    }

    public int nHMMs() {
        return this.hmms.length;
    }

    public void setApproximation(boolean bl) {
        this.approx = bl;
    }

    public double[][] calcLogLikelihood(O o, double[][] dArray) {
        double[][] dArrayArray = new double[this.hmms.length][];
        if (this.approx) {
            for (int i = 0; i < this.hmms.length; ++i) {
                int n;
                int n2 = this.hmms[i].nbStates();
                dArrayArray[i] = new double[n2];
                double d = this.hmms[i].getOpdf(0).probability(o);
                double d2 = Double.NEGATIVE_INFINITY;
                for (n = 0; n < this.hmms.length; ++n) {
                    double d3 = Math.log(this.transprob.get(n, i)) + dArray[n][dArray.length - 1];
                    if (!(d3 > d2)) continue;
                    d2 = d3;
                }
                dArrayArray[i][0] = Math.log(d) + d2;
                for (n = 1; n < n2; ++n) {
                    d = this.hmms[i].getOpdf(n).probability(o);
                    d2 = Double.NEGATIVE_INFINITY;
                    for (int j = 0; j < n2; ++j) {
                        double d4 = Math.log(this.hmms[i].getAij(j, n)) + dArray[i][j];
                        if (!(d4 > d2)) continue;
                        d2 = d4;
                    }
                    dArrayArray[i][n] = Math.log(d) + d2;
                }
            }
        } else {
            for (int i = 0; i < this.hmms.length; ++i) {
                int n;
                int n3 = this.hmms[i].nbStates();
                dArrayArray[i] = new double[n3];
                double d = this.hmms[i].getOpdf(0).probability(o);
                double d5 = 0.0;
                for (n = 0; n < this.hmms.length; ++n) {
                    d5 += this.transprob.get(n, i) * Math.exp(dArray[n][dArray.length - 1]);
                }
                dArrayArray[i][0] = Math.log(d) + Math.log(d5);
                for (n = 1; n < n3; ++n) {
                    d = this.hmms[i].getOpdf(n).probability(o);
                    d5 = 0.0;
                    for (int j = 0; j < n3; ++j) {
                        d5 += this.hmms[i].getAij(j, n) * Math.exp(dArray[i][j]);
                    }
                    dArrayArray[i][n] = Math.log(d) + Math.log(d5);
                }
            }
        }
        return dArrayArray;
    }

    public double[][] calcLogLikelihood1st(O o) {
        double[][] dArrayArray = new double[this.hmms.length][];
        for (int i = 0; i < this.hmms.length; ++i) {
            int n = this.hmms[i].nbStates();
            dArrayArray[i] = new double[n];
            double d = this.hmms[i].getOpdf(0).probability(o);
            dArrayArray[i][0] = Math.log(d) + Math.log(this.initprob.get(i));
            for (int j = 1; j < n; ++j) {
                dArrayArray[i][j] = Double.NEGATIVE_INFINITY;
            }
        }
        return dArrayArray;
    }
}

