/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.inference;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import jp.crestmuse.cmx.inference.Calculator;
import jp.crestmuse.cmx.sound.SequencerManager;

public class MusicRepresentation {
    private int measureNum;
    private int division;
    private HashMap<String, MusicLayer> name2layer;

    public MusicRepresentation(int n, int n2) {
        this.measureNum = n;
        this.division = n2;
        this.name2layer = new HashMap();
    }

    public int getMeasureNum() {
        return this.measureNum;
    }

    public int getDivision() {
        return this.division;
    }

    public void addMusicLayer(String string, int n) {
        this.addMusicLayer(string, n, 1);
    }

    public void addMusicLayer(String string, int n, int n2) {
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = i + "";
        }
        this.addMusicLayer(string, stringArray, n2);
    }

    public void addMusicLayer(String string, String[] stringArray) {
        this.addMusicLayer(string, stringArray, 1);
    }

    public void addMusicLayer(String string, String[] stringArray, int n) {
        this.name2layer.put(string, new MusicLayer(stringArray, this));
        this.name2layer.get(string).setTiedLength(n);
    }

    public MusicElement getMusicElement(String string, int n) {
        return this.name2layer.get(string).getElement(n);
    }

    public int getTiedLength(String string) {
        return this.name2layer.get(string).getTiedLength();
    }

    public void addCalculator(String string, Calculator calculator) {
        this.name2layer.get(string).addCalculator(calculator);
    }

    public int getIndex(long l) {
        return this.getIndex(l, SequencerManager.TICKS_PER_BEAT);
    }

    public int getIndex(long l, int n) {
        int n2 = n * 4;
        int n3 = (int)(l / (long)n2);
        int n4 = (int)(l % (long)n2) / (n2 / this.division);
        return n3 * this.division + n4;
    }

    public void update(String string, int n) {
        this.name2layer.get(string).update(n);
    }

    private class MusicLayer {
        MusicElement[] elements;
        List<Calculator> calculators;
        int tiedLength = 1;
        String[] labels;
        MusicRepresentation musRep;

        MusicLayer(String[] stringArray, MusicRepresentation musicRepresentation2) {
            this.elements = new MusicElement[MusicRepresentation.this.division * MusicRepresentation.this.measureNum];
            this.calculators = new LinkedList<Calculator>();
            this.labels = stringArray;
            this.musRep = musicRepresentation2;
        }

        MusicElement getElement(int n) {
            if (this.elements[n] == null) {
                this.addElement(n);
            }
            return this.elements[n];
        }

        int getTiedLength() {
            return this.tiedLength;
        }

        void setTiedLength(int n) {
            this.tiedLength = n;
            for (int i = 0; i < MusicRepresentation.this.division * MusicRepresentation.this.measureNum; i += this.tiedLength) {
                if (this.elements[i] == null) {
                    this.addElement(i);
                    continue;
                }
                MusicElement musicElement = this.elements[i];
                this.addElement(i);
                this.elements[i].copy(musicElement);
            }
        }

        void addCalculator(Calculator calculator) {
            this.calculators.add(calculator);
        }

        void addElement(int n) {
            int n2;
            MusicElement musicElement = new MusicElement(this.labels);
            for (int i = n2 = n / this.tiedLength * this.tiedLength; i < n2 + this.tiedLength && i < MusicRepresentation.this.division * MusicRepresentation.this.measureNum; ++i) {
                this.elements[i] = musicElement;
            }
        }

        void update(int n) {
            for (Calculator calculator : this.calculators) {
                calculator.update(this.musRep, this.elements[n], n);
            }
        }
    }

    public class MusicElement {
        private double[] prob;
        private boolean isEvidence;
        private int evidence;
        private boolean set = false;
        private String[] labels;

        public MusicElement(String[] stringArray) {
            this.prob = new double[stringArray.length];
            this.labels = stringArray;
        }

        public double getProb(int n) {
            if (this.isEvidence) {
                if (this.evidence == n) {
                    return 1.0;
                }
                return 0.0;
            }
            return this.prob[n];
        }

        public int getHighestProbIndex() {
            if (this.isEvidence) {
                return this.evidence;
            }
            double d = Double.MIN_VALUE;
            int n = 0;
            for (int i = 0; i < this.prob.length; ++i) {
                if (!(this.prob[i] > d)) continue;
                d = this.prob[i];
                n = i;
            }
            return n;
        }

        public int getRankedProbIndex(int n) {
            double[] dArray = (double[])this.prob.clone();
            Arrays.sort(dArray);
            for (int i = 0; i < this.prob.length; ++i) {
                if (this.prob[i] != dArray[dArray.length - 1 - n]) continue;
                return i;
            }
            return 0;
        }

        public int getProbLength() {
            return this.prob.length;
        }

        public boolean set() {
            return this.set;
        }

        public void setEvidence(int n) {
            this.set = true;
            this.isEvidence = true;
            this.evidence = n;
        }

        public void setProb(int n, double d) {
            this.set = true;
            this.isEvidence = false;
            this.prob[n] = d;
        }

        public String getLabel(int n) {
            return this.labels[n];
        }

        public int indexOf(String string) {
            for (int i = 0; i < this.labels.length; ++i) {
                if (!this.labels[i].equals(string)) continue;
                return i;
            }
            return -1;
        }

        private void copy(MusicElement musicElement) {
            this.prob = (double[])musicElement.prob.clone();
            this.isEvidence = musicElement.isEvidence;
            this.evidence = musicElement.evidence;
            this.set = musicElement.set;
            this.labels = (String[])this.labels.clone();
        }
    }
}

