/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.inference;

import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.ObservationInteger;
import be.ac.ulg.montefiore.run.jahmm.io.FileFormatException;
import be.ac.ulg.montefiore.run.jahmm.io.HmmReader;
import be.ac.ulg.montefiore.run.jahmm.io.OpdfIntegerReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jp.crestmuse.cmx.inference.MusicLayerListener;
import jp.crestmuse.cmx.inference.MusicRepresentation2;
import jp.crestmuse.cmx.inference.PriorProbCalculator;

public class SimpleHMMChainCalculator
implements MusicLayerListener {
    private List<Hmm<ObservationInteger>> hmms = new ArrayList<Hmm<ObservationInteger>>();
    private List<String> filenames = new ArrayList<String>();
    private List<String> labels = new ArrayList<String>();
    private String inputLayer;
    private String outputLayer;
    private PriorProbCalculator priorcalc;
    private MusicRepresentation2 mr = null;
    private int tiedLength;
    private int division;
    private ObservationInteger[] oseq;

    public SimpleHMMChainCalculator(File file, String string, String string2, PriorProbCalculator priorProbCalculator) throws IOException, FileFormatException {
        String string3;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        OpdfIntegerReader opdfIntegerReader = new OpdfIntegerReader();
        while ((string3 = bufferedReader.readLine()) != null) {
            if (string3.startsWith("#")) continue;
            string3 = string3.trim();
            String[] stringArray = string3.split(",");
            File file2 = new File(stringArray[0]);
            this.hmms.add(HmmReader.read(new BufferedReader(new FileReader(file2)), opdfIntegerReader));
            this.filenames.add(stringArray[0]);
            this.labels.add(stringArray[1]);
        }
        this.inputLayer = string;
        this.outputLayer = string2;
        this.priorcalc = priorProbCalculator;
    }

    public void update(MusicRepresentation2 musicRepresentation2, MusicRepresentation2.MusicElement musicElement, int n, int n2) {
        int n3;
        if (musicRepresentation2 != this.mr) {
            this.mr = musicRepresentation2;
            this.tiedLength = musicRepresentation2.getTiedLength(this.outputLayer);
            this.division = musicRepresentation2.getDivision();
            int n4 = musicRepresentation2.getMeasureNum();
            this.oseq = new ObservationInteger[n4 * this.division];
            for (n3 = 0; n3 < n4 * this.division; ++n3) {
                this.oseq[n3] = null;
            }
        }
        this.oseq[n * this.division + n2] = new ObservationInteger(musicElement.getHighestProbIndex());
        ArrayList<ObservationInteger> arrayList = new ArrayList<ObservationInteger>();
        n3 = (n * this.division + n2) / this.tiedLength * this.tiedLength;
        int n5 = ((n * this.division + n2) / this.tiedLength + 1) * this.tiedLength;
        for (int i = n3; i < n5; ++i) {
            if (this.oseq[i] == null) {
                MusicRepresentation2.MusicElement musicElement2 = musicRepresentation2.getMusicElement(this.inputLayer, i / this.division, i % this.division);
                this.oseq[i] = new ObservationInteger(musicElement.getHighestProbIndex());
            }
            arrayList.add(this.oseq[i]);
        }
        double d = Double.NEGATIVE_INFINITY;
        int n6 = -1;
        for (int i = 0; i < this.hmms.size(); ++i) {
            double d2;
            double d3 = 1.0;
            if (this.priorcalc != null) {
                d3 = this.priorcalc.calcPriorProb(this.labels.get(i), null, musicRepresentation2, n, n2);
            }
            if (!((d2 = this.hmms.get(i).probability(arrayList) * d3) > d)) continue;
            d = d2;
            n6 = i;
        }
        MusicRepresentation2.MusicElement musicElement3 = musicRepresentation2.getMusicElement(this.outputLayer, n, n2);
        musicElement3.setEvidence(musicElement3.addNewLabel(this.labels.get(n6)));
    }
}

