/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.math;

import java.math.BigDecimal;
import java.util.List;
import jp.crestmuse.cmx.math.AbstractDoubleMatrixImpl;
import jp.crestmuse.cmx.math.BooleanArrayFactory;
import jp.crestmuse.cmx.math.ComplexArray;
import jp.crestmuse.cmx.math.ComplexArrayFactory;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.math.DoubleArrayFactory;
import jp.crestmuse.cmx.math.DoubleMatrix;
import jp.crestmuse.cmx.math.DoubleMatrixFactory;
import jp.crestmuse.cmx.math.MathException;
import org.apache.commons.math.linear.AbstractRealMatrix;
import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.linear.MatrixIndexException;
import org.apache.commons.math.linear.RealMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final DoubleArrayFactory factory = DoubleArrayFactory.getFactory();
    private static final BooleanArrayFactory bfactory = BooleanArrayFactory.getFactory();
    private static final DoubleMatrixFactory mfactory = DoubleMatrixFactory.getFactory();
    private static final ComplexArrayFactory cfactory = ComplexArrayFactory.getFactory();

    public static DoubleArray cloneArray(DoubleArray doubleArray) {
        try {
            return (DoubleArray)doubleArray.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            int n = doubleArray.length();
            DoubleArray doubleArray2 = factory.createArray(n);
            for (int i = 0; i < n; ++i) {
                doubleArray2.set(i, doubleArray.get(i));
            }
            return doubleArray2;
        }
    }

    public static String toString(DoubleArray doubleArray, String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        int n = doubleArray.length();
        if (n >= 1) {
            stringBuilder.append(String.valueOf(doubleArray.get(0)));
            for (int i = 1; i < n; ++i) {
                stringBuilder.append(string);
                stringBuilder.append(String.valueOf(doubleArray.get(i)));
            }
        }
        stringBuilder.append(string3);
        return stringBuilder.toString();
    }

    public static String toString(DoubleArray doubleArray) {
        return Utils.toString1(doubleArray);
    }

    public static String toString1(DoubleArray doubleArray) {
        return Utils.toString(doubleArray, ", ", "{", "}");
    }

    public static String toString2(DoubleArray doubleArray) {
        return Utils.toString(doubleArray, " ", "", "");
    }

    public static String toString(ComplexArray complexArray, String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        int n = complexArray.length();
        if (n >= 1) {
            stringBuilder.append(String.valueOf(complexArray.getReal(0))).append(" + ");
            stringBuilder.append(String.valueOf(complexArray.getImag(0))).append(" i");
            for (int i = 1; i < n; ++i) {
                stringBuilder.append(string);
                stringBuilder.append(String.valueOf(complexArray.getReal(i))).append(" + ");
                stringBuilder.append(String.valueOf(complexArray.getImag(i))).append(" i");
            }
        }
        stringBuilder.append(string3);
        return stringBuilder.toString();
    }

    public static String toString(ComplexArray complexArray) {
        return Utils.toString1(complexArray);
    }

    public static String toString1(ComplexArray complexArray) {
        return Utils.toString(complexArray, ", ", "{", "}");
    }

    public static String toString2(ComplexArray complexArray) {
        return Utils.toString(complexArray, " ", "", "");
    }

    public static String toString(DoubleMatrix doubleMatrix) {
        return Utils.toString1(doubleMatrix);
    }

    public static String toString(DoubleMatrix doubleMatrix, String string, String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string3);
        int n = doubleMatrix.nrows();
        if (n >= 1) {
            Utils.appendRowString(doubleMatrix, 0, string, stringBuilder);
            for (int i = 1; i < n; ++i) {
                stringBuilder.append(string2);
                Utils.appendRowString(doubleMatrix, i, string, stringBuilder);
            }
        }
        stringBuilder.append(string4);
        return stringBuilder.toString();
    }

    private static void appendRowString(DoubleMatrix doubleMatrix, int n, String string, StringBuilder stringBuilder) {
        int n2 = doubleMatrix.ncols();
        if (n2 >= 1) {
            stringBuilder.append(String.valueOf(doubleMatrix.get(n, 0)));
            for (int i = 1; i < n2; ++i) {
                stringBuilder.append(string);
                stringBuilder.append(String.valueOf(doubleMatrix.get(n, i)));
            }
        }
    }

    public static String toString1(DoubleMatrix doubleMatrix) {
        return Utils.toString(doubleMatrix, ", ", ";\n", "{", "}");
    }

    public static String toString2(DoubleMatrix doubleMatrix) {
        return Utils.toString(doubleMatrix, " ", "\n", "", "");
    }

    public static DoubleArray parseArray(String string, String string2) {
        String[] stringArray = string.trim().split(string2);
        int n = stringArray.length;
        DoubleArray doubleArray = factory.createArray(n);
        for (int i = 0; i < n; ++i) {
            doubleArray.set(i, Double.parseDouble(stringArray[i]));
        }
        return doubleArray;
    }

    public static DoubleArray parseArray(String string) {
        return Utils.parseArray(string, " ");
    }

    public static DoubleMatrix parseMatrix(String string, String string2, String string3) {
        String[] stringArray = string.trim().split(string3);
        int n = stringArray.length;
        int n2 = stringArray[0].trim().split(string2).length;
        DoubleMatrix doubleMatrix = mfactory.createMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            String[] stringArray2 = stringArray[i].split(string2);
            if (n2 != stringArray2.length) {
                throw new IllegalStateException("inconsistent data size");
            }
            for (int j = 0; j < n2; ++j) {
                doubleMatrix.set(i, j, Double.parseDouble(stringArray2[j]));
            }
        }
        return doubleMatrix;
    }

    public static DoubleMatrix parseMatrix(String string) {
        return Utils.parseMatrix(string, " ", "\n");
    }

    public static final DoubleArray createDoubleArray(int n) {
        return factory.createArray(n);
    }

    public static final DoubleArray createDoubleArray(double[] dArray) {
        return factory.createArray(dArray);
    }

    public static final DoubleArray createDoubleArray(List<BigDecimal> list) {
        int n = list.size();
        DoubleArray doubleArray = Utils.createDoubleArray(n);
        for (int i = 0; i < n; ++i) {
            doubleArray.set(i, list.get(i).doubleValue());
        }
        return doubleArray;
    }

    public static final ComplexArray createComplexArray(int n) {
        return cfactory.createArray(n);
    }

    public static final ComplexArray createComplexArray(double[] dArray, double[] dArray2) {
        return cfactory.createArray(dArray, dArray2);
    }

    public static final ComplexArray createComplexArray(List<BigDecimal> list, List<BigDecimal> list2) {
        int n = list.size();
        ComplexArray complexArray = Utils.createComplexArray(n);
        for (int i = 0; i < n; ++i) {
            complexArray.set(i, list.get(i).doubleValue(), list2.get(i).doubleValue());
        }
        return complexArray;
    }

    public static final DoubleMatrix createDoubleMatrix(int n, int n2) {
        return mfactory.createMatrix(n, n2);
    }

    public static final DoubleMatrix createDoubleMatrix(double[][] dArray) {
        return mfactory.createMatrix(dArray);
    }

    public static final DoubleMatrix createDoubleMatrix(List<List<BigDecimal>> list) {
        int n = list.size();
        int n2 = list.get(0).size();
        DoubleMatrix doubleMatrix = Utils.createDoubleMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            List<BigDecimal> list2 = list.get(i);
            for (int j = 0; j < n2; ++j) {
                doubleMatrix.set(i, j, list2.get(j).doubleValue());
            }
        }
        return doubleMatrix;
    }

    public static final DoubleMatrix createSparseDoubleMatrix(int n, int n2) {
        return mfactory.createSparseMatrix(n, n2);
    }

    public static final DoubleArray create1dimDoubleArray(double d) {
        DoubleArray doubleArray = factory.createArray(1);
        doubleArray.set(0, d);
        return doubleArray;
    }

    public static final RealMatrix toRealMatrix(DoubleMatrix doubleMatrix) {
        return new MyRealMatrix(doubleMatrix);
    }

    public static DoubleMatrix toDoubleMatrix(RealMatrix realMatrix) {
        return new MyDoubleMatrix(realMatrix);
    }

    private static class MyDoubleMatrix
    extends AbstractDoubleMatrixImpl {
        private RealMatrix x;

        private MyDoubleMatrix(RealMatrix realMatrix) {
            this.x = realMatrix;
        }

        public int nrows() {
            return this.x.getRowDimension();
        }

        public int ncols() {
            return this.x.getColumnDimension();
        }

        public double get(int n, int n2) {
            return this.x.getEntry(n, n2);
        }

        public void set(int n, int n2, double d) {
            try {
                this.x.setEntry(n, n2, d);
            }
            catch (MatrixIndexException matrixIndexException) {
                throw new MathException((Exception)((Object)matrixIndexException));
            }
        }
    }

    private static class MyRealMatrix
    extends AbstractRealMatrix {
        private DoubleMatrix x;

        private MyRealMatrix(DoubleMatrix doubleMatrix) {
            this.x = doubleMatrix;
        }

        public void addToEntry(int n, int n2, double d) {
            this.x.set(n, n2, this.x.get(n, n2) + d);
        }

        public RealMatrix copy() {
            try {
                return new MyRealMatrix(this.x.clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new UnsupportedOperationException();
            }
        }

        public RealMatrix createMatrix(int n, int n2) {
            return new Array2DRowRealMatrix(n, n2);
        }

        public int getColumnDimension() {
            return this.x.ncols();
        }

        public double getEntry(int n, int n2) {
            return this.x.get(n, n2);
        }

        public int getRowDimension() {
            return this.x.nrows();
        }

        public void multiplyEntry(int n, int n2, double d) {
            this.x.set(n, n2, this.x.get(n, n2) * d);
        }

        public void setEntry(int n, int n2, double d) {
            this.x.set(n, n2, d);
        }
    }
}

