/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.misc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.DeviationDataSet;
import jp.crestmuse.cmx.filewrappers.DeviationInstanceWrapper;
import jp.crestmuse.cmx.filewrappers.MIDIXMLWrapper;
import jp.crestmuse.cmx.filewrappers.MusicXMLWrapper;
import jp.crestmuse.cmx.filewrappers.SCCXMLWrapper;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformanceMatcher3 {
    private static int baseTempo = 120;
    private static final double BASE_DYNAMICS = 100.0;
    private static final double ATTACK_LIMIT = 2000.0;
    private static double rowRiscInc = 1.0;
    private static double colRiscInc = 0.0;
    private static double ioiWeight = 1.6;
    public static String DTW_PATH_FILENAME = null;
    public static double MISS_EXTRA_ONSET_DIFF = 0.4;
    private MusicXMLWrapper musicxml;
    private MIDIXMLWrapper midixml;
    private String partid;
    private MusicXMLWrapper.Measure[] measurelist;
    private SCCXMLWrapper.Note[] scoreNotes;
    private SCCXMLWrapper.Note[] pfmNotes;
    private List<NoteInSameTime> compressedScore;
    private SCCXMLWrapper.Annotation[] barlines;
    private int scoreTicksPerBeat;
    private int pfmTicksPerBeat;
    private int[] score2pfm;
    private Map<MusicXMLWrapper.Note, Integer> musicxmlwrappernote2index;
    private Map<SCCXMLWrapper.Note, Integer> extraNoteMap;
    private int i = 0;
    private int lastMeasureIndex = 0;

    public static void setRowRiscInc(double d) {
        rowRiscInc = d;
    }

    public static void setColRiscInc(double d) {
        colRiscInc = d;
    }

    public static void setIoiWeight(double d) {
        ioiWeight = d;
    }

    public PerformanceMatcher3(MusicXMLWrapper musicXMLWrapper, MIDIXMLWrapper mIDIXMLWrapper) throws ParserConfigurationException, SAXException, IOException, TransformerException {
        this(musicXMLWrapper, mIDIXMLWrapper, mIDIXMLWrapper.ticksPerBeat());
    }

    public PerformanceMatcher3(MusicXMLWrapper musicXMLWrapper, MIDIXMLWrapper mIDIXMLWrapper, int n) throws ParserConfigurationException, SAXException, IOException, TransformerException {
        this.musicxml = musicXMLWrapper;
        this.midixml = mIDIXMLWrapper;
        MusicXMLWrapper.Part part = this.musicxml.getPartList()[0];
        this.measurelist = part.getMeasureList();
        this.partid = part.id();
        SCCXMLWrapper sCCXMLWrapper = musicXMLWrapper.makeDeadpanSCCXML(n);
        SCCXMLWrapper sCCXMLWrapper2 = mIDIXMLWrapper.toSCCXML();
        this.barlines = sCCXMLWrapper.getBarlineList();
        this.scoreNotes = sCCXMLWrapper.getPartList()[0].getSortedNoteOnlyList(1);
        this.calcMusicXMLNote2Index();
        this.pfmNotes = sCCXMLWrapper2.getPartList()[0].getSortedNoteOnlyList(1);
        this.initCompressedScore();
        this.scoreTicksPerBeat = sCCXMLWrapper.getDivision();
        this.pfmTicksPerBeat = sCCXMLWrapper2.getDivision();
        SCCXMLWrapper.HeaderElement[] headerElementArray = sCCXMLWrapper2.getHeaderElementList();
        if (headerElementArray.length >= 1 && headerElementArray[0].name().equals("TEMPO")) {
            baseTempo = Integer.parseInt(headerElementArray[0].content());
        }
        this.extraNoteMap = new HashMap<SCCXMLWrapper.Note, Integer>();
    }

    private void calcMusicXMLNote2Index() {
        this.musicxmlwrappernote2index = new HashMap<MusicXMLWrapper.Note, Integer>();
        for (int i = 0; i < this.scoreNotes.length; ++i) {
            this.musicxmlwrappernote2index.put(this.scoreNotes[i].getMusicXMLWrapperNote(), i);
        }
    }

    public DeviationInstanceWrapper extractDeviation() throws ParserConfigurationException, SAXException, IOException, TransformerException {
        ArrayList<SCCXMLWrapper.Note> arrayList = new ArrayList<SCCXMLWrapper.Note>();
        this.score2pfm = this.getPath(this.dtw(500), arrayList);
        if (DTW_PATH_FILENAME != null) {
            this.writePathToFile(DTW_PATH_FILENAME);
        }
        return this.path2dev(arrayList);
    }

    public DeviationInstanceWrapper extractDeviation(File file) throws ParserConfigurationException, SAXException, IOException, TransformerException {
        ArrayList<SCCXMLWrapper.Note> arrayList = new ArrayList<SCCXMLWrapper.Note>();
        this.score2pfm = this.getPath(file, arrayList);
        return this.path2dev(arrayList);
    }

    public DeviationInstanceWrapper extractDeviation(int[] nArray) {
        ArrayList<SCCXMLWrapper.Note> arrayList = new ArrayList<SCCXMLWrapper.Note>();
        this.score2pfm = this.getPath(nArray, arrayList);
        int[] nArray2 = (int[])this.score2pfm.clone();
        DeviationInstanceWrapper deviationInstanceWrapper = this.path2dev(arrayList);
        for (int i = 0; i < this.score2pfm.length; ++i) {
            if (this.score2pfm[i] == nArray2[i]) continue;
            System.err.println("NOT SAME: " + i + "  " + this.score2pfm[i] + " " + nArray2[i]);
        }
        return deviationInstanceWrapper;
    }

    private int[] getPath(DTWMatrix dTWMatrix, List<SCCXMLWrapper.Note> list) {
        Object object;
        int n;
        int n2 = dTWMatrix.nrows;
        int n3 = dTWMatrix.ncols;
        NoteInSameTime[] noteInSameTimeArray = new NoteInSameTime[this.compressedScore.size()];
        for (n = 0; n < noteInSameTimeArray.length; ++n) {
            noteInSameTimeArray[n] = new NoteInSameTime();
        }
        n = n2 - 1;
        int n4 = n3 - 1;
        do {
            noteInSameTimeArray[n].addNote(this.pfmNotes[n4], n4);
            object = dTWMatrix.get(n, n4);
            n = ((DTWMatrix.DTWMatrixElement)object).targetX;
            n4 = ((DTWMatrix.DTWMatrixElement)object).targetY;
        } while (n >= 0 || n4 >= 0);
        object = new int[this.scoreNotes.length];
        Arrays.fill((int[])object, -1);
        boolean[] blArray = new boolean[this.pfmNotes.length];
        for (n = 0; n < noteInSameTimeArray.length; ++n) {
            NoteInSameTime noteInSameTime = this.compressedScore.get(n);
            NoteInSameTime noteInSameTime2 = noteInSameTimeArray[n];
            block3: for (n4 = 0; n4 < noteInSameTime.notes.size(); ++n4) {
                for (int i = 0; i < noteInSameTime2.notes.size(); ++i) {
                    int n5 = noteInSameTime2.indexes.get(i);
                    if (noteInSameTime.notes.get(n4).notenum() != noteInSameTime2.notes.get(i).notenum() || blArray[n5]) continue;
                    object[noteInSameTime.indexes.get((int)n4).intValue()] = n5;
                    blArray[n5] = true;
                    continue block3;
                }
            }
        }
        for (n4 = 0; n4 < blArray.length; ++n4) {
            if (blArray[n4]) continue;
            list.add(this.pfmNotes[n4]);
            this.extraNoteMap.put(this.pfmNotes[n4], n4);
        }
        return object;
    }

    private int[] getPath(File file, List<SCCXMLWrapper.Note> list) throws IOException {
        int n;
        Object[] objectArray;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        int n2 = Integer.parseInt(bufferedReader.readLine());
        int[] nArray = new int[n2];
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            objectArray = string.split("\t");
            nArray[Integer.parseInt((String)objectArray[0])] = Integer.parseInt(objectArray[1]);
        }
        bufferedReader.close();
        objectArray = new boolean[this.pfmNotes.length];
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] < 0) continue;
            objectArray[nArray[n]] = (String)true;
        }
        for (n = 0; n < objectArray.length; ++n) {
            if (objectArray[n] != false) continue;
            list.add(this.pfmNotes[n]);
            this.extraNoteMap.put(this.pfmNotes[n], n);
        }
        return nArray;
    }

    private int[] getPath(int[] nArray, List<SCCXMLWrapper.Note> list) {
        int n;
        boolean[] blArray = new boolean[this.pfmNotes.length];
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] < 0) continue;
            blArray[nArray[n]] = true;
        }
        for (n = 0; n < blArray.length; ++n) {
            if (blArray[n]) continue;
            list.add(this.pfmNotes[n]);
            this.extraNoteMap.put(this.pfmNotes[n], n);
        }
        return nArray;
    }

    private void writePathToFile(String string) throws IOException {
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
        printWriter.println(this.score2pfm.length);
        for (int i = 0; i < this.score2pfm.length; ++i) {
            printWriter.println(i + "\t" + this.score2pfm[i] + "\t# " + this.scoreNotes[i] + " | " + (this.score2pfm[i] >= 0 ? this.pfmNotes[this.score2pfm[i]] : ""));
        }
        printWriter.close();
    }

    private DeviationInstanceWrapper path2dev(List<SCCXMLWrapper.Note> list) {
        DeviationDataSet deviationDataSet = new DeviationDataSet(this.musicxml);
        ArrayList<TempoAndTime> arrayList = this.alignBeats();
        this.interpolateBeatTime(arrayList);
        double d = this.calcTempo(arrayList);
        double d2 = arrayList.get(1).timeInSec;
        deviationDataSet.setInitialSilence(d2);
        int n = this.measurelist[0].number();
        deviationDataSet.addNonPartwiseControl(n, 1.0, "tempo", d);
        this.addTempoDeviations(deviationDataSet, arrayList, d);
        this.checkMissAndExtraNotes(list, arrayList);
        this.setNotewiseDeviations(deviationDataSet, list, arrayList);
        return deviationDataSet.toWrapper();
    }

    public static DeviationInstanceWrapper extractDeviation(MusicXMLWrapper musicXMLWrapper, MIDIXMLWrapper mIDIXMLWrapper) throws ParserConfigurationException, SAXException, IOException, TransformerException {
        PerformanceMatcher3 performanceMatcher3 = new PerformanceMatcher3(musicXMLWrapper, mIDIXMLWrapper);
        return performanceMatcher3.extractDeviation();
    }

    public static DeviationInstanceWrapper extractDeviation(MusicXMLWrapper musicXMLWrapper, MIDIXMLWrapper mIDIXMLWrapper, File file) throws ParserConfigurationException, SAXException, IOException, TransformerException {
        PerformanceMatcher3 performanceMatcher3 = new PerformanceMatcher3(musicXMLWrapper, mIDIXMLWrapper);
        return performanceMatcher3.extractDeviation(file);
    }

    public static DeviationInstanceWrapper extractDeviation(MusicXMLWrapper musicXMLWrapper, MIDIXMLWrapper mIDIXMLWrapper, int n) throws ParserConfigurationException, SAXException, IOException, TransformerException {
        PerformanceMatcher3 performanceMatcher3 = new PerformanceMatcher3(musicXMLWrapper, mIDIXMLWrapper, n);
        return performanceMatcher3.extractDeviation();
    }

    public static DeviationInstanceWrapper extractDeviation(MusicXMLWrapper musicXMLWrapper, MIDIXMLWrapper mIDIXMLWrapper, int n, File file) throws ParserConfigurationException, SAXException, IOException, TransformerException {
        PerformanceMatcher3 performanceMatcher3 = new PerformanceMatcher3(musicXMLWrapper, mIDIXMLWrapper, n);
        return performanceMatcher3.extractDeviation(file);
    }

    public int[] getScore2Pfm() {
        return this.score2pfm;
    }

    public Map<MusicXMLWrapper.Note, Integer> getMusicxmlwrappernote2Index() {
        return this.musicxmlwrappernote2index;
    }

    public Map<SCCXMLWrapper.Note, Integer> getExtraNoteMap() {
        return this.extraNoteMap;
    }

    private DTWMatrix dtw(int n) {
        int n2 = this.compressedScore.size();
        int n3 = this.pfmNotes.length;
        int n4 = this.compressedScore.get((int)(n2 - 1)).notes.get(0).offset();
        int n5 = this.pfmNotes[n3 - 1].offset();
        n = n3;
        DTWMatrix dTWMatrix = new DTWMatrix(n2, n3);
        dTWMatrix.set(-1, -1, 0.0, -1, -1);
        double[] dArray = new double[n2];
        Arrays.fill(dArray, colRiscInc);
        for (int i = 0; i < n2; ++i) {
            double d = rowRiscInc;
            for (int j = Math.max(0, i - n); j <= Math.min(i + n, n3 - 1); ++j) {
                double d2;
                NoteInSameTime noteInSameTime = this.compressedScore.get(i);
                SCCXMLWrapper.Note note = this.pfmNotes[j];
                double d3 = 0.0;
                if (i > 0 && j > 0) {
                    int n6 = noteInSameTime.notes.get(0).onset() - this.compressedScore.get((int)(i - 1)).notes.get(0).onset();
                    int n7 = note.onset() - this.pfmNotes[j - 1].onset();
                    d3 = n7 == 0 ? Double.POSITIVE_INFINITY : (double)n6 / (double)n7;
                }
                double d4 = this.dist(noteInSameTime, note, n4, n5);
                double d5 = dTWMatrix.getValue(i - 1, j) + d4 + dArray[i];
                double d6 = dTWMatrix.getValue(i - 1, j - 1) + 2.0 * d4 + d3 * ioiWeight;
                double d7 = Math.min(d6, Math.min(d5, d2 = dTWMatrix.getValue(i, j - 1) + d4 + d));
                if (d7 == d6) {
                    dTWMatrix.set(i, j, d7, i - 1, j - 1);
                    dArray[i] = colRiscInc;
                    d = rowRiscInc;
                    continue;
                }
                if (d7 == d2) {
                    dTWMatrix.set(i, j, d7, i, j - 1);
                    dArray[i] = colRiscInc;
                    d += rowRiscInc;
                    continue;
                }
                dTWMatrix.set(i, j, d7, i - 1, j);
                int n8 = i;
                dArray[n8] = dArray[n8] + colRiscInc;
                d = rowRiscInc;
            }
        }
        return dTWMatrix;
    }

    private double dist(NoteInSameTime noteInSameTime, SCCXMLWrapper.Note note, int n, int n2) {
        double d = Math.abs((double)noteInSameTime.notes.get(0).onset() / (double)n - (double)note.onset() / (double)n2);
        for (SCCXMLWrapper.Note note2 : noteInSameTime.notes) {
            if (note2.notenum() != note.notenum()) continue;
            return d;
        }
        return 100.0;
    }

    private void initCompressedScore() {
        this.compressedScore = new ArrayList<NoteInSameTime>();
        NoteBuffer noteBuffer = new NoteBuffer();
        for (int i = 0; i < this.scoreNotes.length; ++i) {
            if (i >= 1 && this.scoreNotes[i].onset() != this.scoreNotes[i - 1].onset()) {
                this.addNotesToCompressedScore(noteBuffer, this.compressedScore);
                noteBuffer = new NoteBuffer();
            }
            noteBuffer.addNote(this.scoreNotes[i], i);
        }
        this.addNotesToCompressedScore(noteBuffer, this.compressedScore);
    }

    private void addNotesToCompressedScore(NoteBuffer noteBuffer, List<NoteInSameTime> list) {
        int n = 1;
        while (noteBuffer.next[n] > 0) {
            NoteInSameTime noteInSameTime = new NoteInSameTime();
            for (int i = 0; i < noteBuffer.next[n]; ++i) {
                noteInSameTime.addNote(noteBuffer.notes[n][i], noteBuffer.indices[n][i]);
            }
            list.add(noteInSameTime);
            ++n;
        }
        NoteInSameTime noteInSameTime = new NoteInSameTime();
        for (int i = 0; i < noteBuffer.next[0]; ++i) {
            noteInSameTime.addNote(noteBuffer.notes[0][i], noteBuffer.indices[0][i]);
        }
        list.add(noteInSameTime);
    }

    private void sortIndexList() {
        for (int i = 0; i < this.score2pfm.length - 1; ++i) {
            if (this.score2pfm[i] <= this.score2pfm[i + 1] || this.score2pfm[i + 1] == -1) continue;
            SCCXMLWrapper.Note note = this.pfmNotes[this.score2pfm[i]];
            this.pfmNotes[this.score2pfm[i]] = this.pfmNotes[this.score2pfm[i + 1]];
            this.pfmNotes[this.score2pfm[i + 1]] = note;
            int n = this.score2pfm[i];
            this.score2pfm[i] = this.score2pfm[i + 1];
            this.score2pfm[i + 1] = n;
        }
    }

    private void alignNotes(int[] nArray, int[] nArray2, List<SCCXMLWrapper.Note> list) {
        int n;
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = -1;
        }
        boolean[] blArray = new boolean[this.pfmNotes.length];
        for (n = 0; n < blArray.length; ++n) {
            blArray[n] = false;
        }
        n = 0;
        int n2 = 0;
        while (n < nArray2.length - 1) {
            if (nArray2[n] == -1 && !blArray[n2] && this.scoreNotes[n].notenum() == this.pfmNotes[n2].notenum()) {
                nArray2[n] = n2;
                blArray[n2] = true;
                if (nArray[n + 1] == n2) {
                    ++n;
                    continue;
                }
                if (nArray[n + 1] - n2 > 1) {
                    ++n2;
                    continue;
                }
                ++n;
                ++n2;
                continue;
            }
            if (nArray[n + 1] == n2) {
                ++n;
                continue;
            }
            if (nArray[n + 1] - n2 > 1) {
                if (!blArray[n2]) {
                    list.add(this.pfmNotes[n2]);
                    blArray[n2] = true;
                }
                ++n2;
                continue;
            }
            if (!blArray[n2]) {
                list.add(this.pfmNotes[n2]);
                blArray[n2] = true;
            }
            ++n;
            ++n2;
        }
        if (nArray2[n] == -1 && !blArray[n2] && this.scoreNotes[n].notenum() == this.pfmNotes[n2].notenum()) {
            nArray2[n] = n2;
        } else {
            list.add(this.pfmNotes[n2]);
        }
    }

    private void setNotewiseDeviations(DeviationDataSet deviationDataSet, List<SCCXMLWrapper.Note> list, ArrayList<TempoAndTime> arrayList) {
        for (int i = 0; i < this.score2pfm.length; ++i) {
            int n = this.score2pfm[i];
            if (n >= 0) {
                this.addNoteDeviation(deviationDataSet, this.scoreNotes[i], this.pfmNotes[n], arrayList);
                continue;
            }
            if (this.score2pfm[i] < -1) continue;
            this.addMissNote(deviationDataSet, this.scoreNotes[i]);
        }
        for (SCCXMLWrapper.Note note : list) {
            if (note == null) continue;
            this.addExtraNote(deviationDataSet, note, this.partid, arrayList);
        }
    }

    private void checkMissAndExtraNotes(List<SCCXMLWrapper.Note> list, ArrayList<TempoAndTime> arrayList) {
        block0: for (int i = 0; i < this.score2pfm.length; ++i) {
            if (this.score2pfm[i] >= 0) continue;
            SCCXMLWrapper.Note note = this.scoreNotes[i];
            double d = this.getSecFromScoreTick(note.onset(), arrayList);
            int n = note.notenum();
            for (int j = 0; j < list.size(); ++j) {
                double d2;
                int n2;
                SCCXMLWrapper.Note note2 = list.get(j);
                if (note2 == null || n != (n2 = note2.notenum()) || !(d - (d2 = this.getSecFromPfmTick(note2.onset(), arrayList)) < MISS_EXTRA_ONSET_DIFF) || !(d2 - d < MISS_EXTRA_ONSET_DIFF)) continue;
                for (int k = 0; k < this.pfmNotes.length; ++k) {
                    if (this.pfmNotes[k] != note2) continue;
                    this.score2pfm[i] = k;
                    list.set(j, null);
                    continue block0;
                }
            }
        }
    }

    private double getSecFromScoreTick(int n, List<TempoAndTime> list) {
        TempoAndTime tempoAndTime = list.get(0);
        for (TempoAndTime tempoAndTime2 : list) {
            if (n < tempoAndTime2.tickInScore) break;
            tempoAndTime = tempoAndTime2;
        }
        return tempoAndTime.timeInSec + (double)(n - tempoAndTime.tickInScore) * 60.0 / ((double)this.scoreTicksPerBeat * tempoAndTime.tempo);
    }

    private double getSecFromPfmTick(int n, List<TempoAndTime> list) {
        TempoAndTime tempoAndTime = list.get(0);
        for (TempoAndTime tempoAndTime2 : list) {
            if ((double)n < tempoAndTime2.tickInPfm) break;
            tempoAndTime = tempoAndTime2;
        }
        return tempoAndTime.timeInSec + ((double)n - tempoAndTime.tickInPfm) * 60.0 / (double)(this.pfmTicksPerBeat * baseTempo);
    }

    private TempoAndTime searchTnT(double d, ArrayList<TempoAndTime> arrayList) {
        int n = arrayList.size();
        while (this.i >= n - 1 || arrayList.get(this.i).tickInPfm > d && this.i > 0) {
            --this.i;
        }
        while (this.i < 0 || arrayList.get(this.i + 1).tickInPfm <= d && this.i < n - 2) {
            ++this.i;
        }
        return arrayList.get(this.i);
    }

    private void addNoteDeviation(DeviationDataSet deviationDataSet, SCCXMLWrapper.Note note, SCCXMLWrapper.Note note2, ArrayList<TempoAndTime> arrayList) {
        double d;
        double d2;
        double d3;
        double d4;
        int n = (int)arrayList.get(0).tickInPfm;
        TempoAndTime tempoAndTime = this.searchTnT(note2.onset(), arrayList);
        if (tempoAndTime.measure >= 0) {
            d4 = (double)note2.onset() - tempoAndTime.tickInPfm;
            d3 = note.onset() - tempoAndTime.tickInScore;
        } else {
            d4 = (double)note2.onset() - arrayList.get(1).tickInPfm;
            d3 = note.onset() - arrayList.get(1).tickInScore;
        }
        double d5 = d4 * tempoAndTime.tempo / (double)(this.pfmTicksPerBeat * baseTempo) - d3 / (double)this.scoreTicksPerBeat;
        tempoAndTime = this.searchTnT(note2.offset(), arrayList);
        if (tempoAndTime.measure >= 0) {
            d2 = (double)note2.offset() - tempoAndTime.tickInPfm;
            d = note.offset() - tempoAndTime.tickInScore;
        } else {
            d2 = (double)note2.offset() - arrayList.get(1).tickInPfm;
            d = note.offset() - arrayList.get(1).tickInScore;
        }
        double d6 = d2 * tempoAndTime.tempo / (double)(this.pfmTicksPerBeat * baseTempo) - d / (double)this.scoreTicksPerBeat;
        double d7 = (double)note2.velocity() / 100.0;
        if (Math.abs(d5) > 2000.0) {
            this.addMissNote(deviationDataSet, note);
            this.addExtraNote(deviationDataSet, note2, this.partid, arrayList);
        } else {
            deviationDataSet.addNoteDeviation(note.getMusicXMLWrapperNote(), d5, d6, d7, d7);
        }
    }

    private void addMissNote(DeviationDataSet deviationDataSet, SCCXMLWrapper.Note note) {
        deviationDataSet.addMissNote(note.getMusicXMLWrapperNote());
    }

    private void addExtraNote(DeviationDataSet deviationDataSet, SCCXMLWrapper.Note note, String string, ArrayList<TempoAndTime> arrayList) {
        TempoAndTime tempoAndTime;
        int n;
        TempoAndTime tempoAndTime2;
        int n2;
        int n3 = arrayList.size();
        for (n2 = 0; !(n2 >= n3 || (tempoAndTime2 = arrayList.get(n2)).measure == -1 && tempoAndTime2.beat == -1 || tempoAndTime2.tickInPfm > (double)note.onset()); ++n2) {
        }
        tempoAndTime2 = arrayList.get(n2 - 1);
        double d = ((double)note.onset() - tempoAndTime2.tickInPfm) / tempoAndTime2.beatLength();
        for (n = n2 - 1; !(n >= n3 || (tempoAndTime = arrayList.get(n)).measure == -1 && tempoAndTime.beat == -1 || tempoAndTime.tickInPfm > (double)note.offset()); ++n) {
        }
        tempoAndTime = arrayList.get(n - 1);
        double d2 = ((double)note.offset() - tempoAndTime.tickInPfm) / tempoAndTime.beatLength();
        deviationDataSet.addExtraNote(string, tempoAndTime2.measure, (double)tempoAndTime2.beat + d, note.notenum(), (double)(n - n2) + d2 - d, (double)note.velocity() / 100.0, (double)note.velocity() / 100.0);
    }

    private boolean tickcmp(int n, int n2, int n3) {
        return n >= n2 - n3 && n <= n2 + n3;
    }

    private TempoAndTime getZerothTempoAndTime() {
        TempoAndTime tempoAndTime = new TempoAndTime(0);
        tempoAndTime.tempo = 120.0;
        tempoAndTime.tickInPfm = 0.0;
        tempoAndTime.timeInSec = 0.0;
        tempoAndTime.measure = -1;
        tempoAndTime.beat = 1;
        return tempoAndTime;
    }

    private ArrayList<TempoAndTime> alignBeats() {
        ArrayList<TempoAndTime> arrayList = new ArrayList<TempoAndTime>();
        arrayList.add(this.getZerothTempoAndTime());
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        int n4 = 0;
        for (int i = 0; i < this.barlines.length - 2; ++i) {
            MusicXMLWrapper.Measure measure = this.getMeasure(this.barlines[i].onset());
            n2 = measure.number();
            n3 = (int)measure.initialBeat();
            for (n4 = this.barlines[i].onset(); n4 < this.barlines[i + 1].onset(); n4 += this.scoreTicksPerBeat) {
                n = this.addTempoAndTime(n4, n2, n3, n, arrayList);
                ++n3;
            }
        }
        n4 = this.barlines[this.barlines.length - 2].onset();
        MusicXMLWrapper.Measure measure = this.getMeasure(n4);
        n2 = measure.number();
        n3 = (int)measure.initialBeat();
        n = this.addTempoAndTime(n4, n2, n3, n, arrayList);
        int n5 = n4;
        for (int i = 0; i < this.scoreNotes.length; ++i) {
            if (this.scoreNotes[i].offset() <= n5) continue;
            n5 = this.scoreNotes[i].offset();
        }
        n4 += this.scoreTicksPerBeat;
        while (n4 < this.barlines[this.barlines.length - 1].onset()) {
            n = this.addTempoAndTime(n4, n2, ++n3, n, arrayList);
            n4 += this.scoreTicksPerBeat;
        }
        while (n4 <= n5 + 4 * this.scoreTicksPerBeat) {
            TempoAndTime tempoAndTime = new TempoAndTime(n4);
            tempoAndTime.measure = n2;
            tempoAndTime.beat = ++n3;
            arrayList.add(tempoAndTime);
            n4 += this.scoreTicksPerBeat;
        }
        return arrayList;
    }

    private static int max(int n, int n2) {
        return n >= n2 ? n : n2;
    }

    private int addTempoAndTime(int n, int n2, int n3, int n4, ArrayList<TempoAndTime> arrayList) {
        while (n4 < this.scoreNotes.length) {
            if (this.score2pfm[n4] == -1) {
                ++n4;
                continue;
            }
            if (this.tickcmp(this.scoreNotes[n4].onset(), n, 5)) {
                int n5 = 0;
                int n6 = 0;
                int n7 = n4;
                while (true) {
                    block8: {
                        try {
                            if (!this.tickcmp(this.scoreNotes[n7].onset(), n, 5)) break;
                            if (this.score2pfm[n7] == -1) break block8;
                            n6 += this.pfmNotes[this.score2pfm[n7]].onset();
                            ++n5;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            break;
                        }
                    }
                    ++n7;
                }
                TempoAndTime tempoAndTime = new TempoAndTime(n);
                tempoAndTime.measure = n2;
                tempoAndTime.beat = n3;
                if (n5 > 0) {
                    tempoAndTime.setTickInPfm((double)n6 / (double)n5);
                }
                arrayList.add(tempoAndTime);
                return n7;
            }
            if (this.scoreNotes[n4].onset() > n) {
                TempoAndTime tempoAndTime = new TempoAndTime(n);
                tempoAndTime.measure = n2;
                tempoAndTime.beat = n3;
                arrayList.add(tempoAndTime);
                return n4;
            }
            ++n4;
        }
        TempoAndTime tempoAndTime = new TempoAndTime(n);
        tempoAndTime.measure = n2;
        tempoAndTime.beat = n3;
        arrayList.add(tempoAndTime);
        return n4;
    }

    private MusicXMLWrapper.Measure getMeasure(int n) {
        int n2 = this.measurelist[this.lastMeasureIndex].cumulativeTicks(this.scoreTicksPerBeat);
        if (n2 == n) {
            return this.measurelist[this.lastMeasureIndex];
        }
        if (n2 > n) {
            --this.lastMeasureIndex;
            return this.getMeasure(n);
        }
        ++this.lastMeasureIndex;
        return this.getMeasure(n);
    }

    private void interpolateBeatTime(ArrayList<TempoAndTime> arrayList) {
        TempoAndTime tempoAndTime = arrayList.get(1);
        if (Double.isNaN(tempoAndTime.tickInPfm)) {
            System.err.println("first note in MusicXML is not at t=0");
            tempoAndTime.setTickInPfm(0.0);
        }
        int n = arrayList.size();
        int n2 = 1;
        double d = tempoAndTime.tickInPfm;
        int n3 = -1;
        double d2 = 0.0;
        try {
            for (int i = 2; i < n - 1; ++i) {
                TempoAndTime tempoAndTime2 = arrayList.get(i);
                if (Double.isNaN(tempoAndTime2.tickInPfm)) {
                    if (i >= n3) {
                        n3 = i;
                        while (Double.isNaN(d2 = arrayList.get(n3).tickInPfm)) {
                            ++n3;
                        }
                    }
                    tempoAndTime2.setTickInPfm((d * (double)(n3 - i) + d2 * (double)(i - n2)) / (double)(n3 - n2));
                    continue;
                }
                n2 = i;
                d = tempoAndTime2.tickInPfm;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private double calcTempo(ArrayList<TempoAndTime> arrayList) {
        int n = arrayList.size();
        double d = 0.0;
        double d2 = 0.0;
        int n2 = 0;
        TempoAndTime tempoAndTime = arrayList.get(1);
        for (int i = 2; i < n; ++i) {
            double d3;
            int n3;
            TempoAndTime tempoAndTime2 = arrayList.get(i);
            if (Double.isNaN(tempoAndTime2.timeInSec)) {
                tempoAndTime.tempo = d;
                n3 = tempoAndTime2.tickInScore - tempoAndTime.tickInScore;
                d3 = (double)(n3 * 60 / this.scoreTicksPerBeat) / d;
                tempoAndTime2.setTimeInSec(tempoAndTime.timeInSec + d3);
            } else {
                n3 = tempoAndTime2.tickInScore - tempoAndTime.tickInScore;
                d3 = tempoAndTime2.timeInSec - tempoAndTime.timeInSec;
                if (d3 < 1.0E-10) {
                    tempoAndTime2.setTimeInSec(tempoAndTime2.timeInSec + 0.01);
                    d3 = tempoAndTime2.timeInSec - tempoAndTime.timeInSec;
                }
                tempoAndTime.tempo = (double)(n3 * 60 / this.scoreTicksPerBeat) / d3;
                d = tempoAndTime.tempo;
            }
            d2 += tempoAndTime.tempo;
            ++n2;
            tempoAndTime = tempoAndTime2;
        }
        arrayList.get(n - 1).tempo = d;
        return d2 / (double)n2;
    }

    private void addTempoDeviations(DeviationDataSet deviationDataSet, ArrayList<TempoAndTime> arrayList, double d) {
        int n = arrayList.size();
        for (int i = 1; i < n - 1; ++i) {
            TempoAndTime tempoAndTime = arrayList.get(i);
            deviationDataSet.addNonPartwiseControl(tempoAndTime.measure, tempoAndTime.beat, "tempo-deviation", tempoAndTime.tempo / d);
        }
    }

    public static void main(String[] stringArray) {
        try {
            MusicXMLWrapper musicXMLWrapper = (MusicXMLWrapper)CMXFileWrapper.readfile(stringArray[0]);
            MIDIXMLWrapper mIDIXMLWrapper = MIDIXMLWrapper.readSMF(stringArray[1]);
            PerformanceMatcher3.extractDeviation(musicXMLWrapper, mIDIXMLWrapper, new File(stringArray[2])).writefile(stringArray[3]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class NoteInSameTime {
        List<SCCXMLWrapper.Note> notes = new LinkedList<SCCXMLWrapper.Note>();
        List<Integer> indexes = new LinkedList<Integer>();

        NoteInSameTime() {
        }

        void addNote(SCCXMLWrapper.Note note, int n) {
            this.notes.add(note);
            this.indexes.add(n);
        }

        public String toString() {
            String string = "";
            for (SCCXMLWrapper.Note note : this.notes) {
                string = string + note.notenum() + ", ";
            }
            return string;
        }
    }

    private class TempoAndTime {
        private double tempo = Double.NaN;
        private int tickInScore;
        private double tickInPfm = Double.NaN;
        private double timeInSec = Double.NaN;
        private int measure = -1;
        private int beat = -1;

        private TempoAndTime(int n) {
            this.tickInScore = n;
        }

        private void setTickInPfm(double d) {
            this.tickInPfm = d;
            this.timeInSec = d * 60.0 / (double)(PerformanceMatcher3.this.pfmTicksPerBeat * baseTempo);
        }

        private void setTimeInSec(double d) {
            this.timeInSec = d;
            this.tickInPfm = d * (double)PerformanceMatcher3.this.pfmTicksPerBeat * (double)baseTempo / 60.0;
        }

        private double beatLength() {
            return (double)(PerformanceMatcher3.this.pfmTicksPerBeat * baseTempo) / this.tempo;
        }

        public String toString() {
            return "\n" + this.tempo + ", " + this.tickInScore + ", " + this.tickInPfm + ", " + this.timeInSec + ", " + this.measure + ", " + this.beat;
        }
    }

    private class DTWMatrix {
        private HashMap<IntPair, DTWMatrixElement> values;
        private int nrows;
        private int ncols;
        private final DTWMatrixElement DEFAULT_MATRIX_ELEMENT = new DTWMatrixElement(1.073741823E9, -1, -1);

        private DTWMatrix(int n, int n2) {
            this.nrows = n;
            this.ncols = n2;
            this.values = new HashMap(Math.max(n, n2));
        }

        private void set(int n, int n2, double d, int n3, int n4) {
            this.values.put(new IntPair(n, n2), new DTWMatrixElement(d, n3, n4));
        }

        private DTWMatrixElement get(int n, int n2) {
            if (n >= this.nrows || n2 >= this.ncols || n < -1 || n2 < -1) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (this.values.containsKey(new IntPair(n, n2))) {
                return this.values.get(new IntPair(n, n2));
            }
            return this.DEFAULT_MATRIX_ELEMENT;
        }

        private double getValue(int n, int n2) {
            return this.get(n, n2).value;
        }

        private class DTWMatrixElement {
            private int targetX;
            private int targetY;
            private double value;

            private DTWMatrixElement(double d, int n, int n2) {
                this.value = d;
                this.targetX = n;
                this.targetY = n2;
            }
        }

        private class IntPair {
            private int i;
            private int j;

            private IntPair(int n, int n2) {
                this.i = n;
                this.j = n2;
            }

            public boolean equals(Object object) {
                IntPair intPair = (IntPair)object;
                return this.i == intPair.i && this.j == intPair.j;
            }

            public int hashCode() {
                return this.i * DTWMatrix.this.nrows + this.j;
            }
        }
    }

    private class NoteBuffer {
        SCCXMLWrapper.Note[][] notes = new SCCXMLWrapper.Note[64][128];
        int[][] indices = new int[64][128];
        int[] next = new int[64];

        private NoteBuffer() {
        }

        void addNote(SCCXMLWrapper.Note note, int n) {
            int n2 = note.grace();
            this.notes[n2][this.next[n2]] = note;
            this.indices[n2][this.next[n2]] = n;
            int n3 = n2;
            this.next[n3] = this.next[n3] + 1;
        }
    }
}

