package jp.crestmuse.cmx.gui.dppatheditor;

import java.io.IOException;

import javax.sound.midi.InvalidMidiDataException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import org.xml.sax.SAXException;

public class DpPathEditor {

  public static void main(String[] args) throws ParserConfigurationException,
    SAXException, IOException, TransformerException,
    InvalidMidiDataException {
    if (args.length < 2) {
      System.err.println("Usage: ");
      System.err.println("java jp.crestmuse.cmx.gui.dppatheditor.DpPathEditor musicxml smf [options]");
      System.err.println("Options: ");
      System.err.println("  -dev [filename]");
      System.err.println("  -cmp [filename]");
      System.exit(1);
    }
    String scoreFilename = args[0];
    String pfmFilename = args[1];
    String devFilename = "deviation.xml";
    String cmpFilename = "cmp.txt";
    String remadeSMF = "result.mid";
    for (int i = 2; i < args.length; i++) {
      if (args[i].equals("-dev")) {
	devFilename = args[i+1];
	i++;
      } else if (args[i].equals("-cmp")) {
	cmpFilename = args[i+1];
	i++;
      } else if (args[i].equals("-remidi")) {
	remadeSMF = args[i+1];
	i++;
      }
    }
    new FrameController(scoreFilename, pfmFilename, devFilename, cmpFilename, 
			remadeSMF);
  }

}
