package jp.crestmuse.cmx.gui.dppatheditor;

import java.io.*;

import javax.sound.midi.InvalidMidiDataException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import org.xml.sax.SAXException;

import jp.crestmuse.cmx.commands.*;

import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.DeviationInstanceWrapper;
import jp.crestmuse.cmx.filewrappers.InvalidFileTypeException;
import jp.crestmuse.cmx.filewrappers.MIDIXMLWrapper;
import jp.crestmuse.cmx.filewrappers.MusicXMLWrapper;
import jp.crestmuse.cmx.gui.deveditor.model.DeviatedPerformance;
import jp.crestmuse.cmx.gui.deveditor.view.DeviatedPerformancePlayer;
import jp.crestmuse.cmx.misc.PerformanceMatcher3;

public class FrameController implements Runnable {

  private String scoreFilename;
  private String pfmFilename;
  private String devFilename;
  private String cmpFilename;
  private String remadeSMF;
  private PerformanceMatcher3 pm3;
  private int[] score2pfm;
  private DeviationInstanceWrapper dev; // editted by tetsuro kitahara
  private DeviatedPerformance deviatedPerformance;
  private DeviatedPerformancePlayer player;
  private MainFrame frame;

//  public FrameController(String scoreFilename, String pfmFilename) 
//      throws ParserConfigurationException, SAXException, IOException,
//      TransformerException, InvalidMidiDataException {
//    this(scoreFilename, pfmFilename, null, null);
//  }

  public FrameController(String scoreFilename, String pfmFilename, 
			 String devFilename, String cmpFilename, 
			 String remadeSMF)
      throws ParserConfigurationException, SAXException, IOException,
      TransformerException, InvalidMidiDataException {
    this.scoreFilename = scoreFilename;
    this.pfmFilename = pfmFilename;
    this.devFilename = devFilename;
    this.cmpFilename = cmpFilename;
    this.remadeSMF = remadeSMF;
    pm3 = new PerformanceMatcher3(
        (MusicXMLWrapper) CMXFileWrapper.readfile(scoreFilename),
        MIDIXMLWrapper.readSMF(pfmFilename));
    DeviationInstanceWrapper deviation = pm3.extractDeviation();
    score2pfm = pm3.getScore2Pfm().clone();
    deviation.finalizeDocument();
    deviatedPerformance = new DeviatedPerformance(deviation);
    player = new DeviatedPerformancePlayer();
    player.changeDeviation(deviatedPerformance);
    SwingUtilities.invokeLater(this);
  }

  public void run() {
    if (frame != null)
      frame.dispose();
    try {
      frame = new MainFrame(deviatedPerformance, pm3, score2pfm, player, this);
      frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
      frame.setVisible(true);
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  public void reGenerateDeviation() throws ParserConfigurationException,
      SAXException, IOException, TransformerException, InvalidMidiDataException {
    frame.setVisible(false);
    try {
      pm3 = new PerformanceMatcher3(
          (MusicXMLWrapper) CMXFileWrapper.readfile(scoreFilename),
          MIDIXMLWrapper.readSMF(pfmFilename));
      dev = pm3.extractDeviation(frame.getScore2pfm());
      score2pfm = pm3.getScore2Pfm().clone();
      dev.finalizeDocument();
      deviatedPerformance = new DeviatedPerformance(dev);
    } catch (ArithmeticException e) {
      JOptionPane.showMessageDialog(frame, "invalid matching");
      frame.setVisible(true);
      return;
    }
    player.changeDeviation(deviatedPerformance);
    SwingUtilities.invokeLater(this);
  }

  public void save() throws InvalidFileTypeException, IOException, SAXException, TransformerException, ParserConfigurationException  {
    dev.writefile(devFilename);
    MIDIXMLWrapper midixml = dev.toSCCXML(1920).toMIDIXML();
    midixml.writefileAsSMF(remadeSMF);
    PrintStream pm = 
      new PrintStream(new BufferedOutputStream
		      (new FileOutputStream(cmpFilename)), true);
    TimeInSecForSMF.changePrintStream(pm);
    TimeInSecForSMF.main(new String[]{pfmFilename, remadeSMF});
    pm.close();
    //dev.writefile("out.xml");
    // deviatedPerformance.calcDeviation().writefile("out.xml");
  }

}
