/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.commands;

import jp.crestmuse.cmx.amusaj.commands.AbstractWAVAnalyzer;
import jp.crestmuse.cmx.amusaj.commands.ModuleConnection;
import jp.crestmuse.cmx.amusaj.commands.OutputData;
import jp.crestmuse.cmx.amusaj.sp.AmusaParameterSet;
import jp.crestmuse.cmx.amusaj.sp.PeakExtractor;
import jp.crestmuse.cmx.amusaj.sp.ProducerConsumerCompatible;
import jp.crestmuse.cmx.amusaj.sp.STFT;

public class ChromaExtractor
extends AbstractWAVAnalyzer {
    private ProducerConsumerCompatible stft;
    private ProducerConsumerCompatible peakext;
    private ProducerConsumerCompatible chroma;

    @Override
    protected boolean setOptionsLocal(String string, String string2) {
        AmusaParameterSet amusaParameterSet = AmusaParameterSet.getInstance();
        if (super.setOptionsLocal(string, string2)) {
            return true;
        }
        if (string.startsWith("-l")) {
            amusaParameterSet.setParam("chroma", "CHROMA_LOW_LIMIT_FREQ", string2);
            return true;
        }
        if (string.startsWith("-h")) {
            amusaParameterSet.setParam("chroma", "CHROMA_HIGH_LIMIT_FREQ", string2);
            return true;
        }
        return false;
    }

    @Override
    protected ProducerConsumerCompatible[] getUsedModules() {
        this.stft = new STFT(this.usesStereo());
        return new ProducerConsumerCompatible[]{this.stft, this.peakext = new PeakExtractor(), this.chroma = new jp.crestmuse.cmx.amusaj.sp.ChromaExtractor()};
    }

    @Override
    protected ModuleConnection[] getModuleConnections() {
        return new ModuleConnection[]{new ModuleConnection(this.getWindowSlider(), 0, this.stft, 0), new ModuleConnection(this.stft, 0, this.peakext, 0), new ModuleConnection(this.stft, 1, this.peakext, 1), new ModuleConnection(this.stft, 2, this.peakext, 2), new ModuleConnection(this.peakext, 0, this.chroma, 0)};
    }

    @Override
    protected String getAmusaXMLFormat() {
        return "array";
    }

    @Override
    protected OutputData[] getOutputData() {
        return new OutputData[]{new OutputData(this.chroma, 0)};
    }

    public static void main(String[] stringArray) {
        ChromaExtractor chromaExtractor = new ChromaExtractor();
        try {
            chromaExtractor.start(stringArray);
        }
        catch (Exception exception) {
            chromaExtractor.showErrorMessage(exception);
            System.exit(1);
        }
    }

    static {
        ChromaExtractor.addOptionHelpMessage("-l <freq>", "lower bound frequency for analysis");
        ChromaExtractor.addOptionHelpMessage("-h <freq>", "upper bound frequency for analysis");
    }
}

