/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.commands;

import jp.crestmuse.cmx.amusaj.commands.AbstractWAVAnalyzer;
import jp.crestmuse.cmx.amusaj.commands.ModuleConnection;
import jp.crestmuse.cmx.amusaj.commands.OptionUtils;
import jp.crestmuse.cmx.amusaj.commands.OutputData;
import jp.crestmuse.cmx.amusaj.filewrappers.PeakSet;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.F0PDFCalculatorModule;
import jp.crestmuse.cmx.amusaj.sp.HarmonicsExtractor;
import jp.crestmuse.cmx.amusaj.sp.PeakExtractor;
import jp.crestmuse.cmx.amusaj.sp.ProducerConsumerCompatible;
import jp.crestmuse.cmx.amusaj.sp.SPModule;
import jp.crestmuse.cmx.amusaj.sp.SPSpreadModule;
import jp.crestmuse.cmx.amusaj.sp.STFT;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.math.DoubleArrayFactory;
import jp.crestmuse.cmx.math.Operations;

public class F0Tracker
extends AbstractWAVAnalyzer {
    private ProducerConsumerCompatible stft;
    private ProducerConsumerCompatible peakext;
    private ProducerConsumerCompatible f0calc;
    private ProducerConsumerCompatible f0track;
    private ProducerConsumerCompatible spread;
    private ProducerConsumerCompatible harmext;
    private static final DoubleArrayFactory factory = DoubleArrayFactory.getFactory();

    @Override
    protected boolean setOptionsLocal(String string, String string2) {
        if (super.setOptionsLocal(string, string2)) {
            return true;
        }
        return OptionUtils.setF0PDFOptions(string, string2);
    }

    @Override
    protected ProducerConsumerCompatible[] getUsedModules() {
        this.stft = new STFT(this.usesStereo());
        return new ProducerConsumerCompatible[]{this.stft, this.peakext = new PeakExtractor(), this.spread = new SPSpreadModule(PeakSet.class, 2), this.f0calc = new F0PDFCalculatorModule(), this.f0track = new F0TrackingModule(), this.harmext = new HarmonicsExtractor()};
    }

    @Override
    protected ModuleConnection[] getModuleConnections() {
        return new ModuleConnection[]{new ModuleConnection(this.getWindowSlider(), 0, this.stft, 0), new ModuleConnection(this.stft, 0, this.peakext, 0), new ModuleConnection(this.stft, 1, this.peakext, 1), new ModuleConnection(this.stft, 2, this.peakext, 2), new ModuleConnection(this.peakext, 0, this.spread, 0), new ModuleConnection(this.spread, 0, this.harmext, 0), new ModuleConnection(this.spread, 1, this.f0calc, 0), new ModuleConnection(this.f0calc, 0, this.f0track, 0), new ModuleConnection(this.f0track, 0, this.harmext, 1)};
    }

    @Override
    protected OutputData[] getOutputData() {
        return new OutputData[]{new OutputData(this.harmext, 0)};
    }

    @Override
    protected String getAmusaXMLFormat() {
        return "peaks";
    }

    public static void main(String[] stringArray) {
        F0Tracker f0Tracker = new F0Tracker();
        try {
            f0Tracker.start(stringArray);
        }
        catch (Exception exception) {
            f0Tracker.showErrorMessage(exception);
            System.exit(1);
        }
    }

    class F0TrackingModule
    extends SPModule {
        double thrs = 0.2;
        Operations.MaxResult maxresult = new Operations.MaxResult();
        double nnFrom = -1.0;
        double step = -1.0;

        F0TrackingModule() {
        }

        @Override
        public void execute(Object[] objectArray, TimeSeriesCompatible[] timeSeriesCompatibleArray) throws InterruptedException {
            DoubleArray doubleArray = (DoubleArray)objectArray[0];
            Operations.max(doubleArray, this.maxresult);
            if (this.maxresult.max > this.thrs) {
                this.nnFrom = this.nnFrom < 0.0 ? F0Tracker.this.getParamDouble("f0pdf", "NOTENUMBER_FROM") : this.nnFrom;
                this.step = this.step < 0.0 ? F0Tracker.this.getParamDouble("f0pdf", "STEP") : this.step;
                double d = Operations.nn2Hz(this.nnFrom + this.step * (double)this.maxresult.argmax);
                timeSeriesCompatibleArray[0].add(factory.createArray(1, d));
            } else {
                timeSeriesCompatibleArray[0].add(factory.createArray(1, 0.0));
            }
        }

        @Override
        public Class[] getInputClasses() {
            return new Class[]{DoubleArray.class};
        }

        @Override
        public Class[] getOutputClasses() {
            return new Class[]{DoubleArray.class};
        }
    }
}

