/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.commands;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.amusaj.commands.AbstractWAVAnalyzer;
import jp.crestmuse.cmx.amusaj.commands.ModuleConnection;
import jp.crestmuse.cmx.amusaj.commands.OutputData;
import jp.crestmuse.cmx.amusaj.filewrappers.AmusaDataSet;
import jp.crestmuse.cmx.amusaj.filewrappers.AmusaDataSetCompatible;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.filewrappers.WAVWrapper;
import jp.crestmuse.cmx.amusaj.sp.ProducerConsumerCompatible;
import jp.crestmuse.cmx.amusaj.sp.SPExecutor;
import jp.crestmuse.cmx.amusaj.sp.WindowSlider;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.SCCXMLWrapper;
import org.xml.sax.SAXException;

public abstract class NotewiseWAVAnalyzer
extends AbstractWAVAnalyzer {
    private String sccFileName = null;
    private SCCXMLWrapper scc;

    @Override
    protected boolean setOptionsLocal(String string, String string2) {
        if (super.setOptionsLocal(string, string2)) {
            return true;
        }
        if (string.equals("-scc")) {
            this.sccFileName = string2;
            return true;
        }
        return false;
    }

    @Override
    protected void preproc() throws IOException, ParserConfigurationException, TransformerException, SAXException {
        super.preproc();
        this.scc = (SCCXMLWrapper)CMXFileWrapper.readfile(this.sccFileName);
    }

    @Override
    protected AmusaDataSetCompatible run(WAVWrapper wAVWrapper) throws IOException, ParserConfigurationException, TransformerException, SAXException {
        SCCXMLWrapper.Part[] partArray;
        AmusaDataSet<TimeSeriesCompatible> amusaDataSet = new AmusaDataSet<TimeSeriesCompatible>(this.getAmusaXMLFormat());
        for (SCCXMLWrapper.Part part : partArray = this.scc.getPartList()) {
            SCCXMLWrapper.Note[] noteArray;
            for (SCCXMLWrapper.Note note : noteArray = part.getNoteOnlyList()) {
                SPExecutor sPExecutor = new SPExecutor();
                this.winslider = new WindowSlider(this.usesStereo());
                this.winslider.setInputData(wAVWrapper, note.onsetInMilliSec(), note.offsetInMilliSec());
                sPExecutor.addSPModule(this.winslider);
                for (ProducerConsumerCompatible producerConsumerCompatible : this.getUsedModules()) {
                    sPExecutor.addSPModule(producerConsumerCompatible);
                }
                for (ProducerConsumerCompatible producerConsumerCompatible : this.getUsedModules(note)) {
                    sPExecutor.addSPModule(producerConsumerCompatible);
                }
                for (ModuleConnection moduleConnection : this.getModuleConnections()) {
                    sPExecutor.connect(moduleConnection.inModule, moduleConnection.inCh, moduleConnection.outModule, moduleConnection.outCh);
                }
                for (OutputData outputData : this.getOutputData()) {
                    TimeSeriesCompatible timeSeriesCompatible = sPExecutor.getResult(outputData.module).get(outputData.ch);
                    timeSeriesCompatible.setAttribute("onset", note.onsetInMilliSec());
                    timeSeriesCompatible.setAttribute("offset", note.offsetInMilliSec());
                    timeSeriesCompatible.setAttribute("notenum", note.notenum());
                    timeSeriesCompatible.setAttribute("velocity", note.velocity());
                    timeSeriesCompatible.setAttribute("prognum", note.part().prognum());
                    timeSeriesCompatible.setAttribute("xlink:href", "#xpointer(" + note.getXPathExpression() + ")");
                    amusaDataSet.add(timeSeriesCompatible);
                }
                this.customSetting(sPExecutor, amusaDataSet);
                this.customSetting(sPExecutor, note, amusaDataSet);
                Thread object = Thread.currentThread();
                sPExecutor.setInterruptionReceiver(object);
                sPExecutor.start();
                System.err.println(note.toString() + " being processed...");
                try {
                    while (true) {
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
        return amusaDataSet;
    }

    @Override
    protected final ProducerConsumerCompatible[] getUsedModules() {
        return new ProducerConsumerCompatible[0];
    }

    protected abstract ProducerConsumerCompatible[] getUsedModules(SCCXMLWrapper.Note var1);

    protected void customSetting(SPExecutor sPExecutor, SCCXMLWrapper.Note note, AmusaDataSetCompatible amusaDataSetCompatible) {
    }
}

