/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.commands;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.amusaj.filewrappers.WAVWrapper;
import jp.crestmuse.cmx.commands.CMXCommand;
import jp.crestmuse.cmx.filewrappers.ConfigXMLWrapper;
import jp.crestmuse.cmx.filewrappers.SCCXMLWrapper;
import jp.crestmuse.cmx.handlers.SCCHandlerAdapter;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.math.SP;
import jp.crestmuse.cmx.misc.MultiHashMap;
import jp.crestmuse.cmx.sound.MutableWaveform;
import org.xml.sax.SAXException;

public class SCC2WAV
extends CMXCommand<SCCXMLWrapper, WAVWrapper> {
    private int cache_capacity;
    private int fs;
    private int length = -1;
    private double thresh = 0.0;
    private int n = -1;
    private String mdb = "rwc";
    private String path;
    private String pitchlistfilename;
    private String instlisttype;
    private String pattern;
    private String sty = null;
    private String sty2 = null;
    private int var = 1;
    private boolean isStereo = false;
    private double mic2mic = 0.2;
    private double mach = 340.0;
    private double lSD = 0.0;
    private String impfilename = null;
    private String impLfilename = null;
    private String impRfilename = null;
    private DoubleArray imp = null;
    private DoubleArray impL = null;
    private DoubleArray impR = null;
    private int releasetime = 0;
    private WavCache wavcache;
    private PitchList pitchlist;
    private MutableWaveform wav;
    private Random random;

    @Override
    protected boolean setOptionsLocal(String string, String string2) {
        if (string.equals("-mdb")) {
            this.mdb = string2;
            return true;
        }
        if (string.equals("-sty")) {
            this.sty = string2;
            return true;
        }
        if (string.equals("-sty2")) {
            this.sty2 = string2;
            return true;
        }
        if (string.equals("-var")) {
            this.var = Integer.parseInt(string2);
            return true;
        }
        if (string.equals("-len")) {
            this.length = Integer.parseInt(string2);
            return true;
        }
        if (string.equals("-th")) {
            this.thresh = Double.parseDouble(string2);
            return true;
        }
        if (string.equals("-mic2mic") || string.equals("-m2m")) {
            this.mic2mic = Double.parseDouble(string2);
            return true;
        }
        if (string.equals("-mach")) {
            this.mach = Double.parseDouble(string2);
            return true;
        }
        if (string.equals("-lsd")) {
            this.lSD = Double.parseDouble(string2);
            return true;
        }
        if (string.equals("-imp")) {
            this.impfilename = string2;
            return true;
        }
        if (string.equals("-impL")) {
            this.impLfilename = string2;
            return true;
        }
        if (string.equals("-impR")) {
            this.impRfilename = string2;
            return true;
        }
        return false;
    }

    @Override
    protected boolean setBoolOptionsLocal(String string) {
        if (string.equals("-st")) {
            this.isStereo = true;
            return true;
        }
        return false;
    }

    @Override
    protected void preproc() throws IOException {
        ConfigXMLWrapper configXMLWrapper = SCC2WAV.getConfigXMLWrapper();
        this.cache_capacity = configXMLWrapper.getParamInt("param", "scc2wav", "CACHE_CAPACITY");
        this.fs = configXMLWrapper.getParamInt("mdb", this.mdb, "SAMPLE_RATE");
        if (this.length < 0) {
            this.length = configXMLWrapper.getParamInt("param", "scc2wav", "LENGTH");
        }
        if (this.thresh == 0.0) {
            this.thresh = configXMLWrapper.getParamDouble("mdb", this.mdb, "ONSET_POWER_THRESH");
        }
        if (this.n < 0) {
            this.n = configXMLWrapper.getParamInt("mdb", this.mdb, "ONSET_N");
        }
        this.path = configXMLWrapper.getParam("mdb", this.mdb, "PATH");
        this.pitchlistfilename = configXMLWrapper.getParam("mdb", this.mdb, "PITCH_LIST_FILE_NAME");
        this.pattern = configXMLWrapper.getParam("mdb", this.mdb, "PATTERN");
        if (this.sty == null) {
            this.sty = configXMLWrapper.getParam("mdb", this.mdb, "DEFAULT_STYLE");
        }
        this.instlisttype = configXMLWrapper.getParam("mdb", this.mdb, "PATCH_LIST");
        this.wavcache = new WavCache();
        this.pitchlist = new PitchList();
        this.pitchlist.read(this.pitchlistfilename);
        this.random = new Random();
        if (this.impfilename != null) {
            this.imp = this.getImpulseResponse(this.impfilename);
            this.releasetime = Math.max(this.releasetime, this.imp.length());
        }
        if (this.impLfilename != null) {
            this.impL = this.getImpulseResponse(this.impLfilename);
            this.releasetime = Math.max(this.releasetime, this.impL.length());
        }
        if (this.impRfilename != null) {
            this.impR = this.getImpulseResponse(this.impRfilename);
            this.releasetime = Math.max(this.releasetime, this.impR.length());
        }
    }

    private DoubleArray getImpulseResponse(String string) throws IOException {
        WAVWrapper wAVWrapper = WAVWrapper.readfile(string);
        MutableWaveform mutableWaveform = new MutableWaveform(wAVWrapper);
        DoubleArray doubleArray = mutableWaveform.getDoubleArrayWaveform()[0];
        doubleArray = SP.changeRate(doubleArray, mutableWaveform.sampleRate(), this.fs);
        return SP.cutLastSmallSignal(doubleArray, 0.01);
    }

    @Override
    protected WAVWrapper run(SCCXMLWrapper sCCXMLWrapper) throws ParserConfigurationException, SAXException, TransformerException, IOException {
        final MutableWaveform mutableWaveform = new MutableWaveform(this.length, this.fs, this.isStereo ? 2 : 1);
        sCCXMLWrapper.processNotes(new SCCHandlerAdapter(){

            @Override
            public void processNote(SCCXMLWrapper.Note note, SCCXMLWrapper sCCXMLWrapper) {
                int n = note.onsetInMilliSec() * SCC2WAV.this.fs / 1000;
                int n2 = note.offsetInMilliSec() * SCC2WAV.this.fs / 1000;
                MutableWaveform mutableWaveform3 = SCC2WAV.this.readWaveform(note.part().prognum(), note.notenum(), SCC2WAV.this.sty, SCC2WAV.this.var);
                if (mutableWaveform3 == null && SCC2WAV.this.sty2 != null) {
                    mutableWaveform3 = SCC2WAV.this.readWaveform(note.part().prognum(), note.notenum(), SCC2WAV.this.sty2, SCC2WAV.this.var);
                }
                if (mutableWaveform3 != null) {
                    MutableWaveform mutableWaveform2 = new MutableWaveform(mutableWaveform3);
                    mutableWaveform2 = (MutableWaveform)mutableWaveform2.clone();
                    mutableWaveform2.cutAfter(n2 - n);
                    mutableWaveform2.smoothOffset();
                    if (SCC2WAV.this.isStereo) {
                        int n3 = (int)((double)SCC2WAV.this.fs * 0.5 * SCC2WAV.this.mic2mic * Math.sin((Math.PI * (double)note.part().panpot() + SCC2WAV.this.random.nextGaussian() * SCC2WAV.this.lSD - 64.0) / 128.0) / SCC2WAV.this.mach);
                        mutableWaveform.mix_st(mutableWaveform2, n + n3, n - n3, (double)(note.part().volume() * note.velocity()) / 10000.0, (double)(note.part().volume() * note.velocity()) / 10000.0);
                    } else {
                        mutableWaveform.mix(mutableWaveform2, n, (double)(note.part().volume() * note.velocity()) / 10000.0);
                    }
                }
            }
        });
        mutableWaveform.trim(this.releasetime + this.fs);
        if (this.isStereo && this.impL != null && this.impR != null) {
            mutableWaveform.conv_st(this.impL, this.impR);
        } else if (this.imp != null) {
            mutableWaveform.conv(this.imp);
        }
        mutableWaveform.normalize();
        return new WAVWrapper(mutableWaveform);
    }

    private MutableWaveform readWaveform(int n, int n2, String string, int n3) {
        MutableWaveform mutableWaveform;
        String string2 = this.pitchlist.getWaveFileName(n, n2, string, n3);
        if (string2 != null) {
            try {
                mutableWaveform = this.wavcache.readWaveform(string2, this.path);
            }
            catch (IOException iOException) {
                mutableWaveform = null;
                iOException.printStackTrace();
            }
        } else {
            mutableWaveform = null;
        }
        return mutableWaveform;
    }

    public static void main(String[] stringArray) {
        SCC2WAV sCC2WAV = new SCC2WAV();
        try {
            sCC2WAV.start(stringArray);
        }
        catch (Exception exception) {
            sCC2WAV.showErrorMessage(exception);
            System.exit(1);
        }
    }

    private static String addZeroToInt(int n, int n2) {
        String string = String.valueOf(n);
        while (string.length() < n2) {
            string = '0' + string;
        }
        return string;
    }

    class InvalidPitchListException
    extends IOException {
        InvalidPitchListException() {
        }

        InvalidPitchListException(String string) {
            super(string);
        }
    }

    private class PitchList {
        MultiHashMap h = new MultiHashMap();

        private PitchList() {
        }

        private void read(String string) throws InvalidPitchListException {
            try {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string2.length() <= 0) continue;
                    int n = string2.indexOf(":");
                    String string3 = string2.substring(0, n).trim();
                    String string4 = String.valueOf(Integer.parseInt(string2.substring(n + 1).trim()));
                    this.h.add(string4, string3);
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                throw new InvalidPitchListException();
            }
        }

        private String getInstName(int n) {
            return CMXCommand.getConfigXMLWrapper().getParam("prognum", SCC2WAV.this.instlisttype, "PN_" + n);
        }

        private String getWaveFileName(int n, int n2, String string, int n3) {
            String string2 = this.getInstName(n);
            String string3 = SCC2WAV.this.pattern.replaceAll("%i", string2);
            string3 = string3.replaceAll("%s", string);
            string3 = string3.replaceAll("%1v", SCC2WAV.addZeroToInt(n3, 1));
            string3 = string3.replaceAll("%2v", SCC2WAV.addZeroToInt(n3, 2));
            Pattern pattern = Pattern.compile(string3);
            String string4 = String.valueOf(n2);
            for (int i = 0; i < this.h.size(string4); ++i) {
                String string5 = (String)this.h.get(string4, i);
                Matcher matcher = pattern.matcher(string5);
                if (!matcher.matches()) continue;
                return string5;
            }
            return null;
        }
    }

    private class WavCache {
        private Hashtable<String, MutableWaveform> cache = new Hashtable();
        private Hashtable<String, Long> timestamp = new Hashtable();

        WavCache() {
        }

        private MutableWaveform readWaveform(String string, String string2) throws IOException {
            MutableWaveform mutableWaveform;
            if (this.cache.containsKey(string)) {
                mutableWaveform = this.cache.get(string);
                this.timestamp.put(string, System.currentTimeMillis());
            } else {
                mutableWaveform = new MutableWaveform(WAVWrapper.readfile(string2 + File.separator + string));
                mutableWaveform.cutBeforeOnset(SCC2WAV.this.n, SCC2WAV.this.thresh);
                mutableWaveform.normalize();
                this.add(string, mutableWaveform);
            }
            return mutableWaveform;
        }

        private void add(String string, MutableWaveform mutableWaveform) {
            if (this.isfull()) {
                this.removeone();
            }
            this.cache.put(string, mutableWaveform);
            this.timestamp.put(string, System.currentTimeMillis());
        }

        private boolean isfull() {
            return this.cache.size() >= SCC2WAV.this.cache_capacity;
        }

        private void removeone() {
            String string = this.getOldestKey();
            this.cache.remove(string);
            this.timestamp.remove(string);
        }

        private String getOldestKey() {
            long l = System.currentTimeMillis();
            String string = "";
            Enumeration<String> enumeration = this.cache.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement();
                Long l2 = this.timestamp.get(string2);
                if (l <= l2) continue;
                l = l2;
                string = string2;
            }
            return string;
        }
    }
}

