/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.filewrappers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.SPTerminator;
import jp.crestmuse.cmx.math.Array;
import jp.crestmuse.cmx.misc.QueueReader;
import jp.crestmuse.cmx.misc.QueueWrapper;

public class MutableTimeSeries<D>
implements TimeSeriesCompatible<D> {
    private int nFrames;
    private int timeunit;
    private int dim = -1;
    private BlockingQueue<D> queue = new LinkedBlockingQueue<D>();
    private QueueWrapper<D> qwrap = new QueueWrapper<D>(this.queue);
    private Map<String, String> attr = new HashMap<String, String>();
    private boolean complete = false;

    @Override
    public QueueReader<D> getQueueReader() {
        return this.qwrap.createReader();
    }

    @Override
    public int dim() {
        return this.dim;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void add(D d) throws InterruptedException {
        if (d instanceof Array) {
            int n = ((Array)d).length();
            if (this.dim == n) {
                this.queue.put(d);
            } else {
                if (this.dim != -1) throw new IllegalStateException("unmatch dimension");
                this.dim = n;
                this.queue.put(d);
            }
        } else {
            this.queue.put(d);
        }
        if (!(d instanceof SPTerminator)) return;
        this.complete = true;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public String getAttribute(String string) {
        return this.attr.get(string);
    }

    @Override
    public int getAttributeInt(String string) {
        return Integer.parseInt(this.getAttribute(string));
    }

    @Override
    public double getAttributeDouble(String string) {
        return Double.parseDouble(this.getAttribute(string));
    }

    @Override
    public void setAttribute(String string, String string2) {
        this.attr.put(string, string2);
    }

    @Override
    public void setAttribute(String string, int n) {
        this.attr.put(string, String.valueOf(n));
    }

    @Override
    public void setAttribute(String string, double d) {
        this.attr.put(string, String.valueOf(d));
    }

    @Override
    public Iterator<Map.Entry<String, String>> getAttributeIterator() {
        return this.attr.entrySet().iterator();
    }
}

