/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.filewrappers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SimpleAmusaXMLReader2 {
    private static final String PARSER_CLASS = "org.apache.xerces.parsers.SAXParser";

    public static Result readfile(String string) throws SAXException, IOException {
        XMLReader xMLReader = XMLReaderFactory.createXMLReader(PARSER_CLASS);
        Result result = new Result();
        AmusaXMLContentHandler amusaXMLContentHandler = new AmusaXMLContentHandler(result);
        xMLReader.setContentHandler(amusaXMLContentHandler);
        InputSource inputSource = new InputSource(new FileInputStream(new File(string)));
        xMLReader.parse(inputSource);
        return result;
    }

    private static class AmusaXMLContentHandler
    implements ContentHandler {
        private Result result;
        private String currentTagName = null;
        private StringBuilder sb;

        private AmusaXMLContentHandler(Result result) {
            this.result = result;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() {
        }

        @Override
        public void endDocument() {
        }

        @Override
        public void startPrefixMapping(String string, String string2) {
        }

        @Override
        public void endPrefixMapping(String string) {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string2.equals("amusaxml")) {
                this.result.format = attributes.getValue("format");
            } else if (string2.equals("header")) {
                this.currentTagName = "header";
            } else if (string2.equals("meta")) {
                if (!"header".equals(this.currentTagName)) {
                    throw new SAXException("'meta' should be in 'header'.");
                }
                this.result.header.put(attributes.getValue("name"), attributes.getValue("content"));
            } else if (string2.equals("data")) {
                this.currentTagName = "data";
                this.sb = new StringBuilder();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    hashMap.put(attributes.getLocalName(i), attributes.getValue(i));
                }
                this.result.attrs.add(hashMap);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            if ("data".equals(this.currentTagName)) {
                this.result.data.add(this.sb.toString());
                this.currentTagName = null;
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            if ("data".equals(this.currentTagName)) {
                this.sb.append(cArray, n, n2);
            }
        }

        @Override
        public void ignorableWhitespace(char[] cArray, int n, int n2) {
        }

        @Override
        public void processingInstruction(String string, String string2) {
        }

        @Override
        public void skippedEntity(String string) {
        }
    }

    public static class Result {
        public String format;
        public Map<String, String> header = new HashMap<String, String>();
        public List<Map<String, String>> attrs = new ArrayList<Map<String, String>>();
        public List<String> data = new ArrayList<String>();
    }
}

