/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import jp.crestmuse.cmx.amusaj.sp.FFT;
import jp.crestmuse.cmx.math.ComplexArray;
import jp.crestmuse.cmx.math.ComplexNumber;
import jp.crestmuse.cmx.math.DoubleArray;
import org.apache.commons.math.complex.Complex;
import org.apache.commons.math.transform.FastFourierTransformer;

public class FFTImpl
implements FFT {
    private double[] buff = null;
    private FastFourierTransformer fft = new FastFourierTransformer();

    @Override
    public ComplexArray executeR2C(DoubleArray doubleArray, double[] dArray) {
        int n;
        int n2 = doubleArray.length();
        if (this.buff == null || this.buff.length != n2) {
            this.buff = new double[n2];
        }
        if (dArray == null) {
            for (n = 0; n < n2; ++n) {
                this.buff[n] = doubleArray.get(n);
            }
        } else {
            for (n = 0; n < n2; ++n) {
                this.buff[n] = doubleArray.get(n) * dArray[n];
            }
        }
        Complex[] complexArray = this.fft.transform(this.buff);
        return new MyComplexArray(complexArray).subarrayX(0, n2 / 2 + 1);
    }

    private class MyComplexArray
    implements ComplexArray {
        private Complex[] values;
        private int from;
        private int thru;

        MyComplexArray(Complex[] complexArray) {
            this.values = complexArray;
            this.from = 0;
            this.thru = complexArray.length;
        }

        @Override
        public int length() {
            return this.thru - this.from;
        }

        @Override
        public double getReal(int n) {
            return this.values[this.from + n].getReal();
        }

        @Override
        public double getImag(int n) {
            return this.values[this.from + n].getImaginary();
        }

        @Override
        public ComplexNumber get(int n) {
            return new ComplexNumber(this.getReal(n), this.getImag(n));
        }

        @Override
        public void setReal(int n, double d) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setImag(int n, double d) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(int n, double d, double d2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(int n, ComplexNumber complexNumber) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ComplexArray subarrayX(int n, int n2) {
            MyComplexArray myComplexArray = new MyComplexArray(this.values);
            myComplexArray.from = this.from + n;
            myComplexArray.thru = this.from + n2;
            return myComplexArray;
        }
    }
}

