/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import java.util.Arrays;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.FeatureExtractor;
import jp.crestmuse.cmx.amusaj.sp.SPModule;
import jp.crestmuse.cmx.math.DoubleArray;

public class FeatureExtractionModule
extends SPModule {
    private FeatureExtractor<DoubleArray> fe;
    private String[] types;

    public FeatureExtractionModule(FeatureExtractor<DoubleArray> featureExtractor) {
        this.fe = featureExtractor;
        this.types = new String[featureExtractor.nFeatureTypes()];
        for (int i = 0; i < this.types.length; ++i) {
            this.types[i] = featureExtractor.getFeatureType(i);
        }
    }

    @Override
    public void execute(Object[] objectArray, TimeSeriesCompatible[] timeSeriesCompatibleArray) throws InterruptedException {
        DoubleArray doubleArray = (DoubleArray)objectArray[0];
        int n = timeSeriesCompatibleArray.length;
        this.fe.extractFeatures(doubleArray);
        for (int i = 0; i < n; ++i) {
            TimeSeriesCompatible timeSeriesCompatible = timeSeriesCompatibleArray[i];
            DoubleArray doubleArray2 = this.fe.getFeature(i);
            if (doubleArray2 == null) continue;
            timeSeriesCompatible.add(doubleArray2);
            timeSeriesCompatible.setAttribute("type", this.fe.getFeatureType(i));
        }
    }

    protected String getParamCategory() {
        return "feature";
    }

    public String[] getFeatureTypes() {
        return this.types;
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{DoubleArray.class};
    }

    @Override
    public Class[] getOutputClasses() {
        Object[] objectArray = new Class[this.fe.nFeatureTypes()];
        Arrays.fill(objectArray, DoubleArray.class);
        return objectArray;
    }
}

