/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import jp.crestmuse.cmx.amusaj.filewrappers.PeakSet;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.AmusaParameterSet;
import jp.crestmuse.cmx.amusaj.sp.SPModule;
import jp.crestmuse.cmx.math.BooleanArray;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.math.Operations;

public class HarmonicsExtractor
extends SPModule {
    private double f0range;
    private double freqRange;
    private double powerthrs;
    private int nHarmonics;
    private int nHarmsForF0Calc;
    private boolean setParams = false;

    protected String getParamCategory() {
        return "harmonics";
    }

    protected String[] getUsedParamNames() {
        return new String[]{"F0_SEARCH_RANGE", "HARMONICS_SEARCH_RANGE", "POWER_THRESHOLD", "NUM_OF_HARMONICS", "NUM_OF_HARMONICS_FOR_F0_CALC"};
    }

    private void setParams() {
        AmusaParameterSet amusaParameterSet = AmusaParameterSet.getInstance();
        this.f0range = amusaParameterSet.getParamDouble("harmonics", "F0_SEARCH_RANGE");
        this.freqRange = amusaParameterSet.getParamDouble("harmonics", "HARMONICS_SEARCH_RANGE");
        this.powerthrs = amusaParameterSet.getParamDouble("harmonics", "POWER_THRESHOLD");
        this.nHarmonics = amusaParameterSet.getParamInt("harmonics", "NUM_OF_HARMONICS");
        this.nHarmsForF0Calc = amusaParameterSet.getParamInt("harmonics", "NUM_OF_HARMONICS_FOR_F0_CALC");
        this.setParams = true;
    }

    @Override
    public void execute(Object[] objectArray, TimeSeriesCompatible[] timeSeriesCompatibleArray) throws InterruptedException {
        PeakSet peakSet = (PeakSet)objectArray[0];
        DoubleArray doubleArray = (DoubleArray)objectArray[1];
        double d = doubleArray.get(0);
        PeakSet peakSet2 = this.extractHarmonics(peakSet, d);
        timeSeriesCompatibleArray[0].add(peakSet2 != null ? peakSet2 : new PeakSet(0));
    }

    PeakSet extractHarmonics(PeakSet peakSet, double d) {
        if (!this.setParams) {
            this.setParams();
        }
        if (d == 0.0) {
            return null;
        }
        Operations.MaxResult maxResult = new Operations.MaxResult();
        PeakSet peakSet2 = new PeakSet(this.nHarmonics);
        DoubleArray doubleArray = peakSet.freq();
        DoubleArray doubleArray2 = Operations.div(peakSet.power(), Operations.sum(peakSet.power()));
        double d2 = this.calcAccurateF0(d, doubleArray, doubleArray2);
        for (int i = 0; i < this.nHarmonics; ++i) {
            BooleanArray booleanArray = Operations.or(Operations.lessThan(doubleArray, ((double)(i + 1) - this.freqRange) * d2), Operations.greaterThan(doubleArray, ((double)(i + 1) + this.freqRange) * d2));
            DoubleArray doubleArray3 = Operations.mask(doubleArray2, booleanArray, 0.0);
            Operations.max(doubleArray3, maxResult);
            if (maxResult.argmax > 0) {
                peakSet2.setFreq(i, doubleArray.get(maxResult.argmax));
                peakSet2.setPower(i, maxResult.max);
                continue;
            }
            if (i == 0) {
                peakSet2.setFreq(i, d2);
            } else {
                peakSet2.setFreq(i, 0.0);
            }
            peakSet2.setPower(i, 0.0);
        }
        return peakSet2;
    }

    private double calcAccurateF0(double d, DoubleArray doubleArray, DoubleArray doubleArray2) {
        Operations.MaxResult maxResult = new Operations.MaxResult();
        double d2 = 0.0;
        for (int i = 1; i < this.nHarmsForF0Calc; ++i) {
            BooleanArray booleanArray = Operations.or(Operations.lessThan(doubleArray, (double)i * d / this.f0range), Operations.greaterThan(doubleArray, (double)i * d * this.f0range));
            DoubleArray doubleArray3 = Operations.mask(doubleArray2, booleanArray, Double.NEGATIVE_INFINITY);
            Operations.max(doubleArray3, maxResult);
            if (!(maxResult.max > this.powerthrs)) continue;
            d2 = doubleArray.get(maxResult.argmax) / (double)i;
            break;
        }
        return d2;
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{PeakSet.class, DoubleArray.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{PeakSet.class};
    }
}

