/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import jp.crestmuse.cmx.amusaj.filewrappers.PeakSet;
import jp.crestmuse.cmx.amusaj.sp.AbstractInterpolationModule;
import jp.crestmuse.cmx.math.BooleanArray;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.math.DoubleArrayFactory;
import jp.crestmuse.cmx.math.Operations;
import jp.crestmuse.cmx.math.Utils;

public class HarmonicsTimeSeries {
    private PeakSet[] peaks;
    private int nHarmonics;
    private DoubleArray powerenv;
    private DoubleArray logPowerEnv;
    private DoubleArray logSmoothPowerEnv;
    private boolean analyzed = false;
    private DoubleArrayFactory factory = DoubleArrayFactory.getFactory();

    public HarmonicsTimeSeries(int n, int n2) {
        this.peaks = new PeakSet[n];
        this.nHarmonics = n2;
        this.powerenv = this.factory.createArray(n);
    }

    public void set(int n, PeakSet peakSet) {
        if (peakSet.nPeaks() != this.nHarmonics) {
            throw new IllegalStateException("Num of peaks incompatible.");
        }
        this.peaks[n] = peakSet;
        this.powerenv.set(n, Operations.sum(peakSet.power()));
    }

    public PeakSet get(int n) {
        return this.peaks[n];
    }

    public int nFrames() {
        return this.peaks.length;
    }

    public int nHarmonics() {
        return this.nHarmonics;
    }

    public void interpolate(AbstractInterpolationModule abstractInterpolationModule, int n) {
        for (int i = 0; i < this.nHarmonics; ++i) {
            abstractInterpolationModule.run(new FreqDoubleArray(i, 0, this.peaks.length), n);
            abstractInterpolationModule.run(new PowerDoubleArray(i, 0, this.peaks.length), n);
        }
        abstractInterpolationModule.run(this.powerenv, n);
        this.logPowerEnv = HarmonicsTimeSeries.calcLogPowerEnv(this.powerenv);
        this.logSmoothPowerEnv = HarmonicsTimeSeries.calcLogSmoothPowerEnv(this.powerenv);
        this.analyzed = true;
    }

    private static DoubleArray calcLogPowerEnv(DoubleArray doubleArray) {
        DoubleArray doubleArray2 = Operations.add(doubleArray, 3.0517578125E-5);
        Operations.logX(doubleArray2, 10);
        Operations.mulX(doubleArray2, 20.0);
        Operations.subX(doubleArray2, Operations.max(doubleArray2));
        return doubleArray2;
    }

    private static DoubleArray calcLogSmoothPowerEnv(DoubleArray doubleArray) {
        DoubleArray doubleArray2 = Operations.sgsmooth(Operations.sgsmooth(doubleArray, 20), 20);
        Operations.addX(doubleArray2, -Operations.min(doubleArray2) + 3.0517578125E-5);
        Operations.logX(doubleArray2, 10);
        Operations.mulX(doubleArray2, 20.0);
        Operations.subX(doubleArray2, Operations.max(doubleArray2));
        return doubleArray2;
    }

    public DoubleArray getLogPowerEnv() {
        if (!this.analyzed) {
            throw new IllegalStateException();
        }
        return this.logPowerEnv;
    }

    public DoubleArray getLogSmoothPowerEnv() {
        if (!this.analyzed) {
            throw new IllegalStateException();
        }
        return this.logSmoothPowerEnv;
    }

    public DoubleArray calcMedianPower(int n, int n2) {
        if (!this.analyzed) {
            throw new IllegalStateException();
        }
        DoubleArray doubleArray = this.factory.createArray(this.nHarmonics);
        for (int i = 0; i < this.nHarmonics; ++i) {
            PowerDoubleArray powerDoubleArray = new PowerDoubleArray(i, n, n2);
            doubleArray.set(i, Operations.median(powerDoubleArray));
        }
        double d = Operations.sum(doubleArray);
        if (d != 0.0) {
            Operations.divX(doubleArray, d);
        }
        return doubleArray;
    }

    public DoubleArray calcLengthsOfHarmonicComponents(double d, int n, int n2) {
        if (!this.analyzed) {
            throw new IllegalStateException();
        }
        DoubleArray doubleArray = this.factory.createArray(this.nHarmonics);
        double d2 = Math.pow(10.0, d / 20.0);
        for (int i = 0; i < this.nHarmonics; ++i) {
            PowerDoubleArray powerDoubleArray = new PowerDoubleArray(i, n, n2);
            BooleanArray booleanArray = Operations.greaterThan(powerDoubleArray, d2);
            doubleArray.set(i, Operations.ratioTrue(booleanArray));
        }
        return doubleArray;
    }

    public DoubleArray getF0Envelope() {
        return new FreqDoubleArray(0, 0, this.peaks.length);
    }

    private class PowerDoubleArray
    extends MyDoubleArray {
        PowerDoubleArray(int n, int n2, int n3) {
            super(n, n2, n3);
        }

        @Override
        public double get(int n) {
            return HarmonicsTimeSeries.this.peaks[n + this.from].power(this.k);
        }

        @Override
        public void set(int n, double d) {
            HarmonicsTimeSeries.this.peaks[n + this.from].setPower(this.k, d);
        }
    }

    private class FreqDoubleArray
    extends MyDoubleArray {
        FreqDoubleArray(int n, int n2, int n3) {
            super(n, n2, n3);
        }

        @Override
        public double get(int n) {
            return HarmonicsTimeSeries.this.peaks[n + this.from].freq(this.k);
        }

        @Override
        public void set(int n, double d) {
            HarmonicsTimeSeries.this.peaks[n + this.from].setFreq(this.k, d);
        }
    }

    private abstract class MyDoubleArray
    implements DoubleArray {
        int k;
        int from;
        int thru;

        MyDoubleArray(int n, int n2, int n3) {
            this.k = n;
            this.from = n2;
            this.thru = n3;
        }

        @Override
        public int length() {
            return this.thru - this.from;
        }

        @Override
        public Object clone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double[] toArray() {
            double[] dArray = new double[this.length()];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = this.get(i);
            }
            return dArray;
        }

        @Override
        public DoubleArray subarrayX(int n, int n2) {
            this.from += n;
            this.thru = this.from + n2;
            return this;
        }

        @Override
        public String encode() {
            return Utils.toString2(this);
        }
    }
}

