/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import jp.crestmuse.cmx.amusaj.sp.AbstractInterpolationModule;
import jp.crestmuse.cmx.amusaj.sp.ExpInterpolationModule;
import jp.crestmuse.cmx.amusaj.sp.FeatureExtractor;
import jp.crestmuse.cmx.amusaj.sp.HarmonicsTimeSeries;
import jp.crestmuse.cmx.amusaj.sp.SPException;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.math.DoubleArrayFactory;
import jp.crestmuse.cmx.math.Operations;
import org.apache.commons.math.MathException;
import org.apache.commons.math.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math.distribution.NormalDistributionImpl;
import org.apache.commons.math.optimization.DifferentiableMultivariateVectorialOptimizer;
import org.apache.commons.math.optimization.OptimizationException;
import org.apache.commons.math.optimization.fitting.PolynomialFitter;
import org.apache.commons.math.optimization.general.LevenbergMarquardtOptimizer;

public class KitaharaFeatureExtractor
implements FeatureExtractor<HarmonicsTimeSeries> {
    int ndiv;
    AbstractInterpolationModule interp = ExpInterpolationModule.getInstance();
    int maxFramesForInterpolation;
    private static DoubleArrayFactory factory = DoubleArrayFactory.getFactory();
    DoubleArray featHarmonics;
    DoubleArray featLengthsOfHarmonics;
    DoubleArray featRateOfLongHarmonics;
    DoubleArray featGradOfPowerEnvelope;
    DoubleArray featMedianOfDiffPower;
    DoubleArray featRatioMaxPower;
    DoubleArray featAM;
    DoubleArray featFM;

    public KitaharaFeatureExtractor(int n, int n2) {
        this.ndiv = n;
        this.maxFramesForInterpolation = n2;
    }

    @Override
    public void extractFeatures(HarmonicsTimeSeries harmonicsTimeSeries) {
        this.extractFeatures(harmonicsTimeSeries, 0, harmonicsTimeSeries.nFrames());
    }

    private void extractFeatures(HarmonicsTimeSeries harmonicsTimeSeries, int n, int n2) {
        try {
            harmonicsTimeSeries.interpolate(this.interp, this.maxFramesForInterpolation);
            DoubleArray doubleArray = harmonicsTimeSeries.getLogPowerEnv();
            DoubleArray doubleArray2 = harmonicsTimeSeries.getLogSmoothPowerEnv();
            this.featHarmonics = KitaharaFeatureExtractor.calcHarmonicComponents(harmonicsTimeSeries, n, n2);
            this.featLengthsOfHarmonics = KitaharaFeatureExtractor.calcLengthsOfHarmonicComponents(harmonicsTimeSeries, -60.0, n, n2);
            this.featRateOfLongHarmonics = KitaharaFeatureExtractor.calcRateOfLongHarmonicComponents(this.featLengthsOfHarmonics);
            this.featGradOfPowerEnvelope = factory.createArray(1);
            this.featGradOfPowerEnvelope.set(0, KitaharaFeatureExtractor.calcGradOfPowerEnvelope(doubleArray, n, n2));
            this.featMedianOfDiffPower = KitaharaFeatureExtractor.calcMedianOfDiffPower(doubleArray2, n, n2, this.ndiv);
            this.featAM = KitaharaFeatureExtractor.calcModulation(doubleArray, n, n2);
            this.featFM = KitaharaFeatureExtractor.calcModulation(harmonicsTimeSeries.getF0Envelope(), n, n2);
        }
        catch (MathException mathException) {
            throw new SPException((Exception)((Object)mathException));
        }
    }

    private static DoubleArray calcHarmonicComponents(HarmonicsTimeSeries harmonicsTimeSeries, int n, int n2) throws MathException {
        int n3 = harmonicsTimeSeries.nHarmonics();
        DoubleArray doubleArray = factory.createArray(n3 + 1);
        DoubleArray doubleArray2 = harmonicsTimeSeries.calcMedianPower(n, n2);
        DoubleArray doubleArray3 = Operations.makeArithmeticSeries(n3);
        double d = Operations.sum(Operations.mul(doubleArray2, doubleArray3));
        doubleArray.set(0, d);
        for (int i = 0; i < n3 - 1; ++i) {
            doubleArray.set(i + 1, Operations.sum(doubleArray2, 0, i + 1));
        }
        double d2 = (Operations.sumodd(doubleArray2) + Double.MIN_VALUE) / (Operations.sumeven(doubleArray2) + Double.MIN_VALUE);
        NormalDistributionImpl normalDistributionImpl = new NormalDistributionImpl(0.0, 100.0);
        d2 = normalDistributionImpl.cumulativeProbability(d2) - normalDistributionImpl.cumulativeProbability(-d2);
        doubleArray.set(n3, d2);
        return doubleArray;
    }

    private static DoubleArray calcLengthsOfHarmonicComponents(HarmonicsTimeSeries harmonicsTimeSeries, double d, int n, int n2) {
        return harmonicsTimeSeries.calcLengthsOfHarmonicComponents(d, n, n2);
    }

    private static DoubleArray calcRateOfLongHarmonicComponents(DoubleArray doubleArray) {
        double[] dArray = new double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9};
        DoubleArray doubleArray2 = factory.createArray(dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            doubleArray2.set(i, Operations.nGreaterThan(doubleArray, dArray[i]));
        }
        return doubleArray2;
    }

    private static double calcGradOfPowerEnvelope(DoubleArray doubleArray, int n, int n2) throws OptimizationException {
        PolynomialFitter polynomialFitter = new PolynomialFitter(1, (DifferentiableMultivariateVectorialOptimizer)new LevenbergMarquardtOptimizer());
        for (int i = 0; i < n2 - n; ++i) {
            polynomialFitter.addObservedPoint(1.0, 1.0 + (double)i, doubleArray.get(n + i));
        }
        PolynomialFunction polynomialFunction = polynomialFitter.fit();
        double[] dArray = polynomialFunction.getCoefficients();
        return dArray.length >= 2 ? dArray[1] : 0.0;
    }

    private static DoubleArray calcMedianOfDiffPower(DoubleArray doubleArray, int n, int n2, int n3) {
        DoubleArray doubleArray2 = factory.createArray(n3);
        for (int i = 0; i < n3; ++i) {
            int n4 = n + (i + 1) * (n2 - n) / n3;
            doubleArray2.set(i, KitaharaFeatureExtractor.calcMedianOfDiffPower(doubleArray, n, n4));
        }
        return doubleArray2;
    }

    private static double calcMedianOfDiffPower(DoubleArray doubleArray, int n, int n2) {
        return Operations.median(Operations.diff(doubleArray.subarrayX(n, n2)));
    }

    private static DoubleArray calcRatioMaxPower(DoubleArray doubleArray, int n, int n2, int n3) {
        DoubleArray doubleArray2 = doubleArray.subarrayX(n, n2);
        double d = Operations.max(doubleArray2);
        DoubleArray doubleArray3 = factory.createArray(n3);
        for (int i = 0; i < n3; ++i) {
            int n4 = (i + 1) * (n2 - n) / (n3 + 1);
            doubleArray3.set(i, doubleArray2.get(n4) - d);
        }
        return doubleArray3;
    }

    private static DoubleArray calcRatioMaxPower(DoubleArray doubleArray, int n, int n2, int[] nArray) {
        DoubleArray doubleArray2 = doubleArray.subarrayX(n, n2);
        double d = Operations.max(doubleArray2);
        DoubleArray doubleArray3 = factory.createArray(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            doubleArray3.set(i, doubleArray2.get(nArray[i]) - d);
        }
        return doubleArray3;
    }

    private static DoubleArray calcModulation(DoubleArray doubleArray, int n, int n2) {
        DoubleArray doubleArray2 = doubleArray.subarrayX(n, n2);
        DoubleArray doubleArray3 = factory.createArray(2);
        doubleArray3.set(0, KitaharaFeatureExtractor.calcFreqOfModulation(doubleArray2));
        doubleArray3.set(1, KitaharaFeatureExtractor.calcAmpOfModulation(doubleArray2));
        return doubleArray3;
    }

    private static double calcFreqOfModulation(DoubleArray doubleArray) {
        DoubleArray doubleArray2 = Operations.sdiff(doubleArray, 3);
        double d = (double)Operations.nZeroCross(doubleArray2) / (double)doubleArray.length();
        return d;
    }

    private static double calcAmpOfModulation(DoubleArray doubleArray) {
        DoubleArray doubleArray2 = Operations.sgsmooth(Operations.sgsmooth(Operations.sgsmooth(doubleArray, 20), 20), 20);
        DoubleArray doubleArray3 = Operations.sub(doubleArray, doubleArray2);
        double d = Operations.iqr(doubleArray3);
        return d;
    }

    @Override
    public DoubleArray getFeature(int n) {
        if (n == 0) {
            return Operations.concat(new DoubleArray[]{this.featHarmonics, this.featRateOfLongHarmonics, this.featGradOfPowerEnvelope, this.featMedianOfDiffPower, this.featAM, this.featFM});
        }
        return null;
    }

    @Override
    public int nFeatureTypes() {
        return 1;
    }

    @Override
    public String getFeatureType(int n) {
        if (n == 0) {
            return "kitahara28dim";
        }
        return null;
    }
}

