/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import jp.crestmuse.cmx.amusaj.sp.AbstractInterpolationModule;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.math.Utils;

class LinearInterpolationModule
extends AbstractInterpolationModule {
    private static final LinearInterpolationModule interp = new LinearInterpolationModule();
    private double c;

    LinearInterpolationModule() {
    }

    @Override
    boolean isMissing(double d) {
        return Double.isInfinite(d) || Double.isNaN(d);
    }

    @Override
    void calcCoefficient(int n, double d, int n2, double d2) {
        this.c = (d2 - d) / (double)(n2 - n);
    }

    @Override
    double calcValue(int n, int n2, double d, int n3, double d2) {
        return d + this.c * (double)(n - n2);
    }

    static LinearInterpolationModule getInstance() {
        return interp;
    }

    static void interpolateX(DoubleArray doubleArray, int n) {
        interp.run(doubleArray, n);
    }

    static DoubleArray interpolate(DoubleArray doubleArray, int n) {
        DoubleArray doubleArray2 = Utils.cloneArray(doubleArray);
        LinearInterpolationModule.interpolateX(doubleArray2, n);
        return doubleArray2;
    }
}

