/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import jp.crestmuse.cmx.amusaj.filewrappers.PeakSet;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.AmusaParameterSet;
import jp.crestmuse.cmx.amusaj.sp.SPModule;
import jp.crestmuse.cmx.math.ComplexArray;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.math.DoubleArrayFactory;
import jp.crestmuse.cmx.math.Operations;

public class PeakExtractor
extends SPModule {
    private static double powerthrs = 0.0;
    private static double rpowerthrs = 0.0;
    private int size = 0;
    private double[] power0;
    private DoubleArray freq;
    private DoubleArray power;
    private DoubleArray phase;
    private DoubleArray iid;
    private DoubleArray ipd;
    private int t;
    private DoubleArrayFactory factory = DoubleArrayFactory.getFactory();

    public PeakExtractor() {
        AmusaParameterSet amusaParameterSet = AmusaParameterSet.getInstance();
        powerthrs = amusaParameterSet.getParamDouble("fft", "POWER_THRESHOLD");
        rpowerthrs = amusaParameterSet.getParamDouble("fft", "RELATIVE_POWER_THRESHOLD");
    }

    private void reset(int n) {
        this.size = n;
        this.power0 = new double[n];
        this.freq = this.factory.createArray(n);
        this.power = this.factory.createArray(n);
        this.phase = this.factory.createArray(n);
        this.iid = this.factory.createArray(n);
        this.ipd = this.factory.createArray(n);
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ComplexArray.class, ComplexArray.class, ComplexArray.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{PeakSet.class};
    }

    @Override
    public void execute(Object[] objectArray, TimeSeriesCompatible[] timeSeriesCompatibleArray) throws InterruptedException {
        boolean bl;
        ComplexArray complexArray;
        ComplexArray complexArray2;
        ComplexArray complexArray3 = (ComplexArray)objectArray[0];
        AmusaParameterSet amusaParameterSet = AmusaParameterSet.getInstance();
        int n = amusaParameterSet.getParamInt("fft", "SAMPLE_RATE");
        int n2 = amusaParameterSet.getParamInt("fft", "WINDOW_SIZE");
        if (objectArray.length > 1 && objectArray[1] != null) {
            complexArray2 = (ComplexArray)objectArray[1];
            complexArray = (ComplexArray)objectArray[2];
            bl = true;
        } else {
            complexArray2 = null;
            complexArray = null;
            bl = false;
        }
        double d = Double.NEGATIVE_INFINITY;
        int n3 = complexArray3.length();
        if (this.size != n3) {
            this.reset(n3);
        }
        for (int i = 0; i < this.size; ++i) {
            double d2;
            this.power0[i] = d2 = Math.hypot(complexArray3.getReal(i), complexArray3.getImag(i));
            if (!(d2 > d)) continue;
            d = d2;
        }
        double d3 = d * rpowerthrs;
        int n4 = 0;
        int n5 = 2;
        while (n5 < this.size - 2) {
            if (this.power0[n5] > this.power0[n5 + 1]) {
                if (this.power0[n5 + 1] > this.power0[n5 + 2]) {
                    if (this.power0[n5] > this.power0[n5 - 1] && this.power0[n5 - 1] > this.power0[n5 - 2] && this.power0[n5] > powerthrs && this.power0[n5] > d3) {
                        this.freq.set(n4, (double)(n5 * n) / (double)n2);
                        this.power.set(n4, this.power0[n5]);
                        this.phase.set(n4, Math.atan2(complexArray3.getImag(n5), complexArray3.getReal(n5)));
                        if (bl) {
                            this.iid.set(n4, Math.hypot(complexArray.getReal(n5), complexArray.getImag(n5)) / Math.hypot(complexArray2.getReal(n5), complexArray2.getImag(n5)));
                            this.ipd.set(n4, Math.atan2(complexArray.getImag(n5), complexArray.getReal(n5)) - Math.atan2(complexArray2.getImag(n5), complexArray2.getReal(n5)));
                        } else {
                            this.iid.set(n4, 1.0);
                            this.ipd.set(n4, 0.0);
                        }
                        ++n4;
                        n5 += 4;
                        continue;
                    }
                    n5 += 4;
                    continue;
                }
                n5 += 3;
                continue;
            }
            if (this.power0[n5] <= this.power0[n5 - 1]) {
                n5 += 2;
                continue;
            }
            ++n5;
        }
        PeakSet peakSet = new PeakSet(Operations.subarray(this.freq, 0, n4), Operations.subarray(this.power, 0, n4), Operations.subarray(this.phase, 0, n4), Operations.subarray(this.iid, 0, n4), Operations.subarray(this.ipd, 0, n4));
        timeSeriesCompatibleArray[0].add(peakSet);
    }
}

