/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import java.util.LinkedList;
import jp.crestmuse.cmx.amusaj.filewrappers.MutableTimeSeries;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.ProducerConsumerCompatible;
import jp.crestmuse.cmx.amusaj.sp.SPIllegalConnectionException;
import jp.crestmuse.cmx.amusaj.sp.SPModule;
import jp.crestmuse.cmx.amusaj.sp.SPTerminator;
import jp.crestmuse.cmx.misc.QueueReader;

public class SPGroup
extends SPModule {
    private Class[] inputClasses;
    private Class[] outputClasses;
    private LinkedList<SPGroupModule> modules = new LinkedList();
    TimeSeriesCompatible[] headDest;
    QueueReader[] tailSrc;

    @Override
    public void execute(Object[] objectArray, TimeSeriesCompatible[] timeSeriesCompatibleArray) throws InterruptedException {
        for (int i = 0; i < objectArray.length; ++i) {
            this.headDest[i].add(objectArray[i]);
        }
        for (SPGroupModule sPGroupModule : this.modules) {
            sPGroupModule.run();
        }
        if (this.tailSrc == null) {
            this.tailSrc = new QueueReader[this.outputClasses.length];
            for (int i = 0; i < this.outputClasses.length; ++i) {
                this.tailSrc[i] = this.modules.getLast().dest[i].getQueueReader();
            }
        }
        for (int i = 0; i < this.outputClasses.length; ++i) {
            timeSeriesCompatibleArray[i].add(this.tailSrc[i].take());
        }
    }

    @Override
    public Class[] getInputClasses() {
        return this.inputClasses;
    }

    @Override
    public Class[] getOutputClasses() {
        return this.outputClasses;
    }

    public void addModule(ProducerConsumerCompatible producerConsumerCompatible) {
        SPGroupModule sPGroupModule = new SPGroupModule(producerConsumerCompatible);
        if (this.modules.size() == 0) {
            this.inputClasses = producerConsumerCompatible.getInputClasses();
            this.headDest = new TimeSeriesCompatible[this.inputClasses.length];
            for (int i = 0; i < this.inputClasses.length; ++i) {
                this.headDest[i] = new MutableTimeSeries();
                sPGroupModule.src[i] = this.headDest[i].getQueueReader();
            }
        } else {
            SPGroupModule sPGroupModule2 = this.modules.getLast();
            if (sPGroupModule2.outputChannelNum != sPGroupModule.inputChannelNum) {
                throw new SPIllegalConnectionException("different channel length " + sPGroupModule2.module.getClass().getName() + " and " + sPGroupModule.module.getClass().getName());
            }
            for (int i = 0; i < sPGroupModule2.outputChannelNum; ++i) {
                if (sPGroupModule2.module.getOutputClasses()[i] != producerConsumerCompatible.getInputClasses()[i]) {
                    throw new SPIllegalConnectionException("can't connect " + sPGroupModule2.module.getOutputClasses()[i].getName() + " and " + producerConsumerCompatible.getInputClasses()[i].getName());
                }
                sPGroupModule.src[i] = sPGroupModule2.dest[i].getQueueReader();
            }
        }
        this.modules.add(sPGroupModule);
        this.outputClasses = producerConsumerCompatible.getOutputClasses();
    }

    @Override
    public void stop() {
        for (SPGroupModule sPGroupModule : this.modules) {
            sPGroupModule.stop();
        }
    }

    private class SPGroupModule {
        ProducerConsumerCompatible module;
        QueueReader[] src;
        TimeSeriesCompatible[] dest;
        Object[] inputElements;
        int inputChannelNum;
        int outputChannelNum;

        SPGroupModule(ProducerConsumerCompatible producerConsumerCompatible) {
            this.inputChannelNum = producerConsumerCompatible.getInputClasses().length;
            this.outputChannelNum = producerConsumerCompatible.getOutputClasses().length;
            this.module = producerConsumerCompatible;
            this.src = new QueueReader[this.inputChannelNum];
            this.dest = new TimeSeriesCompatible[this.outputChannelNum];
            this.inputElements = new Object[this.inputChannelNum];
            for (int i = 0; i < this.outputChannelNum; ++i) {
                this.dest[i] = new MutableTimeSeries();
            }
        }

        void run() {
            try {
                for (int i = 0; i < this.inputChannelNum; ++i) {
                    this.inputElements[i] = this.src[i].take();
                }
                if (this.inputChannelNum > 0 && this.inputElements[0] instanceof SPTerminator) {
                    for (TimeSeriesCompatible timeSeriesCompatible : this.dest) {
                        timeSeriesCompatible.add(SPTerminator.getInstance());
                    }
                    return;
                }
                this.module.execute(this.inputElements, this.dest);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }

        void stop() {
            this.module.stop();
        }
    }
}

