/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.AmusaParameterSet;
import jp.crestmuse.cmx.amusaj.sp.FFT;
import jp.crestmuse.cmx.amusaj.sp.FFTFactory;
import jp.crestmuse.cmx.amusaj.sp.SPModule;
import jp.crestmuse.cmx.amusaj.sp.Utils;
import jp.crestmuse.cmx.math.ComplexArray;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.math.DoubleArrayFactory;

public class STFT
extends SPModule {
    int winsize = -1;
    String wintype = null;
    double[] window;
    private boolean paramSet = false;
    private static final FFTFactory factory = FFTFactory.getFactory();
    FFT fft = factory.createFFT();
    private static final DoubleArrayFactory dfactory = DoubleArrayFactory.getFactory();
    private boolean isStereo;

    public STFT(boolean bl) {
        this.isStereo = bl;
    }

    public void changeWindow(String string, int n) {
        AmusaParameterSet amusaParameterSet = AmusaParameterSet.getInstance();
        this.winsize = n;
        amusaParameterSet.setParam("fft", "WINDOW_SIZE", n);
        this.wintype = string;
        amusaParameterSet.setParam("fft", "WINDOW_TYPE", string);
        if (string.startsWith("ham")) {
            this.window = Utils.hamming(n);
        } else if (string.startsWith("han")) {
            this.window = Utils.hanning(n);
        } else if (string.startsWith("gaus")) {
            this.window = Utils.gaussian(n);
        } else if (string.startsWith("rect")) {
            this.window = null;
        } else {
            throw new IllegalStateException("Unsupported window type");
        }
    }

    protected String getParamCategory() {
        return "fft";
    }

    protected String[] getUsedParamNames() {
        return new String[]{"WINDOW_TYPE"};
    }

    void setParams() {
        if (this.paramSet) {
            return;
        }
        AmusaParameterSet amusaParameterSet = AmusaParameterSet.getInstance();
        this.wintype = amusaParameterSet.getParam("fft", "WINDOW_TYPE").toLowerCase();
        this.paramSet = true;
    }

    @Override
    public void execute(Object[] objectArray, TimeSeriesCompatible[] timeSeriesCompatibleArray) throws InterruptedException {
        this.setParams();
        DoubleArray doubleArray = (DoubleArray)objectArray[0];
        if (this.winsize < 0 || this.winsize != doubleArray.length()) {
            this.changeWindow(this.wintype, doubleArray.length());
        }
        ComplexArray complexArray = this.fft.executeR2C(doubleArray, this.window);
        timeSeriesCompatibleArray[0].add(complexArray);
        if (this.isStereo) {
            timeSeriesCompatibleArray[1].add(this.fft.executeR2C((DoubleArray)objectArray[1], this.window));
            timeSeriesCompatibleArray[2].add(this.fft.executeR2C((DoubleArray)objectArray[2], this.window));
        } else {
            timeSeriesCompatibleArray[1].add(complexArray);
            timeSeriesCompatibleArray[2].add(complexArray);
        }
    }

    @Override
    public Class[] getInputClasses() {
        if (this.isStereo) {
            return new Class[]{DoubleArray.class, DoubleArray.class, DoubleArray.class};
        }
        return new Class[]{DoubleArray.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ComplexArray.class, ComplexArray.class, ComplexArray.class};
    }
}

