/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.commands;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.commands.CMXCommand;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.DeviationInstanceWrapper;
import jp.crestmuse.cmx.filewrappers.MIDIXMLWrapper;
import jp.crestmuse.cmx.filewrappers.MusicXMLWrapper;
import jp.crestmuse.cmx.filewrappers.SCCXMLWrapper;
import jp.crestmuse.cmx.misc.PerformanceMatcher3;
import org.xml.sax.SAXException;

public class DeviationInstanceExtractor
extends CMXCommand<MusicXMLWrapper, DeviationInstanceWrapper> {
    private MIDIXMLWrapper midixml;
    private String scoreFileName = "score.mid";
    private String midiXmlFileName = "midi.xml";
    private String sccXmlFileName = "scc.xml";
    private String remadeSmfFileName = "result.mid";
    private boolean remakeSMF = false;
    private int division = 0;
    private double rowRiscInc = -1.0;
    private double colRiscInc = -1.0;
    private double ioiWeight = -1.0;
    private String pathFileName = null;

    @Override
    public String getDestDir() {
        return super.getDestDir();
    }

    @Override
    protected boolean setOptionsLocal(String string, String string2) {
        if (string.equals("-smf")) {
            try {
                this.midixml = MIDIXMLWrapper.readSMF(string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
            return true;
        }
        if (string.equals("-midixml")) {
            try {
                this.midixml = (MIDIXMLWrapper)CMXFileWrapper.readfile(string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
            return true;
        }
        if (string.equals("-score")) {
            this.scoreFileName = string2;
            return true;
        }
        if (string.equals("-midi")) {
            this.midiXmlFileName = string2;
            return true;
        }
        if (string.equals("-result")) {
            this.remadeSmfFileName = string2;
            return true;
        }
        if (string.equals("-division")) {
            this.division = Integer.parseInt(string2);
            return true;
        }
        if (string.equals("-rowrisc")) {
            this.rowRiscInc = Double.parseDouble(string2);
            return true;
        }
        if (string.equals("-colrisc")) {
            this.colRiscInc = Double.parseDouble(string2);
            return true;
        }
        if (string.equals("-ioi")) {
            this.ioiWeight = Double.parseDouble(string2);
            return true;
        }
        if (string.equals("-miss")) {
            PerformanceMatcher3.MISS_EXTRA_ONSET_DIFF = Double.parseDouble(string2);
            return true;
        }
        if (string.equals("-pathwrite")) {
            PerformanceMatcher3.DTW_PATH_FILENAME = string2;
            return true;
        }
        if (string.equals("-pathread")) {
            this.pathFileName = string2;
            return true;
        }
        return false;
    }

    @Override
    protected boolean setBoolOptionsLocal(String string) {
        if (string.equals("-remakeSMF")) {
            this.remakeSMF = true;
            return true;
        }
        return false;
    }

    @Override
    protected DeviationInstanceWrapper run(MusicXMLWrapper musicXMLWrapper) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        String string = this.getDestDir();
        if (this.remakeSMF) {
            musicXMLWrapper.makeDeadpanSCCXML(this.midixml.ticksPerBeat()).toMIDIXML().writefileAsSMF(new File(string, this.scoreFileName));
        }
        if (this.rowRiscInc != -1.0) {
            PerformanceMatcher3.setRowRiscInc(this.rowRiscInc);
        }
        if (this.colRiscInc != -1.0) {
            PerformanceMatcher3.setColRiscInc(this.colRiscInc);
        }
        if (this.ioiWeight != -1.0) {
            PerformanceMatcher3.setIoiWeight(this.ioiWeight);
        }
        DeviationInstanceWrapper deviationInstanceWrapper = this.pathFileName == null ? (this.division == 0 ? PerformanceMatcher3.extractDeviation(musicXMLWrapper, this.midixml) : PerformanceMatcher3.extractDeviation(musicXMLWrapper, this.midixml, this.division)) : (this.division == 0 ? PerformanceMatcher3.extractDeviation(musicXMLWrapper, this.midixml, new File(this.pathFileName)) : PerformanceMatcher3.extractDeviation(musicXMLWrapper, this.midixml, this.division, new File(this.pathFileName)));
        deviationInstanceWrapper.finalizeDocument();
        if (this.remakeSMF) {
            SCCXMLWrapper sCCXMLWrapper = deviationInstanceWrapper.toSCCXML(this.midixml.ticksPerBeat());
            sCCXMLWrapper.writefile(new File(string, this.sccXmlFileName));
            MIDIXMLWrapper mIDIXMLWrapper = sCCXMLWrapper.toMIDIXML();
            mIDIXMLWrapper.writefile(new File(string, this.midiXmlFileName));
            mIDIXMLWrapper.writefileAsSMF(new File(string, this.remadeSmfFileName));
        }
        return deviationInstanceWrapper;
    }

    public static void main(String[] stringArray) {
        DeviationInstanceExtractor deviationInstanceExtractor = new DeviationInstanceExtractor();
        try {
            deviationInstanceExtractor.start(stringArray);
        }
        catch (Exception exception) {
            deviationInstanceExtractor.showErrorMessage(exception);
            System.exit(1);
        }
    }
}

