/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.commands;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.commands.CMXCommand;
import jp.crestmuse.cmx.filewrappers.DeviationDataSet;
import jp.crestmuse.cmx.filewrappers.DeviationInstanceWrapper;
import jp.crestmuse.cmx.filewrappers.InvalidFileTypeException;
import jp.crestmuse.cmx.filewrappers.MusicXMLWrapper;
import jp.crestmuse.cmx.handlers.NoteHandlerPartwise;
import org.xml.sax.SAXException;

public class PerformanceRenderingTest2
extends CMXCommand<MusicXMLWrapper, DeviationInstanceWrapper> {
    private DeviationDataSet dds;

    public static void main(String[] stringArray) {
        PerformanceRenderingTest2 performanceRenderingTest2 = new PerformanceRenderingTest2();
        try {
            performanceRenderingTest2.start(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    protected DeviationInstanceWrapper run(MusicXMLWrapper musicXMLWrapper) throws IOException, ParserConfigurationException, SAXException, TransformerException, InvalidFileTypeException {
        this.dds = new DeviationDataSet(musicXMLWrapper);
        this.dds.addNonPartwiseControl(1, 1.0, "tempo", 120.0);
        musicXMLWrapper.processNotePartwise(new ProcessHandler());
        return this.dds.toWrapper();
    }

    private void makeExpressionOfNote(MusicXMLWrapper.MusicData musicData) {
        if (!(musicData instanceof MusicXMLWrapper.Note)) {
            return;
        }
        MusicXMLWrapper.Note note = (MusicXMLWrapper.Note)musicData;
        String string = "Note[" + note.noteName();
        if (!note.rest()) {
            string = string + ", " + note.notenum();
        }
        string = string + "] ";
        System.out.print(string);
        MusicXMLWrapper.Notations notations = note.getFirstNotations();
        if (notations != null) {
            if (notations.hasArticulation("staccato")) {
                System.out.print(" staccato");
                if (note.chordNotes() == null) {
                    this.dds.addNoteDeviation(note, 0.0, -0.5 * (double)note.duration() / 4.0, 1.0, 1.0);
                } else {
                    System.out.print(" w/chord ");
                    this.dds.addChordDeviation(note, 0.0, -0.5 * (double)note.duration() / 4.0, 1.0, 1.0);
                }
            }
            if (notations.fermataType() != null) {
                System.out.print(" fermata");
                this.dds.addNonPartwiseControl(note.measure().number(), note.beat(), "tempo-deviation", 0.5);
            }
        }
        if (note.grace()) {
            this.dds.addNoteDeviation(note, -0.125, 0.0, 1.2, 1.0);
        }
        System.out.println();
    }

    private class ProcessHandler
    implements NoteHandlerPartwise {
        private ProcessHandler() {
        }

        @Override
        public void beginMeasure(MusicXMLWrapper.Measure measure, MusicXMLWrapper musicXMLWrapper) {
            System.out.println("Measure " + measure.number());
        }

        @Override
        public void beginPart(MusicXMLWrapper.Part part, MusicXMLWrapper musicXMLWrapper) {
            System.out.println("Part " + part.id());
        }

        @Override
        public void endMeasure(MusicXMLWrapper.Measure measure, MusicXMLWrapper musicXMLWrapper) {
        }

        @Override
        public void endPart(MusicXMLWrapper.Part part, MusicXMLWrapper musicXMLWrapper) {
        }

        @Override
        public void processMusicData(MusicXMLWrapper.MusicData musicData, MusicXMLWrapper musicXMLWrapper) {
            PerformanceRenderingTest2.this.makeExpressionOfNote(musicData);
        }
    }
}

