/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.filewrappers;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;
import jp.crestmuse.cmx.filewrappers.FileWrapperCompatible;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.math.DoubleMatrix;
import jp.crestmuse.cmx.math.Operations;
import jp.crestmuse.cmx.misc.PrintStreamWrapper;
import jp.crestmuse.cmx.misc.PrintWriterWrapper;
import jp.crestmuse.cmx.misc.Printable;

public class CSVMatrixWrapper
implements FileWrapperCompatible {
    private DoubleMatrix matrix;

    public CSVMatrixWrapper(DoubleMatrix doubleMatrix) {
        this.matrix = doubleMatrix;
    }

    public CSVMatrixWrapper(DoubleArray doubleArray) {
        this(Operations.toMatrixV(doubleArray));
    }

    @Override
    public String getFileName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        this.write(new PrintStreamWrapper(new PrintStream(outputStream)));
    }

    @Override
    public void write(Writer writer) throws IOException {
        this.write(new PrintWriterWrapper(new PrintWriter(writer)));
    }

    @Override
    public void writefile(File file) throws IOException {
        this.write(new PrintStreamWrapper(new PrintStream(file)));
    }

    @Override
    public void writeGZippedFile(File file) throws IOException {
        this.write(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(file))));
    }

    private void write(Printable printable) throws IOException {
        printable.println(this.matrix.encode());
    }
}

