/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.filewrappers;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import jp.crestmuse.cmx.filewrappers.FileWrapperCompatible;
import org.xml.sax.SAXException;

public class CSVWrapper
implements FileWrapperCompatible,
Iterable<List<String>> {
    private String fileName;
    private List<List<String>> sheet;

    public CSVWrapper() {
        this.fileName = "";
        this.sheet = new ArrayList<List<String>>();
    }

    public CSVWrapper(String string) {
        this.fileName = string;
        this.sheet = new ArrayList<List<String>>();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String string3 : string2.split(",")) {
                    arrayList.add(string3);
                }
                this.sheet.add(arrayList);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addRow() {
        this.sheet.add(new ArrayList());
    }

    public List<String> getRow(int n) {
        return this.sheet.get(n);
    }

    @Override
    public Iterator<List<String>> iterator() {
        return this.sheet.iterator();
    }

    public void addValue(int n, String string) {
        this.getRow(n).add(string);
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException, SAXException {
        for (List<String> list : this.sheet) {
            for (String string : list) {
                outputStream.write((string + ",").getBytes());
            }
            outputStream.write(System.getProperty("line.separator").getBytes());
        }
        outputStream.close();
    }

    @Override
    public void write(Writer writer) throws IOException, SAXException {
        for (List<String> list : this.sheet) {
            for (String string : list) {
                writer.write(string + ",");
            }
            writer.write(System.getProperty("line.separator"));
        }
        writer.close();
    }

    @Override
    public void writeGZippedFile(File file) throws IOException, SAXException {
        this.write(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(file))));
    }

    @Override
    public void writefile(File file) throws IOException, SAXException {
        this.write(new FileWriter(file));
    }

    public static void main(String[] stringArray) {
        try {
            CSVWrapper cSVWrapper = new CSVWrapper("a.csv");
            cSVWrapper.write(System.out);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

