/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.filewrappers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.CSVWrapper;
import jp.crestmuse.cmx.filewrappers.DeviationDataSet;
import jp.crestmuse.cmx.filewrappers.InvalidElementException;
import jp.crestmuse.cmx.filewrappers.InvalidFileTypeException;
import jp.crestmuse.cmx.filewrappers.MusicXMLWrapper;
import jp.crestmuse.cmx.filewrappers.NodeInterface;
import jp.crestmuse.cmx.filewrappers.SCCXMLWrapper;
import jp.crestmuse.cmx.handlers.NoteHandlerAdapterPartwise;
import jp.crestmuse.cmx.handlers.NoteHandlerPartwise;
import jp.crestmuse.cmx.misc.BaseDynamicsEvent;
import jp.crestmuse.cmx.misc.MutableControlChange;
import jp.crestmuse.cmx.misc.MutableMusicEvent;
import jp.crestmuse.cmx.misc.MutableNote;
import jp.crestmuse.cmx.misc.NodeSearchFilter;
import jp.crestmuse.cmx.misc.NoteCompatible;
import jp.crestmuse.cmx.misc.Ordered;
import jp.crestmuse.cmx.misc.ProgramBugException;
import jp.crestmuse.cmx.misc.TimeFreqRepresentation;
import jp.crestmuse.cmx.misc.TreeView;
import jp.crestmuse.cmx.misc.XMLException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DeviationInstanceWrapper
extends CMXFileWrapper {
    public static final String TOP_TAG = "deviation";
    private MusicXMLWrapper targetMusicXML = null;
    private String targetMusicXMLFileName = null;
    private TimewiseControlView tctrlview = null;
    private HashMap<String, TimewiseControlView> pctrlviews = new HashMap();
    private HashMap<String, TreeView<ExtraNote>> extraNotes = new HashMap();
    private Map<MusicXMLWrapper.Note, NoteDeviation> noteDevMap = new HashMap<MusicXMLWrapper.Note, NoteDeviation>();
    private Map<MusicXMLWrapper.Note, ChordDeviation> chordDevMap = new HashMap<MusicXMLWrapper.Note, ChordDeviation>();
    private Map<MusicXMLWrapper.Note, MissNote> missNoteMap = new HashMap<MusicXMLWrapper.Note, MissNote>();
    private int baseVelocity = 100;
    private boolean alreadyAnalyzed = false;
    private double currentTempo = 120.0;
    private int initticks = 0;
    private double lastTempo = this.currentTempo;
    private final int linearDivision = 8;
    private static NoteDeviationInterface defaultND = new DefaultNoteDeviation();

    public void setBaseVelocity(int n) {
        this.baseVelocity = n;
    }

    public int getBaseVelocity() {
        return this.baseVelocity;
    }

    public MusicXMLWrapper getTargetMusicXML() throws IOException {
        if (this.targetMusicXML == null) {
            if (this.getParentPath() != null) {
                DeviationInstanceWrapper.addPathFirst(this.getParentPath());
            }
            this.targetMusicXML = (MusicXMLWrapper)DeviationInstanceWrapper.readfile(this.getTargetMusicXMLFileName());
        }
        return this.targetMusicXML;
    }

    public String getTargetMusicXMLFileName() {
        if (this.targetMusicXMLFileName == null) {
            File file = new File(this.getTopTagAttribute("target"));
            if (file.getParent() != null) {
                DeviationInstanceWrapper.addPathFirst(file.getParent());
            }
            this.targetMusicXMLFileName = file.getName();
        }
        return this.targetMusicXMLFileName;
    }

    public void setTargetMusicXMLFileName(String string) {
        File file = new File(string);
        if (file.getParent() != null) {
            DeviationInstanceWrapper.addPathFirst(file.getParent());
        }
        this.targetMusicXMLFileName = file.getName();
        if (!this.isFinalized()) {
            this.setTopTagAttribute("target", this.targetMusicXMLFileName);
        }
    }

    public static void changeDefaultMusicXMLDirName(String string) {
        DeviationInstanceWrapper.addPathFirst(string);
    }

    public double getInitialSilence() {
        String string = this.getDocument().getDocumentElement().getAttribute("init-silence");
        if (string == null || string.length() == 0) {
            return 0.0;
        }
        return Double.parseDouble(string);
    }

    public static DeviationInstanceWrapper createDeviationInstanceFor(MusicXMLWrapper musicXMLWrapper) {
        try {
            DeviationInstanceWrapper deviationInstanceWrapper = (DeviationInstanceWrapper)DeviationInstanceWrapper.createDocument(TOP_TAG);
            deviationInstanceWrapper.targetMusicXML = musicXMLWrapper;
            deviationInstanceWrapper.setTargetMusicXMLFileName(musicXMLWrapper.getFileName());
            return deviationInstanceWrapper;
        }
        catch (InvalidFileTypeException invalidFileTypeException) {
            throw new ProgramBugException(invalidFileTypeException.toString());
        }
    }

    public DeviationDataSet createDeviationDataSet() {
        return new DeviationDataSet(this);
    }

    public NoteDeviation getNoteDeviation(MusicXMLWrapper.Note note) {
        if (this.noteDevMap.containsKey(note)) {
            return this.noteDevMap.get(note);
        }
        Node node = linkmanager.getNodeLinkedTo(note.node(), "note-deviation");
        if (node != null) {
            NoteDeviation noteDeviation = new NoteDeviation(node);
            this.noteDevMap.put(note, noteDeviation);
            return noteDeviation;
        }
        return null;
    }

    public ChordDeviation getChordDeviation(MusicXMLWrapper.Note note) {
        if (this.chordDevMap.containsKey(note)) {
            return this.chordDevMap.get(note);
        }
        Node node = linkmanager.getNodeLinkedTo(note.topNoteOfChord().node(), "chord-deviation");
        if (node != null) {
            ChordDeviation chordDeviation = new ChordDeviation(node);
            this.chordDevMap.put(note, chordDeviation);
            return chordDeviation;
        }
        return null;
    }

    public MissNote getMissNote(MusicXMLWrapper.Note note) {
        if (this.missNoteMap.containsKey(note)) {
            return this.missNoteMap.get(note);
        }
        Node node = linkmanager.getNodeLinkedTo(note.node(), "miss-note");
        if (node != null) {
            MissNote missNote = new MissNote(node);
            this.missNoteMap.put(note, missNote);
            return missNote;
        }
        return null;
    }

    public Control searchNonPartwiseControl(int n, double d) {
        return this.getTimewiseControlView().search(n, d);
    }

    public Control searchNonPartwiseControl(int n, double d, String string) {
        return this.getTimewiseControlView().search(n, d, string);
    }

    @Override
    protected void analyze() throws IOException {
        try {
            this.addLinks("//note-deviation", this.getTargetMusicXML());
            this.addLinks("//chord-deviation", this.getTargetMusicXML());
            this.addLinks("//miss-note", this.getTargetMusicXML());
        }
        catch (TransformerException transformerException) {
            throw new XMLException(transformerException);
        }
        this.alreadyAnalyzed = true;
    }

    private void analyzeControls() {
        this.tctrlview = new TimewiseControlView();
        NodeList nodeList = this.selectNodeList("/deviation/non-partwise/measure");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            int n2 = NodeInterface.getAttributeInt(node, "number");
            NodeList nodeList2 = this.selectNodeList(node, "control");
            int n3 = nodeList2.getLength();
            for (int j = 0; j < n3; ++j) {
                Control control = new Control(nodeList2.item(j), n2);
                this.tctrlview.addControl(control);
            }
        }
    }

    private void analyzePartwiseControls(String string) {
        TimewiseControlView timewiseControlView = new TimewiseControlView();
        NodeList nodeList = this.selectNodeList("/deviation/partwise/part[@id='" + string + "']/measure");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            int n2 = NodeInterface.getAttributeInt(node, "number");
            NodeList nodeList2 = this.selectNodeList(node, "control");
            int n3 = nodeList2.getLength();
            for (int j = 0; j < n3; ++j) {
                Control control = new Control(nodeList2.item(j), n2);
                timewiseControlView.addControl(control);
            }
        }
        this.pctrlviews.put(string, timewiseControlView);
    }

    private void analyzeExtraNotes(String string) {
        TreeView<ExtraNote> treeView = new TreeView<ExtraNote>();
        NodeList nodeList = this.selectNodeList("/deviation/extra-notes/part[@id='" + string + "']/measure");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            int n2 = NodeInterface.getAttributeInt(node, "number");
            NodeList nodeList2 = this.selectNodeList(node, "extra-note");
            int n3 = nodeList2.getLength();
            for (int j = 0; j < n3; ++j) {
                ExtraNote extraNote = new ExtraNote(nodeList2.item(j), n2);
                treeView.add(extraNote, "");
            }
        }
        this.extraNotes.put(string, treeView);
    }

    private boolean requiresTempoDevReturn(Control control, Control control2, int n) throws IOException {
        int n2;
        int n3 = this.getTicks(control.measure(), Math.floor(control.beat() + 1.0), n);
        return n3 < (n2 = this.getTicks(control2.measure(), control2.beat(), n));
    }

    private int getTicks(int n, double d, int n2) throws IOException {
        return this.getTargetMusicXML().getCumulativeTicks(n, n2) + (int)(d * (double)n2);
    }

    private void controlToSCCHeader(Control control, SCCXMLWrapper sCCXMLWrapper, int n) throws IOException {
        if (control != null) {
            if (control.type().equals("tempo")) {
                this.currentTempo = control.value();
                Control control2 = this.tctrlview.lookAhead("tempo-deviation");
                if (control2 == null || control.measure() != control2.measure() || control.beat() != control2.beat()) {
                    sCCXMLWrapper.addHeaderElement(control.timestamp(n), "TEMPO", this.currentTempo);
                    this.lastTempo = this.currentTempo;
                }
            } else if (control.type().equals("tempo-deviation")) {
                int n2 = control.timestamp(n);
                double d = this.currentTempo * control.value();
                String string = null;
                if (control.containsAttributeInChild("curve")) {
                    string = control.getChildAttribute("curve");
                }
                if (string != null && string.equals("linear")) {
                    int n3 = n / 8;
                    double d2 = (d - this.lastTempo) / 8.0;
                    for (int i = 7; i >= 1; --i) {
                        sCCXMLWrapper.addHeaderElement(n2 - n3 * i, "TEMPO", d - d2 * (double)i);
                    }
                }
                sCCXMLWrapper.addHeaderElement(n2, "TEMPO", d);
                this.lastTempo = this.currentTempo * control.value();
                Control control3 = this.tctrlview.lookAhead(new String[]{"tempo", "tempo-deviation"});
                if (control3 == null || this.requiresTempoDevReturn(control, control3, n)) {
                    int n4 = this.getTargetMusicXML().getCumulativeTicks(control.measure(), n);
                    int n5 = this.initticks + n4 + n * (int)Math.floor(control.beat());
                    sCCXMLWrapper.addHeaderElement(n5, "TEMPO", this.currentTempo);
                    this.lastTempo = this.currentTempo;
                }
            }
        }
    }

    private void nonPartwiseControlsToSCCHeader(SCCXMLWrapper sCCXMLWrapper, int n) throws IOException {
        TimewiseControlView timewiseControlView = this.getTimewiseControlView();
        sCCXMLWrapper.beginHeader();
        if (this.initticks > 0) {
            sCCXMLWrapper.addHeaderElement(0, "TEMPO", 120);
        }
        this.controlToSCCHeader((Control)timewiseControlView.getRoot(), sCCXMLWrapper, n);
        while (timewiseControlView.hasElementsAtNextTime()) {
            this.controlToSCCHeader((Control)timewiseControlView.getFirstElementAtNextTime(), sCCXMLWrapper, n);
            while (timewiseControlView.hasMoreElementsAtSameTime()) {
                this.controlToSCCHeader((Control)timewiseControlView.getNextElementAtSameTime(), sCCXMLWrapper, n);
            }
        }
        sCCXMLWrapper.endHeader();
    }

    private void processPartwiseForSCC(String string, int n, Map<String, NoteListForSCC> map) throws IOException {
        TreeView<Control> treeView = this.getPartwiseControlView(string);
        NoteListForSCC noteListForSCC = map.get(string);
        this.processControlForSCCNoteList(treeView.getRoot(), n, noteListForSCC);
        while (treeView.hasElementsAtNextTime()) {
            this.processControlForSCCNoteList(treeView.getFirstElementAtNextTime(), n, noteListForSCC);
            while (treeView.hasMoreElementsAtSameTime()) {
                this.processControlForSCCNoteList(treeView.getNextElementAtSameTime(), n, noteListForSCC);
            }
        }
    }

    private void processExtraNotesForSCC(String string, int n, Map<String, NoteListForSCC> map) throws IOException {
        TreeView<ExtraNote> treeView = this.getExtraNoteView(string);
        NoteListForSCC noteListForSCC = map.get(string);
        this.processExtraNoteForSCCNoteList(treeView.getRoot(), n, noteListForSCC);
        while (treeView.hasElementsAtNextTime()) {
            this.processExtraNoteForSCCNoteList(treeView.getFirstElementAtNextTime(), n, noteListForSCC);
            while (treeView.hasMoreElementsAtSameTime()) {
                this.processExtraNoteForSCCNoteList(treeView.getNextElementAtSameTime(), n, noteListForSCC);
            }
        }
    }

    private void processExtraNoteForSCCNoteList(ExtraNote extraNote, int n, NoteListForSCC noteListForSCC) throws IOException {
        if (extraNote != null) {
            int n2 = extraNote.timestamp(n);
            int n3 = n2 + (int)(extraNote.duration() * (double)n);
            int n4 = (int)((double)this.baseVelocity * extraNote.dynamics());
            int n5 = (int)((double)this.baseVelocity * extraNote.endDynamics());
            noteListForSCC.list.add(new MyNote(n2, n3, extraNote.notenum(), n4, n5, extraNote.dynamics(), extraNote.endDynamics(), extraNote.dynamicsType(), n, null));
        }
    }

    private void processControlForSCCNoteList(Control control, int n, NoteListForSCC noteListForSCC) throws IOException {
        if (control != null) {
            if (control.type().equals("pedal")) {
                int n2;
                String string = control.getChildAttribute("action");
                if (string.equals("on") || string.equals("continue")) {
                    n2 = control.containsAttributeInChild("depth") ? (int)(127.0 * control.getChildAttributeDouble("depth")) : 127;
                } else if (string.equals("off")) {
                    n2 = 0;
                } else {
                    throw new InvalidElementException();
                }
                noteListForSCC.list.add(new MutableControlChange(control.timestamp(n), 64, n2, n));
            } else if (control.type().equals("base-dynamics")) {
                noteListForSCC.list.add(new BaseDynamicsEvent(control.timestamp(n), n, control.value()));
            }
        }
    }

    private void processNotewiseForSCC(final int n, final Map<String, NoteListForSCC> map) throws IOException {
        this.getTargetMusicXML().processNotePartwise(new NoteHandlerPartwise(){
            private int currentPart = 0;
            private NoteListForSCC notelist;

            @Override
            public void beginPart(MusicXMLWrapper.Part part, MusicXMLWrapper musicXMLWrapper) {
                ++this.currentPart;
                this.notelist = new NoteListForSCC(this.currentPart, this.currentPart);
            }

            @Override
            public void endPart(MusicXMLWrapper.Part part, MusicXMLWrapper musicXMLWrapper) {
                map.put(part.id(), this.notelist);
            }

            @Override
            public void beginMeasure(MusicXMLWrapper.Measure measure, MusicXMLWrapper musicXMLWrapper) {
            }

            @Override
            public void endMeasure(MusicXMLWrapper.Measure measure, MusicXMLWrapper musicXMLWrapper) {
            }

            @Override
            public void processMusicData(MusicXMLWrapper.MusicData musicData, MusicXMLWrapper musicXMLWrapper) {
                if (musicData instanceof MusicXMLWrapper.Note) {
                    NoteDeviationInterface noteDeviationInterface;
                    MusicXMLWrapper.Note note = (MusicXMLWrapper.Note)musicData;
                    NoteDeviationInterface noteDeviationInterface2 = DeviationInstanceWrapper.this.getChordDeviation(note);
                    if (noteDeviationInterface2 == null) {
                        noteDeviationInterface2 = DeviationInstanceWrapper.getDefaultNoteDeviation();
                    }
                    if ((noteDeviationInterface = DeviationInstanceWrapper.this.getNoteDeviation(note)) == null) {
                        noteDeviationInterface = DeviationInstanceWrapper.getDefaultNoteDeviation();
                    }
                    int n7 = (int)((double)n * (noteDeviationInterface2.attack() + noteDeviationInterface.attack()));
                    int n2 = (int)((double)n * (noteDeviationInterface2.release() + noteDeviationInterface.release()));
                    int n3 = (int)((double)DeviationInstanceWrapper.this.baseVelocity * noteDeviationInterface2.dynamics() * noteDeviationInterface.dynamics());
                    int n4 = (int)((double)DeviationInstanceWrapper.this.baseVelocity * noteDeviationInterface2.endDynamics() * noteDeviationInterface.endDynamics());
                    if (!(note.rest() || DeviationInstanceWrapper.this.getMissNote(note) != null || "none".equals(note.notehead()) || note.containsTieType("stop"))) {
                        int n5 = DeviationInstanceWrapper.this.initticks + note.onset(n);
                        int n6 = DeviationInstanceWrapper.this.initticks + note.offset(n);
                        this.notelist.list.add(new MyNote(n5 + n7, n6 + n2, note.notenum(), n3, n4, noteDeviationInterface2.dynamics() * noteDeviationInterface.dynamics(), noteDeviationInterface2.endDynamics() * noteDeviationInterface.endDynamics(), noteDeviationInterface.dynamicsType(), n, note));
                    }
                }
            }
        });
    }

    private void addNoteListToSCC(SCCXMLWrapper sCCXMLWrapper, Map<String, NoteListForSCC> map) {
        TreeSet<NoteListForSCC> treeSet = new TreeSet<NoteListForSCC>(new Comparator<NoteListForSCC>(){

            @Override
            public int compare(NoteListForSCC noteListForSCC, NoteListForSCC noteListForSCC2) {
                return noteListForSCC.serial - noteListForSCC2.serial;
            }
        });
        treeSet.addAll(map.values());
        for (NoteListForSCC noteListForSCC : treeSet) {
            sCCXMLWrapper.newPart(noteListForSCC.serial, noteListForSCC.ch, noteListForSCC.pn, noteListForSCC.vol);
            Collections.sort(noteListForSCC.list);
            double d = 1.0;
            for (MutableMusicEvent mutableMusicEvent : noteListForSCC.list) {
                if (mutableMusicEvent instanceof MyNote) {
                    int n;
                    int n2;
                    MyNote myNote = (MyNote)mutableMusicEvent;
                    if (myNote.dynamicsType.equals("diff")) {
                        n2 = (int)((double)this.baseVelocity * (d - myNote.dynamics));
                        n = (int)((double)this.baseVelocity * (d - myNote.offDynamics));
                    } else {
                        if (!myNote.dynamicsType.equals("rate")) {
                            System.err.println("warning: unsupport type " + myNote.dynamicsType + ". use as 'rate' type.");
                        }
                        n2 = (int)((double)this.baseVelocity * d * myNote.dynamics);
                        n = (int)((double)this.baseVelocity * d * myNote.offDynamics);
                    }
                    sCCXMLWrapper.addNoteElement(myNote.onset(), myNote.offset(), myNote.notenum(), n2, n, myNote.note);
                    continue;
                }
                if (mutableMusicEvent instanceof MutableControlChange) {
                    sCCXMLWrapper.addControlChange(mutableMusicEvent.onset(), mutableMusicEvent.offset(), ((MutableControlChange)mutableMusicEvent).ctrlnum(), ((MutableControlChange)mutableMusicEvent).value());
                    continue;
                }
                if (!(mutableMusicEvent instanceof BaseDynamicsEvent)) continue;
                d = ((BaseDynamicsEvent)mutableMusicEvent).getValue();
            }
            sCCXMLWrapper.endPart();
        }
    }

    private void addBarlinesToSCC(SCCXMLWrapper sCCXMLWrapper, MusicXMLWrapper musicXMLWrapper, int n) {
        MusicXMLWrapper.Measure[] measureArray = musicXMLWrapper.getPartList()[0].getMeasureList();
        sCCXMLWrapper.beginAnnotations();
        for (MusicXMLWrapper.Measure measure : measureArray) {
            sCCXMLWrapper.addBarline(measure.cumulativeTicks(n), "");
        }
        MusicXMLWrapper.Measure measure = measureArray[measureArray.length - 1];
        sCCXMLWrapper.addBarline(measure.cumulativeTicks(n) + measure.duration(n), "");
        sCCXMLWrapper.endAnnotations();
    }

    public void toSCCXML(SCCXMLWrapper sCCXMLWrapper, int n) throws IOException {
        MusicXMLWrapper musicXMLWrapper = this.getTargetMusicXML();
        if (!this.alreadyAnalyzed) {
            this.analyze();
        }
        double d = this.getInitialSilence();
        this.initticks = (int)Math.round(d * (double)n * 2.0);
        sCCXMLWrapper.setDivision(n);
        this.nonPartwiseControlsToSCCHeader(sCCXMLWrapper, n);
        HashMap<String, NoteListForSCC> hashMap = new HashMap<String, NoteListForSCC>();
        this.processNotewiseForSCC(n, hashMap);
        Set set = hashMap.keySet();
        for (String string : set) {
            this.processExtraNotesForSCC(string, n, hashMap);
            this.processPartwiseForSCC(string, n, hashMap);
        }
        this.addNoteListToSCC(sCCXMLWrapper, hashMap);
        this.addBarlinesToSCC(sCCXMLWrapper, musicXMLWrapper, n);
        sCCXMLWrapper.finalizeDocument();
    }

    public SCCXMLWrapper toSCCXML(int n) throws TransformerException, IOException, ParserConfigurationException, SAXException {
        SCCXMLWrapper sCCXMLWrapper = (SCCXMLWrapper)CMXFileWrapper.createDocument("scc");
        this.toSCCXML(sCCXMLWrapper, n);
        return sCCXMLWrapper;
    }

    public CSVWrapper toCSV(int n, int n2) {
        CSVWrapper cSVWrapper = new CSVWrapper();
        cSVWrapper.addRow();
        cSVWrapper.addValue(0, "tempo");
        cSVWrapper.addValue(0, "velocity");
        cSVWrapper.addValue(0, "velocitySD");
        cSVWrapper.addValue(0, "attackSD");
        cSVWrapper.addValue(0, "releaseSD");
        try {
            int n3;
            int n4 = 480;
            SCCXMLWrapper sCCXMLWrapper = this.toSCCXML(n4);
            TimeFreqRepresentation timeFreqRepresentation = TimeFreqRepresentation.getTimeFreqRepresentation(sCCXMLWrapper, n4, n, this.getTargetMusicXML());
            double[] dArray = new double[timeFreqRepresentation.length()];
            SCCXMLWrapper.HeaderElement[] headerElementArray = sCCXMLWrapper.getHeaderElementList();
            for (n3 = 0; n3 < headerElementArray.length; ++n3) {
                if (!headerElementArray[n3].name().equals("TEMPO")) continue;
                int n5 = headerElementArray[n3].time() * n / 4 / n4;
                int n6 = n3 < headerElementArray.length - 1 ? headerElementArray[n3 + 1].time() * n / 4 / n4 : dArray.length - 1;
                n5 = Math.min(n5, dArray.length - 1);
                n6 = Math.min(n6, dArray.length - 1);
                for (int i = n5; i <= n6; ++i) {
                    dArray[i] = Double.parseDouble(headerElementArray[n3].content());
                }
            }
            for (n3 = 0; n3 < timeFreqRepresentation.length(); ++n3) {
                cSVWrapper.addRow();
                cSVWrapper.addValue(n3 + 1, dArray[n3] + "");
                double d = 0.0;
                LinkedList<NoteDeviation> linkedList = new LinkedList<NoteDeviation>();
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                for (int i = n3; i < n3 + n / n2 && i < timeFreqRepresentation.length(); ++i) {
                    for (byte by : timeFreqRepresentation.get(i).values()) {
                        if (by <= 0) continue;
                        d += Math.exp(by);
                    }
                    for (NoteCompatible noteCompatible : timeFreqRepresentation.get(i).data()) {
                        try {
                            NoteDeviation nullPointerException = this.getNoteDeviation(((SCCXMLWrapper.Note)noteCompatible).getMusicXMLWrapperNote());
                            d2 += nullPointerException.dynamics();
                            d3 += nullPointerException.attack();
                            d4 += nullPointerException.release();
                            linkedList.add(nullPointerException);
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                    }
                }
                d2 /= (double)linkedList.size();
                d3 /= (double)linkedList.size();
                d4 /= (double)linkedList.size();
                if (d > 0.0) {
                    d = Math.log(d);
                }
                cSVWrapper.addValue(n3 + 1, d + "");
                double d5 = 0.0;
                double d6 = 0.0;
                double by = 0.0;
                if (linkedList.size() > 0) {
                    for (NoteDeviation noteDeviation : linkedList) {
                        d5 += Math.pow((noteDeviation.dynamics() - d2) * (double)this.baseVelocity, 2.0);
                        d6 += Math.pow(noteDeviation.attack() - d3, 2.0);
                        by += Math.pow(noteDeviation.release() - d4, 2.0);
                    }
                    d5 /= (double)linkedList.size();
                    d6 /= (double)linkedList.size();
                    by /= (double)linkedList.size();
                } else {
                    by = Double.NaN;
                    d6 = Double.NaN;
                    d5 = Double.NaN;
                }
                cSVWrapper.addValue(n3 + 1, d5 + "");
                cSVWrapper.addValue(n3 + 1, d6 + "");
                cSVWrapper.addValue(n3 + 1, by + "");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return cSVWrapper;
    }

    public DeviationDataSet toDeviationDataSet() throws IOException {
        TreeView treeView;
        String string;
        MusicXMLWrapper musicXMLWrapper = this.getTargetMusicXML();
        final DeviationDataSet deviationDataSet = new DeviationDataSet(musicXMLWrapper);
        deviationDataSet.setInitialSilence(this.getInitialSilence());
        if (this.tctrlview != null) {
            this.addNonPartwise((Control)this.tctrlview.getRoot(), deviationDataSet);
            while (this.tctrlview.hasMoreElementsAtSameTime()) {
                this.addNonPartwise((Control)this.tctrlview.getNextElementAtSameTime(), deviationDataSet);
            }
            while (this.tctrlview.hasElementsAtNextTime()) {
                this.addNonPartwise((Control)this.tctrlview.getFirstElementAtNextTime(), deviationDataSet);
                while (this.tctrlview.hasMoreElementsAtSameTime()) {
                    this.addNonPartwise((Control)this.tctrlview.getNextElementAtSameTime(), deviationDataSet);
                }
            }
        }
        for (Map.Entry<String, TimewiseControlView> entry : this.pctrlviews.entrySet()) {
            string = entry.getKey();
            treeView = entry.getValue();
            this.addPartwise((Control)treeView.getRoot(), string, deviationDataSet);
            while (treeView.hasMoreElementsAtSameTime()) {
                this.addPartwise((Control)treeView.getNextElementAtSameTime(), string, deviationDataSet);
            }
            while (treeView.hasElementsAtNextTime()) {
                this.addPartwise((Control)treeView.getFirstElementAtNextTime(), string, deviationDataSet);
                while (treeView.hasMoreElementsAtSameTime()) {
                    this.addPartwise((Control)treeView.getNextElementAtSameTime(), string, deviationDataSet);
                }
            }
        }
        musicXMLWrapper.processNotePartwise(new NoteHandlerAdapterPartwise(){

            @Override
            public void processMusicData(MusicXMLWrapper.MusicData musicData, MusicXMLWrapper musicXMLWrapper) {
                if (musicData instanceof MusicXMLWrapper.Note) {
                    MusicXMLWrapper.Note note = (MusicXMLWrapper.Note)musicData;
                    DeviationInstanceWrapper.this.addNoteDeviation(note, DeviationInstanceWrapper.this.getNoteDeviation(note), deviationDataSet);
                    DeviationInstanceWrapper.this.addChordDeviation(note, DeviationInstanceWrapper.this.getChordDeviation(note), deviationDataSet);
                    DeviationInstanceWrapper.this.addMissNote(note, DeviationInstanceWrapper.this.getMissNote(note), deviationDataSet);
                }
            }
        });
        for (Map.Entry<String, TreeView> entry : this.extraNotes.entrySet()) {
            string = entry.getKey();
            treeView = entry.getValue();
            this.addExtraNote((ExtraNote)treeView.getRoot(), string, deviationDataSet);
            while (treeView.hasMoreElementsAtSameTime()) {
                this.addExtraNote((ExtraNote)treeView.getNextElementAtSameTime(), string, deviationDataSet);
            }
            while (treeView.hasElementsAtNextTime()) {
                this.addExtraNote((ExtraNote)treeView.getFirstElementAtNextTime(), string, deviationDataSet);
                while (treeView.hasMoreElementsAtSameTime()) {
                    this.addExtraNote((ExtraNote)treeView.getNextElementAtSameTime(), string, deviationDataSet);
                }
            }
        }
        return deviationDataSet;
    }

    private void addNonPartwise(Control control, DeviationDataSet deviationDataSet) {
        deviationDataSet.addNonPartwiseControl(control.measure(), control.beat(), control.type(), control.value());
    }

    private void addPartwise(Control control, String string, DeviationDataSet deviationDataSet) {
        deviationDataSet.addPartwiseControl(string, control.measure(), control.beat(), control.type(), control.value());
    }

    private void addNoteDeviation(MusicXMLWrapper.Note note, NoteDeviation noteDeviation, DeviationDataSet deviationDataSet) {
        if (noteDeviation != null) {
            deviationDataSet.addNoteDeviation(note, noteDeviation.attack(), noteDeviation.release(), noteDeviation.dynamics(), noteDeviation.endDynamics());
        }
    }

    private void addChordDeviation(MusicXMLWrapper.Note note, ChordDeviation chordDeviation, DeviationDataSet deviationDataSet) {
        if (chordDeviation != null) {
            deviationDataSet.addChordDeviation(note, chordDeviation.attack(), chordDeviation.release(), chordDeviation.dynamics(), chordDeviation.endDynamics());
        }
    }

    private void addMissNote(MusicXMLWrapper.Note note, MissNote missNote, DeviationDataSet deviationDataSet) {
        if (missNote != null) {
            deviationDataSet.addMissNote(note);
        }
    }

    private void addExtraNote(ExtraNote extraNote, String string, DeviationDataSet deviationDataSet) {
        deviationDataSet.addExtraNote(string, extraNote.measure(), extraNote.beat(), extraNote.pitchStep(), extraNote.pitchAlter(), extraNote.pitchOctave(), extraNote.duration(), extraNote.dynamics(), extraNote.endDynamics());
    }

    public TreeView<Control> getNonPartwiseControlView() {
        return this.getTimewiseControlView();
    }

    public LinkedList<Control> getNonPartwiseList(DeviationInstanceWrapper deviationInstanceWrapper) {
        LinkedList<Control> linkedList = new LinkedList<Control>();
        TimewiseControlView timewiseControlView = deviationInstanceWrapper.getTimewiseControlView();
        timewiseControlView.getRoot();
        while (timewiseControlView.hasElementsAtNextTime()) {
            linkedList.add((Control)timewiseControlView.getFirstElementAtNextTime());
            while (timewiseControlView.hasMoreElementsAtSameTime()) {
                linkedList.add((Control)timewiseControlView.getNextElementAtSameTime());
            }
        }
        return linkedList;
    }

    public LinkedList<ExtraNote> getExtraNotesList(DeviationInstanceWrapper deviationInstanceWrapper, String string) {
        LinkedList<ExtraNote> linkedList = new LinkedList<ExtraNote>();
        TreeView<ExtraNote> treeView = deviationInstanceWrapper.getExtraNoteView(string);
        treeView.getRoot();
        while (treeView.hasElementsAtNextTime()) {
            linkedList.add(treeView.getFirstElementAtNextTime());
            while (treeView.hasMoreElementsAtSameTime()) {
                linkedList.add(treeView.getNextElementAtSameTime());
            }
        }
        return linkedList;
    }

    private TimewiseControlView getTimewiseControlView() {
        if (this.tctrlview == null) {
            this.analyzeControls();
        }
        return this.tctrlview;
    }

    public TreeView<Control> getPartwiseControlView(String string) {
        if (!this.pctrlviews.containsKey(string)) {
            this.analyzePartwiseControls(string);
        }
        return this.pctrlviews.get(string);
    }

    public TreeView<ExtraNote> getExtraNoteView(String string) {
        if (!this.extraNotes.containsKey(string)) {
            this.analyzeExtraNotes(string);
        }
        return this.extraNotes.get(string);
    }

    private static NoteDeviationInterface getDefaultNoteDeviation() {
        return defaultND;
    }

    public class MissNote
    extends NodeInterface {
        private MissNote(Node node) {
            super(node);
        }

        @Override
        protected String getSupportedNodeName() {
            return "miss-note";
        }
    }

    public class ChordDeviation
    extends NoteDeviation {
        private ChordDeviation(Node node) {
            super(node);
        }

        @Override
        protected String getSupportedNodeName() {
            return "chord-deviation";
        }
    }

    public class NoteDeviation
    extends NodeInterface
    implements NoteDeviationInterface {
        private double attack;
        private double release;
        private double dynamics;
        private double endDynamics;
        private String dynamicsType;
        private NodeList note;

        private NoteDeviation(Node node) {
            super(node);
            this.note = null;
            this.attack = NoteDeviation.getTextDouble(this.getChildByTagName("attack"));
            this.release = NoteDeviation.getTextDouble(this.getChildByTagName("release"));
            Node node2 = this.getChildByTagName("dynamics");
            this.dynamics = NoteDeviation.getTextDouble(node2);
            this.endDynamics = NoteDeviation.getTextDouble(this.getChildByTagName("end-dynamics"));
            Node node3 = node2.getAttributes().getNamedItem("type");
            if (node3 == null) {
                this.dynamicsType = "rate";
            } else if (node3.getNodeValue().equals("rate")) {
                this.dynamicsType = "rate";
            } else if (node3.getNodeValue().equals("diff")) {
                this.dynamicsType = "diff";
            } else {
                this.dynamicsType = "rate";
                System.err.println("warning: unsupported type");
            }
        }

        @Override
        protected String getSupportedNodeName() {
            return "note-deviation";
        }

        @Override
        public final double attack() {
            return this.attack;
        }

        @Override
        public final double release() {
            return this.release;
        }

        @Override
        public final double dynamics() {
            return this.dynamics;
        }

        @Override
        public final double endDynamics() {
            return this.endDynamics;
        }

        @Override
        public final String dynamicsType() {
            return this.dynamicsType;
        }
    }

    private static class DefaultNoteDeviation
    implements NoteDeviationInterface {
        private DefaultNoteDeviation() {
        }

        @Override
        public final double attack() {
            return 0.0;
        }

        @Override
        public final double release() {
            return 0.0;
        }

        @Override
        public final double dynamics() {
            return 1.0;
        }

        @Override
        public final double endDynamics() {
            return 1.0;
        }

        @Override
        public String dynamicsType() {
            return "rate";
        }
    }

    private static interface NoteDeviationInterface {
        public double attack();

        public double release();

        public double dynamics();

        public double endDynamics();

        public String dynamicsType();
    }

    public class ExtraNote
    extends NodeInterface
    implements Ordered {
        private int measure;
        private double beat;
        private String pitchStep;
        private int pitchAlter;
        private int pitchOctave;
        private int notenum;
        private double duration;
        private double dynamics;
        private String dynamicsType;
        private double endDynamics;

        private ExtraNote(Node node, int n) {
            super(node);
            this.notenum = -1;
            this.dynamicsType = null;
            this.measure = n;
            this.beat = ExtraNote.getAttributeDouble(this.node(), "beat");
            NodeList nodeList = this.getChildNodes();
            int n2 = nodeList.getLength();
            for (int i = 0; i < n2; ++i) {
                Node node2 = nodeList.item(i);
                String string = node2.getNodeName();
                String string2 = ExtraNote.getText(node2);
                if (string.equals("pitch")) {
                    this.analyzePitch(node2);
                    continue;
                }
                if (string.equals("duration")) {
                    this.duration = Double.parseDouble(string2);
                    continue;
                }
                if (string.equals("dynamics")) {
                    this.dynamics = Double.parseDouble(string2);
                    Node node3 = node2.getAttributes().getNamedItem("type");
                    if (node3 == null) {
                        this.dynamicsType = "rate";
                        continue;
                    }
                    if (node3.getNodeValue().equals("rate")) {
                        this.dynamicsType = "rate";
                        continue;
                    }
                    if (node3.getNodeValue().equals("diff")) {
                        this.dynamicsType = "diff";
                        continue;
                    }
                    this.dynamicsType = "rate";
                    System.err.println("warning: unsupported type");
                    continue;
                }
                if (!string.equals("end-dynamics")) continue;
                this.endDynamics = Double.parseDouble(string2);
            }
        }

        private void analyzePitch(Node node) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                String string = node2.getNodeName();
                String string2 = ExtraNote.getText(node2);
                if (string.equals("step")) {
                    this.pitchStep = string2;
                    continue;
                }
                if (string.equals("octave")) {
                    this.pitchOctave = Integer.parseInt(string2);
                    continue;
                }
                if (!string.equals("alter")) continue;
                this.pitchAlter = Integer.parseInt(string2);
            }
        }

        @Override
        protected final String getSupportedNodeName() {
            return "extra-note";
        }

        public String dynamicsType() {
            return this.dynamicsType;
        }

        public final int measure() {
            return this.measure;
        }

        public final double beat() {
            return this.beat;
        }

        public final String pitchStep() {
            return this.pitchStep;
        }

        public final int pitchAlter() {
            return this.pitchAlter;
        }

        public final int pitchOctave() {
            return this.pitchOctave;
        }

        public int notenum() {
            if (this.notenum < 0) {
                int n;
                if (this.pitchStep.equalsIgnoreCase("C")) {
                    n = 0;
                } else if (this.pitchStep.equalsIgnoreCase("D")) {
                    n = 2;
                } else if (this.pitchStep.equalsIgnoreCase("E")) {
                    n = 4;
                } else if (this.pitchStep.equalsIgnoreCase("F")) {
                    n = 5;
                } else if (this.pitchStep.equalsIgnoreCase("G")) {
                    n = 7;
                } else if (this.pitchStep.equalsIgnoreCase("A")) {
                    n = 9;
                } else if (this.pitchStep.equalsIgnoreCase("B")) {
                    n = 11;
                } else {
                    throw new InvalidElementException("Pitch is wrong.");
                }
                this.notenum = n + (this.pitchOctave + 1) * 12 + this.pitchAlter;
            }
            return this.notenum;
        }

        public final double duration() {
            return this.duration;
        }

        public final double dynamics() {
            return this.dynamics;
        }

        public final double endDynamics() {
            return this.endDynamics;
        }

        @Override
        public final int ordinal() {
            return this.measure;
        }

        @Override
        public final int subordinal() {
            return (int)(1920.0 * this.beat);
        }

        public final int timestamp(int n) throws IOException {
            if (this.measure < 0) {
                return (int)Math.round((double)n * (this.beat - 1.0));
            }
            return DeviationInstanceWrapper.this.initticks + DeviationInstanceWrapper.this.getTargetMusicXML().getCumulativeTicks(this.measure, n) + (int)Math.round((double)n * (this.beat - 1.0));
        }
    }

    public class Control
    extends NodeInterface
    implements Ordered {
        private int measure;
        private double beat;
        private Node child;

        private Control(Node node, int n) {
            super(node);
            this.measure = n;
            this.beat = Control.getAttributeDouble(this.node(), "beat");
            this.child = this.node().getFirstChild();
        }

        @Override
        protected final String getSupportedNodeName() {
            return "control";
        }

        public final int measure() {
            return this.measure;
        }

        public final double beat() {
            return this.beat;
        }

        public final String type() {
            return this.child.getNodeName();
        }

        public final double value() {
            return Control.getTextDouble(this.child);
        }

        @Override
        public final int ordinal() {
            return this.measure;
        }

        @Override
        public final int subordinal() {
            return (int)(1920.0 * this.beat);
        }

        public final String toString() {
            return "Control (measure: " + this.measure + ", beat: " + this.beat + ", type: " + this.type() + (this.child.hasChildNodes() ? ", value: " + this.value() : "") + ")";
        }

        public final int timestamp(int n) throws IOException {
            return DeviationInstanceWrapper.this.initticks + DeviationInstanceWrapper.this.getTargetMusicXML().getCumulativeTicks(this.measure, n) + (int)Math.round((double)n * (this.beat - 1.0));
        }

        public final String getChildAttribute(String string) {
            return Control.getAttribute(this.child, string);
        }

        public final int getChildAttributeInt(String string) {
            return Control.getAttributeInt(this.child, string);
        }

        public final double getChildAttributeDouble(String string) {
            return Control.getAttributeDouble(this.child, string);
        }

        public final boolean containsAttributeInChild(String string) {
            return Control.hasAttribute(this.child, string);
        }
    }

    private class TimewiseControlView
    extends TreeView<Control> {
        private TimewiseControlView() {
        }

        private void addControl(Control control) {
            this.add(control, "");
        }

        private Control lookAhead(final String string) {
            return this.lookAhead(new NodeSearchFilter<Control>(){

                @Override
                public boolean accept(Control control) {
                    return control != null && control.type().equals(string);
                }
            });
        }

        private Control lookAhead(final String ... stringArray) {
            return this.lookAhead(new NodeSearchFilter<Control>(){

                @Override
                public boolean accept(Control control) {
                    for (String string : stringArray) {
                        if (control == null || !control.type().equals(string)) continue;
                        return true;
                    }
                    return false;
                }
            });
        }

        private Control search(int n, double d) {
            return (Control)this.search(n, (int)(107520.0 * d));
        }

        private Control search(int n, double d, final String string) {
            return this.search(n, (int)(107520.0 * d), new NodeSearchFilter<Control>(){

                @Override
                public boolean accept(Control control) {
                    return control != null && control.type().equals(string);
                }
            });
        }
    }

    private class MyNote
    extends MutableNote {
        private MusicXMLWrapper.Note note;
        private double dynamics;
        private double offDynamics;
        private String dynamicsType;

        private MyNote(int n, int n2, int n3, int n4, int n5, double d, double d2, String string, int n6, MusicXMLWrapper.Note note) {
            super(n, n2, n3, n4, n5, n6);
            this.note = note;
            this.dynamics = d;
            this.offDynamics = d2;
            this.dynamicsType = string;
        }
    }

    private class NoteListForSCC {
        private int serial;
        private int ch;
        private int pn;
        private int vol;
        private static final int DEFAULT_PROG_NUM = 0;
        private static final int DEFAULT_VOLUME = 100;
        private List<MutableMusicEvent> list;

        private NoteListForSCC(int n, int n2, int n3, int n4) {
            this.serial = n;
            this.ch = n2;
            this.pn = n3;
            this.vol = n4;
            this.list = new ArrayList<MutableMusicEvent>();
        }

        private NoteListForSCC(int n, int n2) {
            this(n, n2, 0, 100);
        }
    }
}

