/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.inference;

import java.util.LinkedList;
import jp.crestmuse.cmx.inference.BayesNetCompatible;
import jp.crestmuse.cmx.inference.BayesianMapping;
import jp.crestmuse.cmx.inference.MusicLayerListener;
import jp.crestmuse.cmx.inference.MusicRepresentation2;

public class BayesianCalculator
implements MusicLayerListener {
    private BayesNetCompatible bayesNet;
    private LinkedList<BayesianMapping> readMappings;
    private LinkedList<BayesianMapping> writeMappings;

    public BayesianCalculator(BayesNetCompatible bayesNetCompatible) {
        this.bayesNet = bayesNetCompatible;
        this.readMappings = new LinkedList();
        this.writeMappings = new LinkedList();
    }

    @Override
    public void update(MusicRepresentation2 musicRepresentation2, MusicRepresentation2.MusicElement musicElement, int n, int n2) {
        try {
            double[] dArray;
            MusicRepresentation2.MusicElement musicElement2;
            System.err.println(n + ":" + n2 + "...");
            if (n == musicRepresentation2.getMeasureNum()) {
                return;
            }
            for (BayesianMapping bayesianMapping : this.readMappings) {
                musicElement2 = bayesianMapping.mappedElement(musicRepresentation2, n, n2);
                if (musicElement2 == null) continue;
                if (bayesianMapping.evidenceOnly || musicElement2.hasEvidence()) {
                    this.bayesNet.setEvidence(bayesianMapping.bayesnetIndex, musicElement2.getHighestProbIndex());
                    continue;
                }
                dArray = musicElement2.getAllProbs();
                double[][] dArrayArray = new double[][]{dArray};
                try {
                    this.bayesNet.setDistribution(bayesianMapping.bayesnetIndex, dArrayArray);
                }
                catch (Exception exception) {
                    throw new IllegalStateException(exception.toString());
                }
            }
            this.bayesNet.update();
            for (BayesianMapping bayesianMapping : this.writeMappings) {
                musicElement2 = bayesianMapping.mappedElement(musicRepresentation2, n, n2);
                if (musicElement2 == null) continue;
                dArray = this.bayesNet.getMargin(bayesianMapping.bayesnetIndex);
                for (int i = 0; i < dArray.length; ++i) {
                    musicElement2.removeEvidence(i);
                    musicElement2.setProb(i, dArray[i]);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addReadMapping(BayesianMapping bayesianMapping) {
        this.readMappings.add(bayesianMapping);
    }

    public void addWriteMapping(BayesianMapping bayesianMapping) {
        this.writeMappings.add(bayesianMapping);
    }
}

