/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.inference;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import jp.crestmuse.cmx.inference.MusicLayerListener;
import jp.crestmuse.cmx.sound.SequencerManager;

public class MusicRepresentation2 {
    private int measureNum;
    private int division;
    private HashMap<String, MusicLayer> name2layer;
    private boolean changeFlag;

    public MusicRepresentation2(int n, int n2) {
        this.measureNum = n;
        this.division = n2;
        this.name2layer = new HashMap();
    }

    public int getMeasureNum() {
        return this.measureNum;
    }

    public int getDivision() {
        return this.division;
    }

    MusicLayer getMusicLayer(String string) {
        return this.name2layer.get(string);
    }

    public void addMusicLayerBasic(String string, int n) {
        this.addMusicLayerBasic(string, n, 1);
    }

    public void addMusicLayerBasic(String string, int n, int n2) {
        Object[] objectArray = new String[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = i + "";
        }
        this.addMusicLayerBasic(string, objectArray, n2);
    }

    public void addMusicLayerBasic(String string, Object[] objectArray) {
        this.addMusicLayerBasic(string, objectArray, 1);
    }

    public void addMusicLayerBasic(String string, Object[] objectArray, int n) {
        MusicLayerBasic musicLayerBasic = new MusicLayerBasic(objectArray, n);
        this.name2layer.put(string, musicLayerBasic);
    }

    public void addMusicLayerMeasurewise(String string, int n) {
        this.name2layer.put(string, new MusicLayerMeasurewise(n));
    }

    public int getTiedLength(String string) {
        return this.getMusicLayer(string).getTiedLength();
    }

    public void addMusicLayerListener(String string, MusicLayerListener musicLayerListener) {
        this.getMusicLayer(string).addListener(musicLayerListener);
    }

    public void setUpdateChainLimit(String string, int n) {
        this.getMusicLayer(string).setUpdateChainLimit(n);
    }

    public MusicElement getMusicElement(String string, int n, int n2) {
        return this.getMusicLayer(string).getElement(n, n2);
    }

    public Object getLayerLabel(String string, int n) {
        return this.getMusicLayer(string).getLabel(n);
    }

    public boolean isMeasurewiseLayer(String string) {
        return this.getMusicLayer(string) instanceof MusicLayerMeasurewise;
    }

    public int getLayerMeasureWidth(String string) {
        return ((MusicLayerMeasurewise)this.getMusicLayer(string)).getMeasureWidth();
    }

    public boolean isChanged() {
        return this.changeFlag;
    }

    public void resetChangeFlag() {
        this.changeFlag = false;
    }

    @Deprecated
    public int getIndex(long l) {
        return this.getIndex(l, SequencerManager.TICKS_PER_BEAT);
    }

    @Deprecated
    public int getIndex(long l, int n) {
        int n2 = n * 4;
        int n3 = (int)(l / (long)n2);
        int n4 = (int)(l % (long)n2) / (n2 / this.division);
        return n3 * this.division + n4;
    }

    public class MusicElement {
        private ArrayList<ElementProbPair> pairs;
        private int evidenceIndex = -1;
        private boolean setflag = false;
        private MusicLayer parent;
        private int indexInMusRep;
        private double maxLL = Double.NEGATIVE_INFINITY;
        private int argmax = -1;
        private MusicElement backpoint = null;

        private MusicElement(MusicLayer musicLayer, int n) {
            if (musicLayer instanceof MusicLayerBasic) {
                MusicLayerBasic musicLayerBasic = (MusicLayerBasic)musicLayer;
                this.pairs = new ArrayList();
                for (int i = 0; i < musicLayerBasic.labels.length; ++i) {
                    this.pairs.add(new ElementProbPair(i, Double.NEGATIVE_INFINITY));
                }
            } else {
                MusicLayerMeasurewise musicLayerMeasurewise = (MusicLayerMeasurewise)musicLayer;
                this.pairs = new ArrayList();
                for (int i = 0; i < musicLayerMeasurewise.labels.size(); ++i) {
                    this.pairs.add(new ElementProbPair(i, Double.NEGATIVE_INFINITY));
                }
            }
            this.parent = musicLayer;
            this.indexInMusRep = n;
        }

        public double[] getAllProbs() {
            double[] dArray = new double[this.pairs.size()];
            for (int i = 0; i < this.pairs.size(); ++i) {
                dArray[i] = this.getProb(i);
            }
            return dArray;
        }

        public double getLogLikelihood(int n) {
            if (this.evidenceIndex != -1) {
                return this.evidenceIndex == n ? 0.0 : Double.NEGATIVE_INFINITY;
            }
            return this.pairs.get(n).loglik;
        }

        public double getProb(int n) {
            if (this.evidenceIndex != -1) {
                return this.evidenceIndex == n ? 1.0 : 0.0;
            }
            return Math.exp(this.pairs.get(n).loglik);
        }

        public int getHighestProbIndex() {
            if (this.evidenceIndex != -1) {
                return this.evidenceIndex;
            }
            return this.argmax;
        }

        public int getRankedProbIndex(int n) {
            ArrayList arrayList = (ArrayList)this.pairs.clone();
            Collections.sort(arrayList);
            return ((ElementProbPair)arrayList.get(n)).index;
        }

        public void getNBestIndices(int[] nArray) {
            ArrayList arrayList = (ArrayList)this.pairs.clone();
            Collections.sort(arrayList);
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = ((ElementProbPair)arrayList.get(i)).index;
            }
        }

        public int[] getNBestIndices(int n) {
            ArrayList arrayList = (ArrayList)this.pairs.clone();
            Collections.sort(arrayList);
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = ((ElementProbPair)arrayList.get(i)).index;
            }
            return nArray;
        }

        public int getProbLength() {
            return this.pairs.size();
        }

        public boolean set() {
            return this.setflag;
        }

        public boolean hasEvidence() {
            return this.evidenceIndex != -1;
        }

        public void setEvidence(int n) {
            this.evidenceIndex = n;
            this.parent.update(this);
        }

        public void removeEvidence(int n) {
            this.evidenceIndex = -1;
        }

        public void setLogLikelihood(int n, double d) {
            this.evidenceIndex = -1;
            this.pairs.get(n).loglik = d;
            if (d > this.maxLL) {
                this.maxLL = d;
                this.argmax = n;
            }
            this.setflag = true;
            this.parent.update(this);
        }

        public void setProb(int n, double d) {
            this.setLogLikelihood(n, Math.log(d));
        }

        public int addNewLabel(Object object) {
            if (this.parent instanceof MusicLayerMeasurewise) {
                MusicLayerMeasurewise musicLayerMeasurewise = (MusicLayerMeasurewise)this.parent;
                musicLayerMeasurewise.labels.add(object);
                int n = musicLayerMeasurewise.labels.size() - 1;
                this.pairs.add(new ElementProbPair(n, Double.POSITIVE_INFINITY));
                return n;
            }
            throw new UnsupportedOperationException();
        }

        public Object getLabel(int n) {
            return this.parent.getLabel(n);
        }

        public int getIndexOf(Object object) {
            return this.parent.getIndexOf(object);
        }

        private class ElementProbPair
        implements Comparable<ElementProbPair> {
            private int index;
            private double loglik;

            private ElementProbPair(int n, double d) {
                this.index = n;
                this.loglik = d;
            }

            @Override
            public int compareTo(ElementProbPair elementProbPair) {
                if (this.loglik > elementProbPair.loglik) {
                    return -1;
                }
                if (this.loglik < elementProbPair.loglik) {
                    return 1;
                }
                return 0;
            }
        }
    }

    class MusicLayerMeasurewise
    extends MusicLayer {
        ArrayList labels;

        MusicLayerMeasurewise(int n) {
            super(n * MusicRepresentation2.this.getDivision());
            this.labels = new ArrayList();
            for (int i = 0; i < MusicRepresentation2.this.getMeasureNum() * MusicRepresentation2.this.getDivision() / this.tiedLength; ++i) {
                this.elements.add(new MusicElement(this, i * this.tiedLength));
            }
        }

        int getMeasureWidth() {
            return this.getTiedLength() / MusicRepresentation2.this.getDivision();
        }

        @Override
        Object getLabel(int n) {
            return this.labels.get(n);
        }

        @Override
        int getIndexOf(Object object) {
            for (int i = 0; i < this.labels.size(); ++i) {
                if (!this.labels.get(i).equals(object)) continue;
                return i;
            }
            return -1;
        }

        @Override
        @Deprecated
        public MusicElement getElement(int n, int n2) {
            return this.getElementByMeasureNumber(n);
        }

        public MusicElement getElementByMeasureNumber(int n) {
            return (MusicElement)this.elements.get(n * MusicRepresentation2.this.getDivision() / this.getTiedLength());
        }
    }

    class MusicLayerBasic
    extends MusicLayer {
        Object[] labels;

        MusicLayerBasic(Object[] objectArray, int n) {
            super(n);
            this.labels = objectArray;
            for (int i = 0; i < MusicRepresentation2.this.getMeasureNum() * MusicRepresentation2.this.getDivision() / n; ++i) {
                this.elements.add(new MusicElement(this, i * n));
            }
        }

        @Override
        MusicElement getElement(int n, int n2) {
            if (n2 >= MusicRepresentation2.this.getDivision()) {
                throw new IndexOutOfBoundsException();
            }
            return (MusicElement)this.elements.get((MusicRepresentation2.this.getDivision() * n + n2) / this.getTiedLength());
        }

        @Override
        Object getLabel(int n) {
            return this.labels[n];
        }

        @Override
        int getIndexOf(Object object) {
            for (int i = 0; i < this.labels.length; ++i) {
                if (!this.labels[i].equals(object)) continue;
                return i;
            }
            return -1;
        }
    }

    abstract class MusicLayer {
        protected int tiedLength;
        protected List<MusicElement> elements;
        private List<MusicLayerListener> listeners;
        private int updateChainLimit = Integer.MAX_VALUE;
        private int updateChainCount = 0;

        MusicLayer(int n) {
            this.tiedLength = n;
            this.elements = new ArrayList<MusicElement>();
            this.listeners = new LinkedList<MusicLayerListener>();
        }

        int getTiedLength() {
            return this.tiedLength;
        }

        void addListener(MusicLayerListener musicLayerListener) {
            this.listeners.add(musicLayerListener);
        }

        private void update(MusicElement musicElement) {
            MusicRepresentation2.this.changeFlag = true;
            if (this.updateChainCount >= this.updateChainLimit) {
                return;
            }
            ++this.updateChainCount;
            for (MusicLayerListener musicLayerListener : this.listeners) {
                musicLayerListener.update(MusicRepresentation2.this, musicElement, musicElement.indexInMusRep / MusicRepresentation2.this.getDivision(), musicElement.indexInMusRep % MusicRepresentation2.this.getDivision());
            }
            this.updateChainCount = 0;
        }

        abstract MusicElement getElement(int var1, int var2);

        abstract Object getLabel(int var1);

        abstract int getIndexOf(Object var1);

        void setUpdateChainLimit(int n) {
            this.updateChainLimit = n;
        }
    }
}

