/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.math;

import jp.crestmuse.cmx.math.AbstractDoubleArrayImpl;
import jp.crestmuse.cmx.math.DoubleArray;

class DefaultDoubleArray
extends AbstractDoubleArrayImpl {
    private double[] values;
    private int from;
    private int thru;

    DefaultDoubleArray(int n) {
        this.values = new double[n];
        this.from = 0;
        this.thru = n;
    }

    DefaultDoubleArray(double[] dArray) {
        this.values = dArray;
        this.from = 0;
        this.thru = dArray.length;
    }

    DefaultDoubleArray(int n, double d) {
        this.values = new double[n];
        for (int i = 0; i < n; ++i) {
            this.values[i] = d;
        }
        this.from = 0;
        this.thru = this.values.length;
    }

    @Override
    public int length() {
        return this.thru - this.from;
    }

    @Override
    public double get(int n) {
        return this.values[n + this.from];
    }

    @Override
    public void set(int n, double d) {
        this.values[n + this.from] = d;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public double[] toArray() {
        if (this.from == 0 && this.thru == this.values.length) {
            return this.values;
        }
        double[] dArray = new double[this.thru - this.from];
        System.arraycopy(this.values, this.from, dArray, 0, this.thru - this.from);
        return dArray;
    }

    @Override
    public DoubleArray subarrayX(int n, int n2) {
        DefaultDoubleArray defaultDoubleArray = new DefaultDoubleArray(this.values);
        defaultDoubleArray.from = this.from + n;
        defaultDoubleArray.thru = this.from + n2;
        return defaultDoubleArray;
    }
}

