/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.math;

import java.util.HashMap;
import jp.crestmuse.cmx.math.AbstractDoubleMatrixImpl;

class DefaultSparseDoubleMatrix
extends AbstractDoubleMatrixImpl {
    private HashMap<IntPair, Double> values;
    private int nrows;
    private int ncols;

    DefaultSparseDoubleMatrix(int n, int n2) {
        this.nrows = n;
        this.ncols = n2;
        this.values = new HashMap();
    }

    @Override
    public int nrows() {
        return this.nrows;
    }

    @Override
    public int ncols() {
        return this.ncols;
    }

    @Override
    public double get(int n, int n2) {
        if (n >= this.nrows || n2 >= this.ncols || n < 0 || n2 < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        IntPair intPair = new IntPair(n, n2);
        if (this.values.containsKey(intPair)) {
            return this.values.get(intPair);
        }
        return 0.0;
    }

    @Override
    public void set(int n, int n2, double d) {
        if (n >= this.nrows || n2 >= this.ncols || n < 0 || n2 < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.values.put(new IntPair(n, n2), d);
    }

    private class IntPair {
        private int i;
        private int j;

        private IntPair(int n, int n2) {
            this.i = n;
            this.j = n2;
        }

        public boolean equals(Object object) {
            IntPair intPair = (IntPair)object;
            return this.i == intPair.i && this.j == intPair.j;
        }

        public int hashCode() {
            return this.i * DefaultSparseDoubleMatrix.this.nrows + this.j;
        }
    }
}

