/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.misc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Chord {
    private String name;
    private ArrayList<Integer> notes = new ArrayList();
    private int inversion = 0;
    public final int defaultBasenote = 48;
    private int basenote = 48;
    public String NAMELESS = "noname";
    static String[] allKeys = new String[]{"C", "B#", "Db", "C#", "D", "Eb", "D#", "E", "Fb", "F", "F#", "Gb", "G", "Ab", "G#", "A", "Bb", "A#", "B", "Cb"};
    static Map<String, Integer> key2dist = new HashMap<String, Integer>();
    static Map<Integer, String[]> dist2key = new HashMap<Integer, String[]>();

    public Chord(int ... nArray) {
        this.setNoteList(nArray);
        this.name = this.NAMELESS;
        this.inversion = 0;
        this.basenote = -1;
    }

    public Chord(String string) throws RuntimeException {
        this.name = string;
        this.inversion = 0;
        if (string.equals("C")) {
            this.setNoteList(this.basenote, this.basenote + 4, this.basenote + 7);
        } else if (string.equals("Dm")) {
            this.setNoteList(this.basenote + 2, this.basenote + 5, this.basenote + 9);
        } else if (string.equals("Em")) {
            this.setNoteList(this.basenote + 4, this.basenote + 7, this.basenote + 11);
        } else if (string.equals("F")) {
            this.setNoteList(this.basenote + 5, this.basenote + 9, this.basenote + 12);
        } else if (string.equals("G")) {
            this.setNoteList(this.basenote + 7, this.basenote + 11, this.basenote + 14);
        } else if (string.equals("Am")) {
            this.setNoteList(this.basenote + 9, this.basenote + 12, this.basenote + 16);
        } else if (string.equals("Bm(b5)")) {
            this.setNoteList(this.basenote + 11, this.basenote + 14, this.basenote + 17);
        } else {
            throw new RuntimeException("It is not Diatonic Chord.");
        }
    }

    public Chord(String string, int n) {
        this.basenote = n;
        this.name = Chord.formatChord(string);
        this.inversion = 0;
        this.notes = Chord.encodeChord(this.name, this.basenote);
    }

    public void invertChord(int n) {
        this.sortNotes(this.notes);
        if (n != 0) {
            if (n > 0) {
                this.notes.set(0, this.notes.get(0) + 12);
                this.sortNotes(this.notes);
                ++this.inversion;
                this.invertChord(n - 1);
            } else if (n < 0) {
                this.notes.set(this.notes.size() - 1, this.notes.get(this.notes.size() - 1) - 12);
                this.sortNotes(this.notes);
                --this.inversion;
                this.invertChord(n + 1);
            }
        }
    }

    public boolean isInverted() {
        return this.inversion != 0;
    }

    public int getBaseNote() {
        return this.basenote;
    }

    public void setBaseNote(int n) throws RuntimeException {
        if (n % 12 != 0 || n < 0 || 128 < n) {
            throw new RuntimeException("BaseNote\u306f12\u306e\u500d\u6570\u3067\u304b\u3064Midi\u30ce\u30fc\u30c8\u30ca\u30f3\u30d0\u30fc\u306e\u7bc4\u56f2\u5185\u3067\u306a\u3051\u308c\u3070\u3044\u3051\u307e\u305b\u3093");
        }
        this.basenote = n;
    }

    public String getChordName() {
        return this.name;
    }

    public ArrayList<Integer> getNotesList() {
        return this.notes;
    }

    public String toString() {
        String string = new String();
        for (int n : this.notes) {
            string = string + n;
            if (this.notes.size() - 1 == this.notes.lastIndexOf(n)) continue;
            string = string + ",";
        }
        return string;
    }

    public void printNotes() {
        System.out.println(this.toString());
    }

    public void printChordStats() {
        System.out.println(this.name + ":" + this.toString() + " Inv:" + this.inversion + " Base:" + this.basenote);
    }

    private void setNoteList(int ... nArray) {
        for (int n : nArray) {
            this.notes.add(n);
        }
    }

    private void sortNotes(ArrayList<Integer> arrayList) {
        Collections.sort(arrayList);
    }

    public static int getPrefixLength(String string) throws RuntimeException {
        int n = -1;
        for (String string2 : allKeys) {
            if (!string.startsWith(string2)) continue;
            n = string2.length();
            break;
        }
        if (n == -1) {
            throw new RuntimeException("Processing Invalid Chord Data");
        }
        return n;
    }

    public static String formatChord(String string) {
        String string2 = new String();
        return string2;
    }

    public static ArrayList<Integer> encodeChord(String string, int n) {
        String string2 = new String();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(0);
        arrayList.add(4);
        arrayList.add(7);
        string2 = string.substring(Chord.getPrefixLength(string));
        if (string2.startsWith("m") || string2.startsWith("sus4")) {
            // empty if block
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        Chord chord = new Chord("C");
        chord.printChordStats();
        chord.invertChord(2);
        chord.printChordStats();
        chord.invertChord(-2);
        chord.printChordStats();
    }

    static {
        key2dist.put("C", 0);
        key2dist.put("B#", 0);
        key2dist.put("C#", 1);
        key2dist.put("Db", 1);
        key2dist.put("D", 2);
        key2dist.put("D#", 3);
        key2dist.put("Eb", 3);
        key2dist.put("E", 4);
        key2dist.put("Fb", 4);
        key2dist.put("F", 5);
        key2dist.put("F#", 6);
        key2dist.put("Gb", 6);
        key2dist.put("G", 7);
        key2dist.put("G#", 8);
        key2dist.put("Ab", 8);
        key2dist.put("A", 9);
        key2dist.put("A#", 10);
        key2dist.put("Bb", 10);
        key2dist.put("B", 11);
        key2dist.put("Cb", 11);
        dist2key.put(0, new String[]{"C", "B#"});
        dist2key.put(1, new String[]{"Db", "C#"});
        dist2key.put(2, new String[]{"D"});
        dist2key.put(3, new String[]{"Eb", "D#"});
        dist2key.put(4, new String[]{"E", "Fb"});
        dist2key.put(5, new String[]{"F"});
        dist2key.put(6, new String[]{"F#", "Gb"});
        dist2key.put(7, new String[]{"G"});
        dist2key.put(8, new String[]{"Ab", "G#"});
        dist2key.put(9, new String[]{"A"});
        dist2key.put(10, new String[]{"Bb", "A#"});
        dist2key.put(11, new String[]{"B", "Cb"});
    }
}

