/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.misc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import jp.crestmuse.cmx.misc.QueueReader;

public class QueueWrapper<E> {
    private Queue<E> queue;
    private List<PacketWithReadCount> list;
    private byte nReaders = 0;
    int removedNum;

    public QueueWrapper(Queue<E> queue) {
        this.queue = queue;
        this.list = Collections.synchronizedList(new ArrayList());
        this.removedNum = 0;
    }

    @Deprecated
    public QueueWrapper(Queue<E> queue, int n) {
        this.queue = queue;
        this.list = Collections.synchronizedList(new ArrayList());
        this.removedNum = 0;
    }

    public QueueReader<E> createReader() {
        this.nReaders = (byte)(this.nReaders + 1);
        return new QueueReaderImpl();
    }

    private class QueueReaderImpl
    implements QueueReader<E> {
        private int next = 0;

        private QueueReaderImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E take() throws InterruptedException {
            QueueWrapper queueWrapper = QueueWrapper.this;
            synchronized (queueWrapper) {
                PacketWithReadCount packetWithReadCount;
                if (this.next < QueueWrapper.this.list.size() + QueueWrapper.this.removedNum) {
                    packetWithReadCount = (PacketWithReadCount)QueueWrapper.this.list.get(this.next - QueueWrapper.this.removedNum);
                } else {
                    Object e = QueueWrapper.this.queue instanceof BlockingQueue ? ((BlockingQueue)QueueWrapper.this.queue).take() : QueueWrapper.this.queue.poll();
                    packetWithReadCount = new PacketWithReadCount(e);
                    QueueWrapper.this.list.add(packetWithReadCount);
                }
                ++packetWithReadCount.readedCount;
                if (packetWithReadCount.readedCount >= QueueWrapper.this.nReaders) {
                    QueueWrapper.this.list.remove(0);
                    ++QueueWrapper.this.removedNum;
                }
                ++this.next;
                return packetWithReadCount.packet;
            }
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){

                @Override
                public boolean hasNext() {
                    return QueueReaderImpl.this.next < QueueWrapper.this.list.size() + QueueWrapper.this.removedNum;
                }

                @Override
                public E next() {
                    try {
                        return QueueReaderImpl.this.take();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new RuntimeException();
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private class PacketWithReadCount {
        E packet;
        int readedCount;

        public PacketWithReadCount(E e) {
            this.packet = e;
            this.readedCount = 0;
        }
    }
}

