/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.sound;

import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.sampled.AudioFormat;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.sound.AudioDataCompatible;
import jp.crestmuse.cmx.sound.MidiDeviceType;

public class Utils {
    public static AudioDataCompatible excerpt(AudioDataCompatible audioDataCompatible, int n, int n2) {
        return new MyAudioData(audioDataCompatible, n, n2);
    }

    public static List<MidiDevice.Info> getMidiDeviceInfo(MidiDeviceType midiDeviceType) throws MidiUnavailableException {
        MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
        ArrayList<MidiDevice.Info> arrayList = new ArrayList<MidiDevice.Info>();
        for (MidiDevice.Info info : infoArray) {
            System.out.println(info);
            MidiDevice midiDevice = MidiSystem.getMidiDevice(info);
            if (midiDeviceType.equals((Object)MidiDeviceType.INPUT) && midiDevice.getMaxTransmitters() != 0) {
                arrayList.add(info);
                continue;
            }
            if (!midiDeviceType.equals((Object)MidiDeviceType.OUTPUT) || midiDevice.getMaxReceivers() == 0) continue;
            arrayList.add(info);
        }
        return arrayList;
    }

    public static MidiDevice getMidiDevice(int n, MidiDeviceType midiDeviceType) throws MidiUnavailableException {
        List<MidiDevice.Info> list = Utils.getMidiDeviceInfo(midiDeviceType);
        return MidiSystem.getMidiDevice(list.get(n));
    }

    public static MidiDevice getMidiDeviceByName(String string, MidiDeviceType midiDeviceType) throws MidiUnavailableException {
        MidiDevice.Info[] infoArray;
        for (MidiDevice.Info info : infoArray = MidiSystem.getMidiDeviceInfo()) {
            if (!info.getName().contains(string)) continue;
            MidiDevice midiDevice = MidiSystem.getMidiDevice(info);
            if (midiDeviceType.equals((Object)MidiDeviceType.INPUT) && midiDevice.getMaxTransmitters() != 0) {
                return midiDevice;
            }
            if (!midiDeviceType.equals((Object)MidiDeviceType.OUTPUT) || midiDevice.getMaxReceivers() == 0) continue;
            return midiDevice;
        }
        return null;
    }

    public static MidiDevice getMidiDeviceByDescription(String string, MidiDeviceType midiDeviceType) throws MidiUnavailableException {
        MidiDevice.Info[] infoArray;
        for (MidiDevice.Info info : infoArray = MidiSystem.getMidiDeviceInfo()) {
            if (!info.getDescription().contains(string)) continue;
            MidiDevice midiDevice = MidiSystem.getMidiDevice(info);
            if (midiDeviceType.equals((Object)MidiDeviceType.INPUT) && midiDevice.getMaxTransmitters() != 0) {
                return midiDevice;
            }
            if (!midiDeviceType.equals((Object)MidiDeviceType.OUTPUT) || midiDevice.getMaxReceivers() == 0) continue;
            return midiDevice;
        }
        return null;
    }

    public static MidiDevice getMidiDeviceByVendor(String string, MidiDeviceType midiDeviceType) throws MidiUnavailableException {
        MidiDevice.Info[] infoArray;
        for (MidiDevice.Info info : infoArray = MidiSystem.getMidiDeviceInfo()) {
            if (!info.getVendor().contains(string)) continue;
            MidiDevice midiDevice = MidiSystem.getMidiDevice(info);
            if (midiDeviceType.equals((Object)MidiDeviceType.INPUT) && midiDevice.getMaxTransmitters() > 0) {
                return midiDevice;
            }
            if (!midiDeviceType.equals((Object)MidiDeviceType.OUTPUT) || midiDevice.getMaxReceivers() <= 0) continue;
            return midiDevice;
        }
        return null;
    }

    public static List<String> toStringList(List<MidiDevice.Info> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        for (MidiDevice.Info info : list) {
            arrayList.add(n++ + ": " + info.getName() + " (" + info.getVendor() + " / " + info.getDescription() + ")");
        }
        return arrayList;
    }

    private static class MyAudioData
    implements AudioDataCompatible {
        AudioDataCompatible org;
        int from;
        int thru;
        DoubleArray[] waveform = null;
        private int next = 0;

        MyAudioData(AudioDataCompatible audioDataCompatible, int n, int n2) {
            if (!audioDataCompatible.supportsWholeWaveformGetter()) {
                throw new IllegalStateException();
            }
            this.org = audioDataCompatible;
            this.from = n;
            this.thru = n2;
            DoubleArray[] doubleArrayArray = this.org.getDoubleArrayWaveform();
            this.waveform = new DoubleArray[doubleArrayArray.length];
            for (int i = 0; i < doubleArrayArray.length; ++i) {
                this.waveform[i] = doubleArrayArray[i].subarrayX(n, n2);
            }
        }

        @Override
        public int channels() {
            return this.org.channels();
        }

        @Override
        public int sampleRate() {
            return this.org.sampleRate();
        }

        @Override
        public AudioFormat getAudioFormat() {
            return this.org.getAudioFormat();
        }

        @Override
        public DoubleArray[] getDoubleArrayWaveform() {
            return this.waveform;
        }

        @Override
        public byte[] getByteArrayWaveform() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DoubleArray[] readNext(int n, int n2) {
            DoubleArray[] doubleArrayArray = new DoubleArray[this.channels()];
            for (int i = 0; i < doubleArrayArray.length; ++i) {
                doubleArrayArray[i] = this.waveform[i].subarrayX(this.next, this.next + n);
            }
            this.next += n - n2;
            return doubleArrayArray;
        }

        @Override
        public boolean hasNext(int n) {
            return this.next + n <= this.waveform[0].length();
        }

        @Override
        public boolean supportsWholeWaveformGetter() {
            return true;
        }
    }
}

