/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.sound;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Transmitter;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jp.crestmuse.cmx.amusaj.sp.MidiInputModule;
import jp.crestmuse.cmx.amusaj.sp.MidiOutputModule;
import jp.crestmuse.cmx.amusaj.sp.SPExecutor;

public class VirtualKeyboard
extends JFrame
implements MidiDevice {
    public static int VELOCITY = 127;
    public static int BASE_NOTE_NUM = 60;
    private char[] keys = new char[]{'a', 'w', 's', 'e', 'd', 'f', 't', 'g', 'y', 'h', 'u', 'j', 'k', 'o', 'l', 'p', ';', ':'};
    private int[] elevent2keys = new int[]{0, 2, 4, 5, 7, 9, 11, 12, 14, 16, 17};
    private int[] seven2keys = new int[]{1, 3, 6, 8, 10, 13, 15};
    private boolean isOpen = false;
    private Transmitter transmitter = new VirtualKeyboardTransmitter();
    private boolean[] pressed = new boolean[256];

    public VirtualKeyboard() {
        JMenuItem jMenuItem = new JMenuItem("up");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BASE_NOTE_NUM += 12;
                VirtualKeyboard.this.updateTitle();
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem("down");
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BASE_NOTE_NUM -= 12;
                VirtualKeyboard.this.updateTitle();
            }
        });
        JMenu jMenu = new JMenu("Octave");
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        this.updateTitle();
        this.add(new KeyboardPanel());
        this.pack();
    }

    private void updateTitle() {
        this.setTitle("C" + (BASE_NOTE_NUM / 12 - 2));
    }

    @Override
    public void close() {
        this.isOpen = false;
        this.transmitter.close();
    }

    @Override
    public MidiDevice.Info getDeviceInfo() {
        return null;
    }

    @Override
    public int getMaxReceivers() {
        return 0;
    }

    @Override
    public int getMaxTransmitters() {
        return 1;
    }

    @Override
    public long getMicrosecondPosition() {
        return -1L;
    }

    @Override
    public Receiver getReceiver() throws MidiUnavailableException {
        return null;
    }

    @Override
    public List<Receiver> getReceivers() {
        return null;
    }

    @Override
    public Transmitter getTransmitter() throws MidiUnavailableException {
        return this.transmitter;
    }

    @Override
    public List<Transmitter> getTransmitters() {
        LinkedList<Transmitter> linkedList = new LinkedList<Transmitter>();
        linkedList.add(this.transmitter);
        return linkedList;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void open() throws MidiUnavailableException {
        this.isOpen = true;
    }

    public static void main(String[] stringArray) {
        try {
            VirtualKeyboard virtualKeyboard = new VirtualKeyboard();
            MidiInputModule midiInputModule = new MidiInputModule(virtualKeyboard);
            MidiOutputModule midiOutputModule = new MidiOutputModule(MidiSystem.getReceiver());
            SPExecutor sPExecutor = new SPExecutor();
            sPExecutor.addSPModule(midiInputModule);
            sPExecutor.addSPModule(midiOutputModule);
            sPExecutor.connect(midiInputModule, 0, midiOutputModule, 0);
            sPExecutor.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class KeyboardPanel
    extends JPanel {
        KeyboardPanel() {
            this.setPreferredSize(new Dimension(640, 240));
        }

        @Override
        public void paint(Graphics graphics) {
            int n;
            super.paint(graphics);
            Color color = new Color(0.0f, 1.0f, 0.0f, 0.5f);
            for (int i = 0; i < 11; ++i) {
                graphics.setColor(Color.BLACK);
                n = this.getWidth() * (i + 1) / 11;
                graphics.drawLine(n, 0, n, this.getHeight());
                if (VirtualKeyboard.this.pressed[VirtualKeyboard.this.keys[VirtualKeyboard.this.elevent2keys[i]]]) {
                    graphics.setColor(color);
                    graphics.fillRect(n - this.getWidth() / 11, 0, this.getWidth() / 11, this.getHeight());
                }
                graphics.setColor(Color.BLACK);
                graphics.drawString(VirtualKeyboard.this.keys[VirtualKeyboard.this.elevent2keys[i]] + "", n - this.getWidth() / 11 + 2, this.getHeight() - 5);
            }
            float[] fArray = new float[]{0.5f, 1.5f, 3.5f, 4.5f, 5.5f, 7.5f, 8.5f};
            for (n = 0; n < fArray.length; ++n) {
                graphics.setColor(Color.BLACK);
                int n2 = (int)((float)this.getWidth() * fArray[n] / 11.0f);
                graphics.fillRect(n2, 0, this.getWidth() / 11 - 2, this.getHeight() * 2 / 3);
                if (VirtualKeyboard.this.pressed[VirtualKeyboard.this.keys[VirtualKeyboard.this.seven2keys[n]]]) {
                    graphics.setColor(color);
                    graphics.fillRect(n2, 0, this.getWidth() / 11 - 2, this.getHeight() * 2 / 3);
                }
                graphics.setColor(Color.WHITE);
                graphics.drawString(VirtualKeyboard.this.keys[VirtualKeyboard.this.seven2keys[n]] + "", n2 + 2, this.getHeight() * 2 / 3 - 5);
            }
        }
    }

    private class VirtualKeyboardTransmitter
    implements Transmitter {
        private Receiver receiver = null;
        private HashMap<Character, Integer> key2num = new HashMap();

        public VirtualKeyboardTransmitter() {
            for (int i = 0; i < VirtualKeyboard.this.keys.length; ++i) {
                this.key2num.put(Character.valueOf(VirtualKeyboard.this.keys[i]), i);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VirtualKeyboard.this.addKeyListener(new KeyListener(){

                        @Override
                        public void keyPressed(KeyEvent keyEvent) {
                            if (VirtualKeyboardTransmitter.this.receiver == null || !VirtualKeyboardTransmitter.this.key2num.containsKey(Character.valueOf(keyEvent.getKeyChar()))) {
                                return;
                            }
                            if (VirtualKeyboard.this.pressed[keyEvent.getKeyChar()]) {
                                return;
                            }
                            try {
                                ShortMessage shortMessage = new ShortMessage();
                                shortMessage.setMessage(144, (Integer)VirtualKeyboardTransmitter.this.key2num.get(Character.valueOf(keyEvent.getKeyChar())) + BASE_NOTE_NUM, VELOCITY);
                                VirtualKeyboardTransmitter.this.receiver.send(shortMessage, -1L);
                            }
                            catch (InvalidMidiDataException invalidMidiDataException) {
                                invalidMidiDataException.printStackTrace();
                            }
                            ((VirtualKeyboard)VirtualKeyboard.this).pressed[keyEvent.getKeyChar()] = true;
                            VirtualKeyboard.this.repaint();
                        }

                        @Override
                        public void keyReleased(KeyEvent keyEvent) {
                            if (VirtualKeyboardTransmitter.this.receiver == null || !VirtualKeyboardTransmitter.this.key2num.containsKey(Character.valueOf(keyEvent.getKeyChar()))) {
                                return;
                            }
                            try {
                                ShortMessage shortMessage = new ShortMessage();
                                shortMessage.setMessage(128, (Integer)VirtualKeyboardTransmitter.this.key2num.get(Character.valueOf(keyEvent.getKeyChar())) + BASE_NOTE_NUM, VELOCITY);
                                VirtualKeyboardTransmitter.this.receiver.send(shortMessage, -1L);
                            }
                            catch (InvalidMidiDataException invalidMidiDataException) {
                                invalidMidiDataException.printStackTrace();
                            }
                            ((VirtualKeyboard)VirtualKeyboard.this).pressed[keyEvent.getKeyChar()] = false;
                            VirtualKeyboard.this.repaint();
                        }

                        @Override
                        public void keyTyped(KeyEvent keyEvent) {
                        }
                    });
                    VirtualKeyboard.this.setVisible(true);
                }
            });
        }

        @Override
        public void close() {
            VirtualKeyboard.this.setVisible(false);
        }

        @Override
        public Receiver getReceiver() {
            return this.receiver;
        }

        @Override
        public void setReceiver(Receiver receiver) {
            this.receiver = receiver;
        }
    }
}

