/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.sound;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import jp.crestmuse.cmx.sound.AudioDataCompatible;
import jp.crestmuse.cmx.sound.MusicPlayer;

public class WAVPlayer
implements MusicPlayer {
    private byte[] waveform;
    private AudioFormat fmt = null;
    private SourceDataLine line = null;
    private List<LineListener> listeners = new ArrayList<LineListener>();
    private int sampleRate;
    private int channels;
    private int samplesPerSec;
    private int framesize;
    private int framerate;
    private int lengthInSec;
    private long startposition;
    private long lengthProcessed;
    private boolean nowPlaying = false;
    private static final int BUFFER_SIZE = 262144;
    private static final long SLEEP_TIME = 1000L;

    public WAVPlayer(AudioDataCompatible audioDataCompatible) throws LineUnavailableException {
        this.init(audioDataCompatible);
    }

    public void changeWaveform(AudioDataCompatible audioDataCompatible) throws LineUnavailableException {
        this.init(audioDataCompatible);
    }

    private void init(AudioDataCompatible audioDataCompatible) throws LineUnavailableException {
        if (this.isNowPlaying()) {
            this.stop();
        }
        this.waveform = audioDataCompatible.getByteArrayWaveform();
        AudioFormat audioFormat = audioDataCompatible.getAudioFormat();
        System.out.println(audioFormat);
        if (!audioFormat.equals(this.fmt)) {
            this.fmt = audioFormat;
            this.sampleRate = (int)audioFormat.getSampleRate();
            this.channels = audioFormat.getChannels();
            this.samplesPerSec = this.sampleRate * this.channels;
            this.framesize = audioFormat.getFrameSize();
            if (this.line != null) {
                this.line.close();
            }
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
            this.line = (SourceDataLine)AudioSystem.getLine(info);
            this.line.open(audioFormat, 262144 * this.framesize);
            System.out.println("Audio line buffer size: " + this.line.getBufferSize());
            for (LineListener lineListener : this.listeners) {
                this.line.addLineListener(lineListener);
            }
        }
        this.lengthInSec = this.waveform.length / this.framesize;
        this.changeStartPosition(0.0);
    }

    public void changeStartPositionInMicrosecond(long l) {
        if (this.isNowPlaying()) {
            this.line.stop();
            this.line.flush();
            this.startposition = l;
            this.line.start();
        } else {
            this.startposition = l;
        }
    }

    public void changeStartPosition(double d) {
        this.changeStartPositionInMicrosecond((long)(d * 1000000.0));
    }

    public void addLineListener(LineListener lineListener) {
        this.listeners.add(lineListener);
        this.line.addLineListener(lineListener);
    }

    public void removeLineListener(LineListener lineListener) {
        this.listeners.remove(lineListener);
        this.line.removeLineListener(lineListener);
    }

    public double getLengthInSec() {
        return this.lengthInSec;
    }

    @Override
    public synchronized void run() {
        while (true) {
            try {
                while (true) {
                    if (this.isNowPlaying()) {
                        byte[] byArray;
                        int n = 262144 / this.sampleRate / 2 * 1000;
                        System.out.println(n);
                        int n2 = (int)(this.startposition * (long)this.framesize / 1000000L);
                        do {
                            System.out.println(this.line.available());
                            byArray = this.toByteArray(this.waveform, n2, 262144 * this.framesize);
                            if (byArray != null) {
                                n2 += 262144 * this.framesize;
                                this.line.write(byArray, 0, byArray.length);
                                Thread.currentThread();
                                Thread.sleep(n);
                            }
                            System.out.println(this.line.available());
                        } while (byArray != null && this.isNowPlaying());
                        while (this.line.isActive()) {
                            Thread.currentThread();
                            Thread.sleep(1000L);
                        }
                        this.line.stop();
                        this.line.flush();
                        this.nowPlaying = false;
                        this.startposition = 0L;
                    }
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    @Override
    public long getMicrosecondPosition() {
        return this.line.getMicrosecondPosition() - this.lengthProcessed + this.startposition;
    }

    @Override
    public boolean isNowPlaying() {
        return this.nowPlaying;
    }

    @Override
    public void play() {
        this.line.start();
        this.lengthProcessed = this.line.getMicrosecondPosition();
        this.nowPlaying = true;
    }

    @Override
    public void stop() {
        this.line.stop();
        this.line.flush();
        this.nowPlaying = false;
    }

    protected void finalize() {
        this.line.close();
    }

    private byte[] toByteArray(byte[] byArray, int n, int n2) {
        if (n >= byArray.length) {
            return null;
        }
        if (n2 > byArray.length - n) {
            n2 = byArray.length - n;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        byteBuffer.order(this.fmt.isBigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < n2; ++i) {
            byteBuffer.put(byArray[i + n]);
        }
        return byteBuffer.array();
    }

    @Override
    public int getTicksPerBeat() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getTickPosition() {
        throw new UnsupportedOperationException();
    }
}

