/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.filewrappers;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.elements.MutableControlChange;
import jp.crestmuse.cmx.elements.MutableMusicEvent;
import jp.crestmuse.cmx.elements.MutableNote;
import jp.crestmuse.cmx.elements.MutablePitchBend;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.InvalidElementException;
import jp.crestmuse.cmx.filewrappers.InvalidFileTypeException;
import jp.crestmuse.cmx.filewrappers.NodeInterface;
import jp.crestmuse.cmx.filewrappers.SCCXMLWrapper;
import jp.crestmuse.cmx.handlers.MIDIHandler;
import jp.crestmuse.cmx.misc.MIDIConst;
import jp.crestmuse.cmx.misc.MIDIEventList;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MIDIXMLWrapper
extends CMXFileWrapper {
    public static final String TOP_TAG = "MIDIFile";
    private byte format;
    private int ticksPerBeat;
    private byte timestampType;
    private int nTracks;
    public static final byte TIMESTAMP_DELTA = 1;
    public static final byte TIMESTAMP_ABSOLUTE = 2;
    private boolean firstElementsAdded = false;
    private boolean trackStarted = false;
    private String smfFileName = null;
    private Track[] tracks = null;
    private int ignoredDelta = 0;

    public String getSMFFileName() {
        return this.smfFileName;
    }

    public void addElementsFirstForFormat0(int n) {
        this.format = 0;
        this.nTracks = 1;
        this.ticksPerBeat = n;
        this.timestampType = 1;
        this.addChild("Format");
        this.addText("0");
        this.addSibling("TrackCount");
        this.addText("1");
        this.addSibling("TicksPerBeat");
        this.addText(n);
        this.addSibling("TimestampType");
        this.addText("Delta");
        this.returnToParent();
        this.firstElementsAdded = true;
    }

    public void addElementsFirstForFormat1(int n, int n2) {
        this.format = 1;
        this.nTracks = n;
        this.ticksPerBeat = n2;
        this.timestampType = 1;
        this.addChild("Format");
        this.addText("1");
        this.addSibling("TrackCount");
        this.addText(n);
        this.addSibling("TicksPerBeat");
        this.addText(n2);
        this.addSibling("TimestampType");
        this.addText("Delta");
        this.returnToParent();
        this.firstElementsAdded = true;
    }

    public void newTrack(int n) {
        this.checkElementAddition(this.firstElementsAdded);
        this.checkElementAddition(!this.trackStarted);
        this.addChild("Track");
        this.setAttribute("Number", n);
        this.trackStarted = true;
    }

    public void endTrack(boolean bl) {
        this.checkElementAddition(this.trackStarted);
        if (bl) {
            this.addMetaEvent("EndOfTrack", 4 * this.ticksPerBeat, new int[0]);
        }
        this.returnToParent();
        this.trackStarted = false;
    }

    public void endTrack() {
        this.endTrack(true);
    }

    public void addMIDIChannelMessages(MIDIEventList mIDIEventList) {
        int n = 0;
        for (MIDIEventList.MIDIEvent mIDIEvent : mIDIEventList) {
            this.addMIDIChannelMessage(mIDIEvent.msgname(), mIDIEvent.time() - n, mIDIEvent.channel(), mIDIEvent.value1(), mIDIEvent.value2());
            n = mIDIEvent.time();
        }
    }

    public void addMIDIChannelMessage(String string, int n, byte by, int ... nArray) {
        this.checkElementAddition(this.trackStarted);
        this.addChild("Event");
        if (this.timestampType == 1) {
            this.addChild("Delta");
        } else if (this.timestampType == 2) {
            this.addChild("Absolute");
        } else {
            throw new InvalidElementException("TimestampType is invalid");
        }
        this.addText(String.valueOf(n));
        if (MIDIConst.isSupportedMessage(string)) {
            this.addSibling(string);
            this.setAttribute("Channel", String.valueOf(by));
            String[] stringArray = MIDIConst.getAttributeList(string);
            for (int i = 0; i < stringArray.length; ++i) {
                if (MIDIConst.isOnOffMessage(string)) {
                    this.setAttribute(stringArray[i], MIDIConst.onOffMsgByteToString((byte)nArray[i]));
                    continue;
                }
                this.setAttribute(stringArray[i], nArray[i]);
            }
        } else {
            throw new InvalidElementException("Unsupported channel message: " + string);
        }
        this.returnToParent();
        this.returnToParent();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addMetaEvent(String string, int n, int ... nArray) {
        this.checkElementAddition(this.trackStarted);
        this.addChild("Event");
        if (this.timestampType == 1) {
            this.addChild("Delta");
        } else {
            if (this.timestampType != 2) throw new InvalidElementException("TimestampType is invalid");
            this.addChild("Absolute");
        }
        this.addText(String.valueOf(n));
        if (!MIDIConst.isSupportedMetaEvent(string)) throw new InvalidElementException("Unsupported meta event: " + string);
        this.addSibling(string);
        String[] stringArray = MIDIConst.getAttributeList(string);
        if (stringArray.length != nArray.length) throw new InvalidElementException("# of values is invalid");
        for (int i = 0; i < nArray.length; ++i) {
            this.setAttribute(stringArray[i], nArray[i]);
        }
        this.returnToParent();
        this.returnToParent();
    }

    public void writefileAsSMF(String string) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
        this.smfFileName = string;
        this.writeAsSMF(dataOutputStream);
    }

    public void writefileAsSMF(File file) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        this.smfFileName = file.getName();
        this.writeAsSMF(dataOutputStream);
    }

    public void writeAsSMF(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(outputStream));
        this.writeAsSMF(dataOutputStream);
    }

    void writeAsSMF(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeBytes("MThd");
        dataOutputStream.writeInt(6);
        dataOutputStream.writeShort(this.format);
        dataOutputStream.writeShort(this.nTracks);
        dataOutputStream.writeShort(this.ticksPerBeat);
        Track[] trackArray = this.getTrackList();
        if (trackArray.length != this.nTracks) {
            throw new InvalidElementException("TrackCount is wrong");
        }
        for (Track track : trackArray) {
            byte[] byArray = track.toSMFFormat();
            dataOutputStream.writeBytes("MTrk");
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray, 0, byArray.length);
        }
        dataOutputStream.close();
    }

    public static MIDIXMLWrapper readSMF(String string) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        MIDIXMLWrapper mIDIXMLWrapper = (MIDIXMLWrapper)MIDIXMLWrapper.createDocument(TOP_TAG);
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(string)));
        mIDIXMLWrapper.readSMF(dataInputStream);
        mIDIXMLWrapper.finalizeDocument();
        mIDIXMLWrapper.smfFileName = string;
        return mIDIXMLWrapper;
    }

    public static MIDIXMLWrapper readSMF(InputStream inputStream) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        MIDIXMLWrapper mIDIXMLWrapper = (MIDIXMLWrapper)MIDIXMLWrapper.createDocument(TOP_TAG);
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
        mIDIXMLWrapper.readSMF(dataInputStream);
        mIDIXMLWrapper.finalizeDocument();
        return mIDIXMLWrapper;
    }

    private void readSMF(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[256];
        int n = 0;
        do {
            dataInputStream.read(byArray);
            int n2 = dataInputStream.readInt();
            if (n2 > byArray2.length) {
                byArray2 = new byte[n2];
            }
            dataInputStream.read(byArray2, 0, n2);
            if (byArray[0] == 77 && byArray[1] == 84) {
                if (byArray[2] == 104 && byArray[3] == 100) {
                    this.readSMFHeaderChunk(byArray2, n2);
                    continue;
                }
                if (byArray[2] == 114 && byArray[3] == 107) {
                    this.readSMFTrackChunk(byArray2, n2, n++);
                    continue;
                }
                throw new InvalidFileTypeException("Invalid SMF");
            }
            throw new InvalidFileTypeException("Invalid SMF");
        } while (dataInputStream.available() > 0);
    }

    private void readSMFHeaderChunk(byte[] byArray, int n) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, n);
        this.format = (byte)byteBuffer.getShort();
        this.nTracks = byteBuffer.getShort();
        this.ticksPerBeat = byteBuffer.getShort();
        this.timestampType = 1;
        if (this.format == 1) {
            this.addElementsFirstForFormat1(this.nTracks, this.ticksPerBeat);
        } else if (this.format == 0) {
            this.addElementsFirstForFormat0(this.ticksPerBeat);
        } else {
            throw new IllegalStateException("Unsupported");
        }
    }

    private void readSMFTrackChunk(byte[] byArray, int n, int n2) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, n);
        this.newTrack(n2);
        short s = 0;
        while (byteBuffer.hasRemaining()) {
            short s2;
            byte by;
            int n3 = 0;
            do {
                by = byteBuffer.get();
                n3 = n3 * 128 + (by & 0x7F);
            } while (by < 0);
            by = byteBuffer.get();
            short s3 = s2 = by > 0 ? (short)by : (short)(by & 0xFF);
            if (s2 == 255) {
                this.readMetaEvent(byteBuffer, n3);
                continue;
            }
            if (s2 > 240) continue;
            if (s2 == 240) {
                this.readMIDIExclusiveMessage(byteBuffer, n3);
                continue;
            }
            if (s2 >= 128) {
                s = s2;
                this.readMIDIChannelMessage(s, byteBuffer, n3);
                continue;
            }
            byteBuffer.position(byteBuffer.position() - 1);
            this.readMIDIChannelMessage(s, byteBuffer, n3);
        }
        this.endTrack(false);
    }

    private void readMetaEvent(ByteBuffer byteBuffer, int n) {
        byte by = byteBuffer.get();
        byte by2 = byteBuffer.get();
        byte[] byArray = new byte[by2];
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray);
        byteBuffer.get(byArray);
        if (MIDIConst.isSupportedMetaEvent(by)) {
            String string = MIDIConst.metaEventTypeToName(by);
            String[] stringArray = MIDIConst.getAttributeList(string);
            byte by3 = MIDIConst.getByteLength(string);
            int[] nArray = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                for (byte by4 = 0; by4 < by3; by4 = (byte)(by4 + 1)) {
                    int n2 = byteBuffer2.get();
                    if (n2 < 0) {
                        n2 &= 0xFF;
                    }
                    nArray[i] = nArray[i] * 256 + n2;
                }
            }
            this.addMetaEvent(string, n + this.ignoredDelta, nArray);
            this.ignoredDelta = 0;
        } else {
            this.ignoredDelta += n;
        }
    }

    private void readMIDIExclusiveMessage(ByteBuffer byteBuffer, int n) {
        byte by = byteBuffer.get();
        for (byte by2 = 0; by2 < by; by2 = (byte)(by2 + 1)) {
            byteBuffer.get();
        }
        this.ignoredDelta += n;
    }

    private void readMIDIChannelMessage(short s, ByteBuffer byteBuffer, int n) {
        byte by = (byte)(s & 0xF);
        by = (byte)(by + 1);
        s = (short)(s & 0xF0);
        String string = MIDIConst.statusNoToMsgName(s);
        String[] stringArray = MIDIConst.getAttributeList(string);
        int[] nArray = new int[stringArray.length];
        byte by2 = MIDIConst.getByteLength(string);
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = 0;
            for (byte by3 = 0; by3 < by2; by3 = (byte)(by3 + 1)) {
                nArray[i] = MIDIConst.msbFirst(string) ? nArray[i] * 128 + (byteBuffer.get() & 0x7F) : nArray[i] + MIDIXMLWrapper.pow(128, by3) * (byteBuffer.get() & 0x7F);
            }
        }
        this.addMIDIChannelMessage(string, n + this.ignoredDelta, by, nArray);
        this.ignoredDelta = 0;
    }

    private static final int pow(int n, int n2) {
        int n3 = 1;
        for (int i = 0; i < n2; ++i) {
            n3 *= n;
        }
        return n3;
    }

    public void processMIDIEvent(MIDIHandler mIDIHandler) {
        Track[] trackArray;
        this.checkFinalized();
        for (Track track : trackArray = this.getTrackList()) {
            MIDIEvent[] mIDIEventArray;
            mIDIHandler.beginTrack(track, this);
            for (MIDIEvent mIDIEvent : mIDIEventArray = track.getMIDIEventList()) {
                mIDIHandler.processMIDIEvent(mIDIEvent, this);
            }
            mIDIHandler.endTrack(track, this);
        }
    }

    @Deprecated
    public InputStream getMIDIInputStream() throws IOException {
        PipedInputStream pipedInputStream = new PipedInputStream();
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        final DataOutputStream dataOutputStream = new DataOutputStream(pipedOutputStream);
        pipedInputStream.connect(pipedOutputStream);
        new Thread(new Runnable(){

            public void run() {
                try {
                    MIDIXMLWrapper.this.writeAsSMF(dataOutputStream);
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("I/O Error");
                }
            }
        }).start();
        return pipedInputStream;
    }

    public SCCXMLWrapper toSCCXML() throws TransformerException, IOException, ParserConfigurationException, SAXException {
        SCCXMLWrapper sCCXMLWrapper = (SCCXMLWrapper)CMXFileWrapper.createDocument("scc");
        this.toSCCXML(sCCXMLWrapper);
        return sCCXMLWrapper;
    }

    public void toSCCXML(SCCXMLWrapper sCCXMLWrapper) throws TransformerException, IOException, ParserConfigurationException, SAXException {
        this.toSCCXML(sCCXMLWrapper, null);
    }

    public void toSCCXML(SCCXMLWrapper sCCXMLWrapper, SCCXMLWrapper.EasyChord[] easyChordArray) throws TransformerException, IOException, ParserConfigurationException, SAXException {
        this.toSCCXML(sCCXMLWrapper, easyChordArray, null);
    }

    public void toSCCXML(SCCXMLWrapper sCCXMLWrapper, SCCXMLWrapper.EasyChord[] easyChordArray, String string) throws TransformerException, IOException, ParserConfigurationException, SAXException {
        sCCXMLWrapper.setDivision(this.ticksPerBeat);
        final HashMap hashMap = new HashMap();
        final ArrayList arrayList = new ArrayList();
        this.processMIDIEvent(new MIDIHandler(){
            private int totalTime;
            private MutableNote[] onNotes;

            @Override
            public void beginTrack(Track track, MIDIXMLWrapper mIDIXMLWrapper) {
                this.totalTime = 0;
                this.onNotes = new MutableNote[128];
            }

            @Override
            public void endTrack(Track track, MIDIXMLWrapper mIDIXMLWrapper) {
            }

            @Override
            public void processMIDIEvent(MIDIEvent mIDIEvent, MIDIXMLWrapper mIDIXMLWrapper) {
                this.totalTime += mIDIEvent.deltaTime();
                String string = mIDIEvent.messageType();
                if (mIDIEvent.messageType().equals("SetTempo")) {
                    arrayList.add(this.totalTime);
                    arrayList.add(60000000 / mIDIEvent.value(0));
                    return;
                }
                if (MIDIConst.isSupportedMetaEvent(mIDIEvent.messageType())) {
                    return;
                }
                short s = MIDIConst.msgNameToStatusNo(string);
                if (s == 144 && mIDIEvent.value(1) > 0) {
                    MutableNote mutableNote = new MutableNote(this.totalTime, this.totalTime, mIDIEvent.value(0), mIDIEvent.value(1), MIDIXMLWrapper.this.ticksPerBeat());
                    this.addNote(mutableNote, mIDIEvent, hashMap, this.onNotes);
                } else if (s == 128 || s == 144 && mIDIEvent.value(1) == 0) {
                    this.addNoteOff(this.totalTime, mIDIEvent, hashMap);
                } else if (s == 176) {
                    MutableControlChange mutableControlChange = new MutableControlChange(this.totalTime, mIDIEvent.value(0), mIDIEvent.value(1), MIDIXMLWrapper.this.ticksPerBeat());
                    this.addControlChange(mutableControlChange, mIDIEvent, hashMap);
                } else if (s == 224) {
                    MutablePitchBend mutablePitchBend = new MutablePitchBend(this.totalTime, mIDIEvent.value(0), MIDIXMLWrapper.this.ticksPerBeat());
                    this.addControlChange(mutablePitchBend, mIDIEvent, hashMap);
                }
            }

            private void addControlChange(MutableMusicEvent mutableMusicEvent, MIDIEvent mIDIEvent, Map<Byte, ArrayList<MutableMusicEvent>> map) {
                if (!map.containsKey(mIDIEvent.channel())) {
                    map.put(mIDIEvent.channel(), new ArrayList());
                }
                map.get(mIDIEvent.channel()).add(mutableMusicEvent);
            }

            private void addNote(MutableNote mutableNote, MIDIEvent mIDIEvent, Map<Byte, ArrayList<MutableMusicEvent>> map, MutableNote[] mutableNoteArray) {
                int n = mutableNote.notenum();
                if (mutableNoteArray[n] != null) {
                    mutableNoteArray[n].setOffset(mutableNote.onset() - 1);
                }
                if (!map.containsKey(mIDIEvent.channel())) {
                    map.put(mIDIEvent.channel(), new ArrayList());
                }
                map.get(mIDIEvent.channel()).add(mutableNote);
                mutableNoteArray[mutableNote.notenum()] = mutableNote;
            }

            private void addNoteOff(int n, MIDIEvent mIDIEvent, Map<Byte, ArrayList<MutableMusicEvent>> map) {
                int n2 = mIDIEvent.value(0);
                if (this.onNotes[n2] != null) {
                    this.onNotes[n2].setOffset(n);
                    this.onNotes[n2] = null;
                }
            }
        });
        sCCXMLWrapper.beginHeader();
        for (int i = 0; i < arrayList.size(); i += 2) {
            sCCXMLWrapper.addHeaderElement((int)((Integer)arrayList.get(i)), "TEMPO", (Integer)arrayList.get(i + 1));
        }
        if (string != null) {
            sCCXMLWrapper.addHeaderElement(0, "KEY", string);
        }
        sCCXMLWrapper.endHeader();
        for (Map.Entry entry : hashMap.entrySet()) {
            byte by = (Byte)entry.getKey();
            ArrayList arrayList2 = (ArrayList)entry.getValue();
            sCCXMLWrapper.newPart(by, by, 0, 100);
            for (MutableMusicEvent object : arrayList2) {
                MutableMusicEvent mutableMusicEvent;
                if (object instanceof MutableNote) {
                    mutableMusicEvent = (MutableNote)object;
                    sCCXMLWrapper.addNoteElement(mutableMusicEvent.onset(), mutableMusicEvent.offset(), ((MutableNote)mutableMusicEvent).notenum(), ((MutableNote)mutableMusicEvent).velocity(), ((MutableNote)mutableMusicEvent).offVelocity());
                    continue;
                }
                if (object instanceof MutableControlChange) {
                    mutableMusicEvent = (MutableControlChange)object;
                    sCCXMLWrapper.addControlChange(mutableMusicEvent.onset(), mutableMusicEvent.offset(), ((MutableControlChange)mutableMusicEvent).ctrlnum(), ((MutableControlChange)mutableMusicEvent).value());
                    continue;
                }
                if (!(object instanceof MutablePitchBend)) continue;
                mutableMusicEvent = (MutablePitchBend)object;
                sCCXMLWrapper.addPitchBend(mutableMusicEvent.onset(), mutableMusicEvent.offset(), ((MutablePitchBend)mutableMusicEvent).value());
            }
            sCCXMLWrapper.endPart();
        }
        if (easyChordArray != null) {
            sCCXMLWrapper.beginAnnotations();
            for (SCCXMLWrapper.EasyChord easyChord : easyChordArray) {
                if (easyChord == null) continue;
                sCCXMLWrapper.addChord(easyChord.onset, easyChord.offset, easyChord.chord);
            }
            sCCXMLWrapper.endAnnotations();
        }
        sCCXMLWrapper.finalizeDocument();
    }

    public int format() {
        return this.format;
    }

    public int trackCount() {
        return this.nTracks;
    }

    public int ticksPerBeat() {
        return this.ticksPerBeat;
    }

    protected void analyze() {
        if (!this.firstElementsAdded) {
            this.format = (byte)NodeInterface.getTextInt(this.selectSingleNode("/MIDIFile/Format"));
            this.nTracks = NodeInterface.getTextInt(this.selectSingleNode("/MIDIFile/TrackCount"));
            this.ticksPerBeat = NodeInterface.getTextInt(this.selectSingleNode("/MIDIFile/TicksPerBeat"));
        }
    }

    public Track[] getTrackList() {
        if (this.tracks == null) {
            NodeList nodeList = this.selectNodeList("/MIDIFile/Track");
            int n = nodeList.getLength();
            this.tracks = new Track[n];
            for (int i = 0; i < n; ++i) {
                this.tracks[i] = new Track(nodeList.item(i));
            }
        }
        return this.tracks;
    }

    public class MIDIEvent
    extends NodeInterface {
        private Node child1;
        private Node child2;
        private int deltaTime;
        private String msgType;
        private boolean isChannelMessage;
        private boolean isMetaEvent;
        private int[] values;
        private byte channel;

        private MIDIEvent(Node node) {
            super(node);
            this.channel = (byte)-1;
            NodeList nodeList = this.node().getChildNodes();
            this.child1 = nodeList.item(0);
            if (!this.child1.getNodeName().equals("Delta")) {
                throw new InvalidElementException("No Delta element.");
            }
            this.deltaTime = MIDIEvent.getTextInt(this.child1);
            this.child2 = nodeList.item(1);
            this.msgType = this.child2.getNodeName();
            this.isChannelMessage = MIDIConst.isSupportedMessage(this.msgType);
            this.isMetaEvent = MIDIConst.isSupportedMetaEvent(this.msgType);
            if (this.isChannelMessage) {
                this.channel = Byte.parseByte(MIDIEvent.getAttribute(this.child2, "Channel"));
            }
            String[] stringArray = MIDIConst.getAttributeList(this.msgType);
            this.values = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.values[i] = MIDIConst.isOnOffMessage(this.msgType) ? (int)MIDIConst.onOffMsgStringToByte(MIDIEvent.getAttribute(this.child2, stringArray[i])) : MIDIEvent.getAttributeInt(this.child2, stringArray[i]);
            }
        }

        protected final String getSupportedNodeName() {
            return "Event";
        }

        public final int deltaTime() {
            return this.deltaTime;
        }

        public final String messageType() {
            return this.msgType;
        }

        public final int value(int n) {
            return this.values[n];
        }

        public final int[] values() {
            return this.values;
        }

        public final byte[] tempoValues() {
            if (!this.isMetaEvent) {
                return null;
            }
            int n = this.values[0];
            byte[] byArray = new byte[]{(byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
            return byArray;
        }

        public final byte channel() {
            return this.channel;
        }

        public final boolean isChannelMessage() {
            return this.isChannelMessage;
        }

        public final boolean isMetaEvent() {
            return this.isMetaEvent;
        }

        byte[] getDeltaTimeForSMF() {
            int n = (32 - Integer.numberOfLeadingZeros(this.deltaTime) + 1) / 7 + 1;
            int n2 = this.deltaTime;
            byte[] byArray = new byte[n];
            for (int i = n - 1; i >= 0; --i) {
                byArray[i] = (byte)(n2 % 128);
                if (i < n - 1) {
                    int n3 = i;
                    byArray[n3] = (byte)(byArray[n3] | 0x80);
                }
                n2 /= 128;
            }
            return byArray;
        }

        byte[] toMIDIMessageBinary() {
            int n;
            int n2 = 0;
            byte[] byArray = new byte[16];
            if (this.isChannelMessage) {
                n = MIDIConst.msgNameToStatusNo(this.msgType);
                if (n >= 128) {
                    byArray[n2] = (byte)(n + this.channel - 1);
                    ++n2;
                } else {
                    byArray[n2] = (byte)(176 + this.channel - 1);
                    byArray[++n2] = (byte)n;
                }
                for (int i = 0; i < this.values.length; ++i) {
                    byte by = MIDIConst.getByteLength(this.msgType);
                    if (by == 1) {
                        byArray[n2] = (byte)this.values[i];
                        ++n2;
                        continue;
                    }
                    if (by == 2) {
                        byArray[n2] = (byte)(this.values[i] % 128);
                        byArray[++n2] = (byte)(this.values[i] / 128);
                        ++n2;
                        continue;
                    }
                    throw new IllegalArgumentException();
                }
                if (this.values.length == 0) {
                    byArray[n2] = 0;
                    ++n2;
                }
            } else if (this.isMetaEvent) {
                byArray[n2] = -1;
                byArray[++n2] = (byte)MIDIConst.metaEventNameToType(this.msgType);
                ++n2;
                n = n2++;
                for (int i = 0; i < this.values.length; ++i) {
                    byte by = MIDIConst.getByteLength(this.msgType);
                    if (by == 1) {
                        byArray[n2] = (byte)this.values[i];
                        ++n2;
                        continue;
                    }
                    if (by == 2) {
                        byArray[n2] = (byte)(this.values[i] / 256);
                        byArray[++n2] = (byte)(this.values[i] % 256);
                        ++n2;
                        continue;
                    }
                    if (by == 3) {
                        byArray[n2] = (byte)(this.values[i] / 65536);
                        byArray[++n2] = (byte)(this.values[i] / 256 % 256);
                        byArray[++n2] = (byte)(this.values[i] % 256);
                        ++n2;
                        continue;
                    }
                    throw new IllegalArgumentException();
                }
                byArray[n] = (byte)(n2 - n - 1);
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            return byArray2;
        }
    }

    public class Track
    extends NodeInterface {
        private MIDIEvent[] events;

        private Track(Node node) {
            super(node);
        }

        protected String getSupportedNodeName() {
            return "Track";
        }

        public MIDIEvent[] getMIDIEventList() {
            if (this.events == null) {
                NodeList nodeList = this.getChildNodes();
                int n = nodeList.getLength();
                this.events = new MIDIEvent[n];
                for (int i = 0; i < n; ++i) {
                    this.events[i] = new MIDIEvent(nodeList.item(i));
                }
            }
            return this.events;
        }

        byte[] toSMFFormat() {
            MIDIEvent[] mIDIEventArray;
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
            for (MIDIEvent mIDIEvent : mIDIEventArray = this.getMIDIEventList()) {
                arrayList.add(mIDIEvent.getDeltaTimeForSMF());
                arrayList.add(mIDIEvent.toMIDIMessageBinary());
            }
            int n = 0;
            for (byte[] byArray : arrayList) {
                n += byArray.length;
            }
            Object object = new byte[n];
            int n2 = 0;
            for (byte[] byArray : arrayList) {
                for (int i = 0; i < byArray.length; ++i) {
                    object[n2] = byArray[i];
                    ++n2;
                }
            }
            return object;
        }
    }
}

