/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weka.core.Instances;
import weka.gui.Messages;
import weka.gui.arffviewer.ArffPanel;

public class ViewerDialog
extends JDialog
implements ChangeListener {
    private static final long serialVersionUID = 6747718484736047752L;
    public static final int APPROVE_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    protected int m_Result = 1;
    protected JButton m_OkButton;
    protected JButton m_CancelButton;
    protected JButton m_UndoButton;
    protected ArffPanel m_ArffPanel;

    public ViewerDialog(Frame parent) {
        super(parent, true);
        Messages.getInstance();
        this.m_OkButton = new JButton(Messages.getString("ViewerDialog_OkButton_JButton_Text"));
        Messages.getInstance();
        this.m_CancelButton = new JButton(Messages.getString("ViewerDialog_CancelButton_JButton_Text"));
        Messages.getInstance();
        this.m_UndoButton = new JButton(Messages.getString("ViewerDialog_UndoButton_JButton_Text"));
        this.m_ArffPanel = new ArffPanel();
        this.createDialog();
    }

    protected void createDialog() {
        Messages.getInstance();
        this.setTitle(Messages.getString("ViewerDialog_CreateDialog_SetTitle_Text"));
        this.getContentPane().setLayout(new BorderLayout());
        this.m_ArffPanel.addChangeListener(this);
        this.getContentPane().add((Component)this.m_ArffPanel, "Center");
        JPanel panel = new JPanel(new FlowLayout(2));
        this.getContentPane().add((Component)panel, "South");
        this.m_UndoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewerDialog.this.undo();
            }
        });
        this.getContentPane().add((Component)panel, "South");
        this.m_CancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewerDialog.this.m_Result = 1;
                ViewerDialog.this.setVisible(false);
            }
        });
        this.m_OkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewerDialog.this.m_Result = 0;
                ViewerDialog.this.setVisible(false);
            }
        });
        panel.add(this.m_UndoButton);
        panel.add(this.m_OkButton);
        panel.add(this.m_CancelButton);
        this.pack();
    }

    public void setInstances(Instances inst) {
        this.m_ArffPanel.setInstances(new Instances(inst));
    }

    public Instances getInstances() {
        return this.m_ArffPanel.getInstances();
    }

    protected void setButtons() {
        this.m_OkButton.setEnabled(true);
        this.m_CancelButton.setEnabled(true);
        this.m_UndoButton.setEnabled(this.m_ArffPanel.canUndo());
    }

    public boolean isChanged() {
        return this.m_ArffPanel.isChanged();
    }

    private void undo() {
        this.m_ArffPanel.undo();
    }

    public void stateChanged(ChangeEvent e) {
        this.setButtons();
    }

    public int showDialog() {
        this.m_Result = 1;
        this.setVisible(true);
        this.setButtons();
        return this.m_Result;
    }

    public int showDialog(Instances inst) {
        this.setInstances(inst);
        return this.showDialog();
    }
}

