/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.ObjectOutputStream;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.CSVLoader;
import weka.core.converters.ConverterUtils;
import weka.core.converters.Loader;
import weka.core.converters.SerializedInstancesLoader;
import weka.core.converters.URLSourcedLoader;
import weka.datagenerators.DataGenerator;
import weka.experiment.InstanceQuery;
import weka.filters.Filter;
import weka.filters.SupervisedFilter;
import weka.filters.unsupervised.attribute.Remove;
import weka.gui.AttributeSelectionPanel;
import weka.gui.AttributeSummaryPanel;
import weka.gui.AttributeVisualizationPanel;
import weka.gui.ConverterFileChooser;
import weka.gui.GenericObjectEditor;
import weka.gui.InstancesSummaryPanel;
import weka.gui.LogPanel;
import weka.gui.Logger;
import weka.gui.PropertyDialog;
import weka.gui.PropertyPanel;
import weka.gui.SysErrLog;
import weka.gui.TaskLogger;
import weka.gui.ViewerDialog;
import weka.gui.beans.AttributeSummarizer;
import weka.gui.explorer.DataGeneratorPanel;
import weka.gui.explorer.Explorer;
import weka.gui.explorer.ExplorerDefaults;
import weka.gui.explorer.Messages;
import weka.gui.sql.SqlViewerDialog;

public class PreprocessPanel
extends JPanel
implements Explorer.CapabilitiesFilterChangeListener,
Explorer.ExplorerPanel,
Explorer.LogHandler {
    private static final long serialVersionUID = 6764850273874813049L;
    protected InstancesSummaryPanel m_InstSummaryPanel = new InstancesSummaryPanel();
    protected JButton m_OpenFileBut;
    protected JButton m_OpenURLBut;
    protected JButton m_OpenDBBut;
    protected JButton m_GenerateBut;
    protected JButton m_UndoBut;
    protected JButton m_EditBut;
    protected JButton m_SaveBut;
    protected AttributeSelectionPanel m_AttPanel;
    protected JButton m_RemoveButton;
    protected AttributeSummaryPanel m_AttSummaryPanel;
    protected GenericObjectEditor m_FilterEditor;
    protected PropertyPanel m_FilterPanel;
    protected JButton m_ApplyFilterBut;
    protected ConverterFileChooser m_FileChooser;
    protected String m_LastURL;
    protected String m_SQLQ;
    protected Instances m_Instances;
    protected DataGenerator m_DataGenerator;
    protected AttributeVisualizationPanel m_AttVisualizePanel;
    protected File[] m_tempUndoFiles;
    protected int m_tempUndoIndex;
    protected PropertyChangeSupport m_Support;
    protected Thread m_IOThread;
    protected Logger m_Log;
    protected Explorer m_Explorer;

    public PreprocessPanel() {
        Messages.getInstance();
        this.m_OpenFileBut = new JButton(Messages.getString("PreprocessPanel_OpenFileBut_JButton_Text"));
        Messages.getInstance();
        this.m_OpenURLBut = new JButton(Messages.getString("PreprocessPanel_OpenURLBut_JButton_Text"));
        Messages.getInstance();
        this.m_OpenDBBut = new JButton(Messages.getString("PreprocessPanel_OpenDBBut_JButton_Text"));
        Messages.getInstance();
        this.m_GenerateBut = new JButton(Messages.getString("PreprocessPanel_GenerateBut_JButton_Text"));
        Messages.getInstance();
        this.m_UndoBut = new JButton(Messages.getString("PreprocessPanel_UndoBut_JButton_Text"));
        Messages.getInstance();
        this.m_EditBut = new JButton(Messages.getString("PreprocessPanel_EditBut_JButton_Text"));
        Messages.getInstance();
        this.m_SaveBut = new JButton(Messages.getString("PreprocessPanel_SaveBut_JButton_Text"));
        this.m_AttPanel = new AttributeSelectionPanel();
        Messages.getInstance();
        this.m_RemoveButton = new JButton(Messages.getString("PreprocessPanel_RemoveButton_JButton_Text"));
        this.m_AttSummaryPanel = new AttributeSummaryPanel();
        this.m_FilterEditor = new GenericObjectEditor();
        this.m_FilterPanel = new PropertyPanel(this.m_FilterEditor);
        Messages.getInstance();
        this.m_ApplyFilterBut = new JButton(Messages.getString("PreprocessPanel_ApplyFilterBut_JButton_Text"));
        this.m_FileChooser = new ConverterFileChooser(new File(ExplorerDefaults.getInitialDirectory()));
        this.m_LastURL = "http://";
        this.m_SQLQ = new String("SELECT * FROM ?");
        this.m_DataGenerator = null;
        this.m_AttVisualizePanel = new AttributeVisualizationPanel();
        this.m_tempUndoFiles = new File[20];
        this.m_tempUndoIndex = 0;
        this.m_Support = new PropertyChangeSupport(this);
        this.m_Log = new SysErrLog();
        this.m_Explorer = null;
        this.m_FilterEditor.setClassType(Filter.class);
        if (ExplorerDefaults.getFilter() != null) {
            this.m_FilterEditor.setValue(ExplorerDefaults.getFilter());
        }
        this.m_FilterEditor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                PreprocessPanel.this.m_ApplyFilterBut.setEnabled(PreprocessPanel.this.getInstances() != null);
                Capabilities currentCapabilitiesFilter = PreprocessPanel.this.m_FilterEditor.getCapabilitiesFilter();
                Filter filter = (Filter)PreprocessPanel.this.m_FilterEditor.getValue();
                Capabilities currentFilterCapabilities = null;
                if (filter != null && currentCapabilitiesFilter != null && filter instanceof CapabilitiesHandler && !(currentFilterCapabilities = filter.getCapabilities()).supportsMaybe(currentCapabilitiesFilter) && !currentFilterCapabilities.supports(currentCapabilitiesFilter)) {
                    PreprocessPanel.this.m_ApplyFilterBut.setEnabled(false);
                }
            }
        });
        Messages.getInstance();
        this.m_OpenFileBut.setToolTipText(Messages.getString("PreprocessPanel_OpenFileBut_SetToolTipText_Text"));
        Messages.getInstance();
        this.m_OpenURLBut.setToolTipText(Messages.getString("PreprocessPanel_OpenURLBut_SetToolTipText_Text"));
        Messages.getInstance();
        this.m_OpenDBBut.setToolTipText(Messages.getString("PreprocessPanel_OpenDBBut_SetToolTipText_Text"));
        Messages.getInstance();
        this.m_GenerateBut.setToolTipText(Messages.getString("PreprocessPanel_GenerateBut_SetToolTipText_Text"));
        Messages.getInstance();
        this.m_UndoBut.setToolTipText(Messages.getString("PreprocessPanel_UndoBut_SetToolTipText_Text"));
        this.m_UndoBut.setEnabled(ExplorerDefaults.get("enableUndo", "true").equalsIgnoreCase("true"));
        if (!this.m_UndoBut.isEnabled()) {
            this.m_UndoBut.setToolTipText("Undo is disabled - see weka.gui.explorer.Explorer.props to enable");
        }
        Messages.getInstance();
        this.m_EditBut.setToolTipText(Messages.getString("PreprocessPanel_EditBut_SetToolTipText_Text"));
        Messages.getInstance();
        this.m_SaveBut.setToolTipText(Messages.getString("PreprocessPanel_SaveBut_SetToolTipText_Text"));
        Messages.getInstance();
        this.m_ApplyFilterBut.setToolTipText(Messages.getString("PreprocessPanel_ApplyFilterBut_SetToolTipText_Text"));
        this.m_FileChooser.setFileSelectionMode(2);
        this.m_OpenURLBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreprocessPanel.this.setInstancesFromURLQ();
            }
        });
        this.m_OpenDBBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SqlViewerDialog dialog = new SqlViewerDialog(null);
                dialog.setVisible(true);
                if (dialog.getReturnValue() == 0) {
                    PreprocessPanel.this.setInstancesFromDBQ(dialog.getURL(), dialog.getUser(), dialog.getPassword(), dialog.getQuery());
                }
            }
        });
        this.m_OpenFileBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreprocessPanel.this.setInstancesFromFileQ();
            }
        });
        this.m_GenerateBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreprocessPanel.this.generateInstances();
            }
        });
        this.m_UndoBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreprocessPanel.this.undo();
            }
        });
        this.m_EditBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreprocessPanel.this.edit();
            }
        });
        this.m_SaveBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreprocessPanel.this.saveWorkingInstancesToFileQ();
            }
        });
        this.m_ApplyFilterBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreprocessPanel.this.applyFilter((Filter)PreprocessPanel.this.m_FilterEditor.getValue());
            }
        });
        this.m_AttPanel.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ListSelectionModel lm = (ListSelectionModel)e.getSource();
                    for (int i = e.getFirstIndex(); i <= e.getLastIndex(); ++i) {
                        if (!lm.isSelectedIndex(i)) continue;
                        PreprocessPanel.this.m_AttSummaryPanel.setAttribute(i);
                        PreprocessPanel.this.m_AttVisualizePanel.setAttribute(i);
                        break;
                    }
                }
            }
        });
        Messages.getInstance();
        this.m_InstSummaryPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("PreprocessPanel_InstSummaryPanel_BorderFactoryCreateTitledBorder_Text")));
        JPanel attStuffHolderPanel = new JPanel();
        Messages.getInstance();
        attStuffHolderPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("PreprocessPanel_AttStuffHolderPanel_BorderFactoryCreateTitledBorder_Text")));
        attStuffHolderPanel.setLayout(new BorderLayout());
        attStuffHolderPanel.add((Component)this.m_AttPanel, "Center");
        this.m_RemoveButton.setEnabled(false);
        Messages.getInstance();
        this.m_RemoveButton.setToolTipText(Messages.getString("PreprocessPanel_RemoveButton_SetToolTipText_Text"));
        this.m_RemoveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Remove r = new Remove();
                    int[] selected = PreprocessPanel.this.m_AttPanel.getSelectedAttributes();
                    if (selected.length == 0) {
                        return;
                    }
                    if (selected.length == PreprocessPanel.this.m_Instances.numAttributes()) {
                        Messages.getInstance();
                        String string = Messages.getString("PreprocessPanel_JOptionPaneShowMessageDialog_Text_First");
                        Messages.getInstance();
                        JOptionPane.showMessageDialog(PreprocessPanel.this, string, Messages.getString("PreprocessPanel_JOptionPaneShowMessageDialog_Text_Second"), 0);
                        Logger logger = PreprocessPanel.this.m_Log;
                        Messages.getInstance();
                        logger.logMessage(Messages.getString("PreprocessPanel_Log_LogMessage_Text_First"));
                        Logger logger2 = PreprocessPanel.this.m_Log;
                        Messages.getInstance();
                        logger2.statusMessage(Messages.getString("PreprocessPanel_Log_StatusMessage_Text_First"));
                        return;
                    }
                    r.setAttributeIndicesArray(selected);
                    PreprocessPanel.this.applyFilter(r);
                }
                catch (Exception ex) {
                    if (PreprocessPanel.this.m_Log instanceof TaskLogger) {
                        ((TaskLogger)((Object)PreprocessPanel.this.m_Log)).taskFinished();
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    Messages.getInstance();
                    String string = stringBuilder.append(Messages.getString("PreprocessPanel_JOptionPaneShowMessageDialog_Text_Third")).append(ex.getMessage()).toString();
                    Messages.getInstance();
                    JOptionPane.showMessageDialog(PreprocessPanel.this, string, Messages.getString("PreprocessPanel_JOptionPaneShowMessageDialog_Text_Fourth"), 0);
                    Logger logger = PreprocessPanel.this.m_Log;
                    StringBuilder stringBuilder2 = new StringBuilder();
                    Messages.getInstance();
                    logger.logMessage(stringBuilder2.append(Messages.getString("PreprocessPanel_Log_LogMessage_Text_Second")).append(ex.getMessage()).toString());
                    Logger logger3 = PreprocessPanel.this.m_Log;
                    Messages.getInstance();
                    logger3.statusMessage(Messages.getString("PreprocessPanel_Log_StatusMessage_Text_Second"));
                }
            }
        });
        JPanel p1 = new JPanel();
        p1.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        p1.setLayout(new BorderLayout());
        p1.add((Component)this.m_RemoveButton, "Center");
        attStuffHolderPanel.add((Component)p1, "South");
        Messages.getInstance();
        this.m_AttSummaryPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("PreprocessPanel_AttSummaryPanel_BorderFactoryCreateTitledBorder_Text")));
        this.m_UndoBut.setEnabled(false);
        this.m_EditBut.setEnabled(false);
        this.m_SaveBut.setEnabled(false);
        this.m_ApplyFilterBut.setEnabled(false);
        JPanel buttons = new JPanel();
        buttons.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        buttons.setLayout(new GridLayout(1, 6, 5, 5));
        buttons.add(this.m_OpenFileBut);
        buttons.add(this.m_OpenURLBut);
        buttons.add(this.m_OpenDBBut);
        buttons.add(this.m_GenerateBut);
        buttons.add(this.m_UndoBut);
        buttons.add(this.m_EditBut);
        buttons.add(this.m_SaveBut);
        JPanel attInfo = new JPanel();
        attInfo.setLayout(new BorderLayout());
        attInfo.add((Component)attStuffHolderPanel, "Center");
        JPanel filter = new JPanel();
        Messages.getInstance();
        filter.setBorder(BorderFactory.createTitledBorder(Messages.getString("PreprocessPanel_Filter_BorderFactoryCreateTitledBorder_Text")));
        filter.setLayout(new BorderLayout());
        filter.add((Component)this.m_FilterPanel, "Center");
        filter.add((Component)this.m_ApplyFilterBut, "East");
        JPanel attVis = new JPanel();
        attVis.setLayout(new GridLayout(2, 1));
        attVis.add(this.m_AttSummaryPanel);
        JComboBox colorBox = this.m_AttVisualizePanel.getColorBox();
        Messages.getInstance();
        colorBox.setToolTipText(Messages.getString("PreprocessPanel_ColorBox_SetToolTipText_Text"));
        colorBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1) {
                    PreprocessPanel.this.updateCapabilitiesFilter(PreprocessPanel.this.m_FilterEditor.getCapabilitiesFilter());
                }
            }
        });
        Messages.getInstance();
        final JButton visAllBut = new JButton(Messages.getString("PreprocessPanel_VisAllBut_JButton_Text"));
        visAllBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (PreprocessPanel.this.m_Instances != null) {
                    try {
                        AttributeSummarizer as = new AttributeSummarizer();
                        as.setColoringIndex(PreprocessPanel.this.m_AttVisualizePanel.getColoringIndex());
                        as.setInstances(PreprocessPanel.this.m_Instances);
                        final JFrame jf = new JFrame();
                        jf.getContentPane().setLayout(new BorderLayout());
                        jf.getContentPane().add((Component)as, "Center");
                        jf.addWindowListener(new WindowAdapter(){

                            public void windowClosing(WindowEvent e) {
                                visAllBut.setEnabled(true);
                                jf.dispose();
                            }
                        });
                        jf.setSize(830, 600);
                        jf.setVisible(true);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        JPanel histoHolder = new JPanel();
        histoHolder.setLayout(new BorderLayout());
        histoHolder.add((Component)this.m_AttVisualizePanel, "Center");
        JPanel histoControls = new JPanel();
        histoControls.setLayout(new BorderLayout());
        histoControls.add((Component)colorBox, "Center");
        histoControls.add((Component)visAllBut, "East");
        histoHolder.add((Component)histoControls, "North");
        attVis.add(histoHolder);
        JPanel lhs = new JPanel();
        lhs.setLayout(new BorderLayout());
        lhs.add((Component)this.m_InstSummaryPanel, "North");
        lhs.add((Component)attInfo, "Center");
        JPanel rhs = new JPanel();
        rhs.setLayout(new BorderLayout());
        rhs.add((Component)attVis, "Center");
        JPanel relation = new JPanel();
        relation.setLayout(new GridLayout(1, 2));
        relation.add(lhs);
        relation.add(rhs);
        JPanel middle = new JPanel();
        middle.setLayout(new BorderLayout());
        middle.add((Component)filter, "North");
        middle.add((Component)relation, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)buttons, "North");
        this.add((Component)middle, "Center");
    }

    public void setLog(Logger newLog) {
        this.m_Log = newLog;
    }

    public void setInstances(Instances inst) {
        this.m_Instances = inst;
        try {
            Runnable r = new Runnable(){

                public void run() {
                    PreprocessPanel.this.m_InstSummaryPanel.setInstances(PreprocessPanel.this.m_Instances);
                    PreprocessPanel.this.m_AttPanel.setInstances(PreprocessPanel.this.m_Instances);
                    PreprocessPanel.this.m_RemoveButton.setEnabled(true);
                    PreprocessPanel.this.m_AttSummaryPanel.setInstances(PreprocessPanel.this.m_Instances);
                    PreprocessPanel.this.m_AttVisualizePanel.setInstances(PreprocessPanel.this.m_Instances);
                    PreprocessPanel.this.m_AttPanel.getSelectionModel().setSelectionInterval(0, 0);
                    PreprocessPanel.this.m_AttSummaryPanel.setAttribute(0);
                    PreprocessPanel.this.m_AttVisualizePanel.setAttribute(0);
                    PreprocessPanel.this.m_ApplyFilterBut.setEnabled(true);
                    PreprocessPanel.this.m_SaveBut.setEnabled(true);
                    PreprocessPanel.this.m_EditBut.setEnabled(true);
                    Logger logger = PreprocessPanel.this.m_Log;
                    Messages.getInstance();
                    logger.statusMessage(Messages.getString("PreprocessPanel_SetInstances_Run_Log_StatusMessage_Text_First"));
                    PreprocessPanel.this.m_Support.firePropertyChange("", null, null);
                    try {
                        PreprocessPanel.this.getExplorer().notifyCapabilitiesFilterListener(null);
                        int oldIndex = PreprocessPanel.this.m_Instances.classIndex();
                        PreprocessPanel.this.m_Instances.setClassIndex(PreprocessPanel.this.m_AttVisualizePanel.getColorBox().getSelectedIndex() - 1);
                        if (ExplorerDefaults.getInitGenericObjectEditorFilter()) {
                            PreprocessPanel.this.getExplorer().notifyCapabilitiesFilterListener(Capabilities.forInstances(PreprocessPanel.this.m_Instances));
                        } else {
                            PreprocessPanel.this.getExplorer().notifyCapabilitiesFilterListener(Capabilities.forInstances(new Instances(PreprocessPanel.this.m_Instances, 0)));
                        }
                        PreprocessPanel.this.m_Instances.setClassIndex(oldIndex);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        PreprocessPanel.this.m_Log.logMessage(e.toString());
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeAndWait(r);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Instances getInstances() {
        return this.m_Instances;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.m_Support.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.m_Support.removePropertyChangeListener(l);
    }

    protected void applyFilter(final Filter filter) {
        if (this.m_IOThread == null) {
            this.m_IOThread = new Thread(){

                public void run() {
                    try {
                        if (filter != null) {
                            if (PreprocessPanel.this.m_Log instanceof TaskLogger) {
                                ((TaskLogger)((Object)PreprocessPanel.this.m_Log)).taskStarted();
                            }
                            Logger logger = PreprocessPanel.this.m_Log;
                            StringBuilder stringBuilder = new StringBuilder();
                            Messages.getInstance();
                            logger.statusMessage(stringBuilder.append(Messages.getString("PreprocessPanel_ApplyFilter_Run_Log_StatusMessage_Text_First")).append(filter.getClass().getName()).toString());
                            String cmd = filter.getClass().getName();
                            if (filter instanceof OptionHandler) {
                                cmd = cmd + " " + Utils.joinOptions(((OptionHandler)((Object)filter)).getOptions());
                            }
                            Logger logger2 = PreprocessPanel.this.m_Log;
                            StringBuilder stringBuilder2 = new StringBuilder();
                            Messages.getInstance();
                            logger2.logMessage(stringBuilder2.append(Messages.getString("PreprocessPanel_ApplyFilter_Run_Log_LogMessage_Text_First")).append(cmd).toString());
                            int classIndex = PreprocessPanel.this.m_AttVisualizePanel.getColoringIndex();
                            if (classIndex < 0 && filter instanceof SupervisedFilter) {
                                Messages.getInstance();
                                throw new IllegalArgumentException(Messages.getString("PreprocessPanel_ApplyFilter_Run_IllegalArgumentException_Text"));
                            }
                            Instances copy = new Instances(PreprocessPanel.this.m_Instances);
                            copy.setClassIndex(classIndex);
                            filter.setInputFormat(copy);
                            Instances newInstances = Filter.useFilter(copy, filter);
                            if (newInstances == null || newInstances.numAttributes() < 1) {
                                Messages.getInstance();
                                throw new Exception(Messages.getString("PreprocessPanel_ApplyFilter_Run_Exception_Text"));
                            }
                            Logger logger3 = PreprocessPanel.this.m_Log;
                            Messages.getInstance();
                            logger3.statusMessage(Messages.getString("PreprocessPanel_ApplyFilter_Run_Log_StatusMessage_Text_Second"));
                            PreprocessPanel.this.addUndoPoint();
                            PreprocessPanel.this.m_AttVisualizePanel.setColoringIndex(copy.classIndex());
                            if (PreprocessPanel.this.m_Instances.classIndex() < 0) {
                                newInstances.setClassIndex(-1);
                            }
                            PreprocessPanel.this.m_Instances = newInstances;
                            PreprocessPanel.this.setInstances(PreprocessPanel.this.m_Instances);
                            if (PreprocessPanel.this.m_Log instanceof TaskLogger) {
                                ((TaskLogger)((Object)PreprocessPanel.this.m_Log)).taskFinished();
                            }
                        }
                    }
                    catch (Exception ex) {
                        if (PreprocessPanel.this.m_Log instanceof TaskLogger) {
                            ((TaskLogger)((Object)PreprocessPanel.this.m_Log)).taskFinished();
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        Messages.getInstance();
                        String string = stringBuilder.append(Messages.getString("PreprocessPanel_ApplyFilter_Run_JOptionPaneShowMessageDialog_Text_First")).append(ex.getMessage()).toString();
                        Messages.getInstance();
                        JOptionPane.showMessageDialog(PreprocessPanel.this, string, Messages.getString("PreprocessPanel_ApplyFilter_Run_JOptionPaneShowMessageDialog_Text_Second"), 0);
                        Logger logger = PreprocessPanel.this.m_Log;
                        StringBuilder stringBuilder3 = new StringBuilder();
                        Messages.getInstance();
                        logger.logMessage(stringBuilder3.append(Messages.getString("PreprocessPanel_ApplyFilter_Run_Log_LogMessage_Text_Second")).append(ex.getMessage()).toString());
                        Logger logger4 = PreprocessPanel.this.m_Log;
                        Messages.getInstance();
                        logger4.statusMessage(Messages.getString("PreprocessPanel_ApplyFilter_Run_Log_StatusMessage_Text_Third"));
                    }
                    PreprocessPanel.this.m_IOThread = null;
                }
            };
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        } else {
            Messages.getInstance();
            String string = Messages.getString("PreprocessPanel_ApplyFilter_Run_JOptionPaneShowMessageDialog_Text_Third");
            Messages.getInstance();
            JOptionPane.showMessageDialog(this, string, Messages.getString("PreprocessPanel_ApplyFilter_Run_JOptionPaneShowMessageDialog_Text_Fourth"), 2);
        }
    }

    public void saveWorkingInstancesToFileQ() {
        if (this.m_IOThread == null) {
            this.m_FileChooser.setCapabilitiesFilter(this.m_FilterEditor.getCapabilitiesFilter());
            this.m_FileChooser.setAcceptAllFileFilterUsed(false);
            int returnVal = this.m_FileChooser.showSaveDialog(this);
            if (returnVal == 0) {
                Instances inst = new Instances(this.m_Instances);
                inst.setClassIndex(this.m_AttVisualizePanel.getColoringIndex());
                this.saveInstancesToFile(this.m_FileChooser.getSaver(), inst);
            }
            FileFilter temp = this.m_FileChooser.getFileFilter();
            this.m_FileChooser.setAcceptAllFileFilterUsed(true);
            this.m_FileChooser.setFileFilter(temp);
        } else {
            Messages.getInstance();
            String string = Messages.getString("PreprocessPanel_SaveWorkingInstancesToFileQ_JOptionPaneShowMessageDialog_Text_First");
            Messages.getInstance();
            JOptionPane.showMessageDialog(this, string, Messages.getString("PreprocessPanel_SaveWorkingInstancesToFileQ_JOptionPaneShowMessageDialog_Text_Second"), 2);
        }
    }

    public void saveInstancesToFile(final AbstractFileSaver saver, final Instances inst) {
        if (this.m_IOThread == null) {
            this.m_IOThread = new Thread(){

                public void run() {
                    try {
                        Logger logger = PreprocessPanel.this.m_Log;
                        Messages.getInstance();
                        logger.statusMessage(Messages.getString("PreprocessPanel_SaveInstancesToFile_Run_Log_StatusMessage_Text_First"));
                        saver.setInstances(inst);
                        saver.writeBatch();
                        Logger logger2 = PreprocessPanel.this.m_Log;
                        Messages.getInstance();
                        logger2.statusMessage(Messages.getString("PreprocessPanel_SaveInstancesToFile_Run_Log_StatusMessage_Text_Second"));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        PreprocessPanel.this.m_Log.logMessage(ex.getMessage());
                    }
                    PreprocessPanel.this.m_IOThread = null;
                }
            };
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        } else {
            Messages.getInstance();
            String string = Messages.getString("PreprocessPanel_SaveInstancesToFile_Run_JOptionPaneShowMessageDialog_Text_First");
            Messages.getInstance();
            JOptionPane.showMessageDialog(this, string, Messages.getString("PreprocessPanel_SaveInstancesToFile_Run_JOptionPaneShowMessageDialog_Text_Second"), 2);
        }
    }

    public void setInstancesFromFileQ() {
        if (this.m_IOThread == null) {
            int returnVal = this.m_FileChooser.showOpenDialog(this);
            if (returnVal == 0) {
                try {
                    this.addUndoPoint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.m_FileChooser.getLoader() == null) {
                    Messages.getInstance();
                    String string = Messages.getString("PreprocessPanel_SetInstancesFromFileQ_JOptionPaneShowMessageDialog_Text_First");
                    Messages.getInstance();
                    JOptionPane.showMessageDialog(this, string, Messages.getString("PreprocessPanel_SetInstancesFromFileQ_JOptionPaneShowMessageDialog_Text_Second"), 0);
                    this.converterQuery(this.m_FileChooser.getSelectedFile());
                } else {
                    this.setInstancesFromFile(this.m_FileChooser.getLoader());
                }
            }
        } else {
            Messages.getInstance();
            String string = Messages.getString("PreprocessPanel_SetInstancesFromFileQ_JOptionPaneShowMessageDialog_Text_Third");
            Messages.getInstance();
            JOptionPane.showMessageDialog(this, string, Messages.getString("PreprocessPanel_SetInstancesFromFileQ_JOptionPaneShowMessageDialog_Text_Fourth"), 2);
        }
    }

    public void setInstancesFromDBQ(String url, String user, String pw, String query) {
        if (this.m_IOThread == null) {
            try {
                InstanceQuery InstQ = new InstanceQuery();
                InstQ.setDatabaseURL(url);
                InstQ.setUsername(user);
                InstQ.setPassword(pw);
                InstQ.setQuery(query);
                if (InstQ.isConnected()) {
                    InstQ.disconnectFromDatabase();
                }
                InstQ.connectToDatabase();
                try {
                    this.addUndoPoint();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                this.setInstancesFromDB(InstQ);
            }
            catch (Exception ex) {
                StringBuilder stringBuilder = new StringBuilder();
                Messages.getInstance();
                String string = stringBuilder.append(Messages.getString("PreprocessPanel_SetInstancesFromDBQ_JOptionPaneShowMessageDialog_Text_First")).append(ex.getMessage()).toString();
                Messages.getInstance();
                JOptionPane.showMessageDialog(this, string, Messages.getString("PreprocessPanel_SetInstancesFromDBQ_JOptionPaneShowMessageDialog_Text_Second"), 0);
            }
        } else {
            Messages.getInstance();
            String string = Messages.getString("PreprocessPanel_SetInstancesFromDBQ_JOptionPaneShowMessageDialog_Text_Third");
            Messages.getInstance();
            JOptionPane.showMessageDialog(this, string, Messages.getString("PreprocessPanel_SetInstancesFromDBQ_JOptionPaneShowMessageDialog_Text_Fourth"), 2);
        }
    }

    public void setInstancesFromURLQ() {
        block6: {
            if (this.m_IOThread == null) {
                try {
                    Messages.getInstance();
                    String string = Messages.getString("PreprocessPanel_SetInstancesFromURLQ_JOptionPaneShowMessageDialog_Text_First");
                    Messages.getInstance();
                    String urlName = (String)JOptionPane.showInputDialog(this, string, Messages.getString("PreprocessPanel_SetInstancesFromURLQ_JOptionPaneShowMessageDialog_Text_Second"), 3, null, null, this.m_LastURL);
                    if (urlName == null) break block6;
                    this.m_LastURL = urlName;
                    URL url = new URL(urlName);
                    try {
                        this.addUndoPoint();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.setInstancesFromURL(url);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    StringBuilder stringBuilder = new StringBuilder();
                    Messages.getInstance();
                    String string = stringBuilder.append(Messages.getString("PreprocessPanel_SetInstancesFromURLQ_JOptionPaneShowMessageDialog_Text_Third")).append(ex.getMessage()).toString();
                    Messages.getInstance();
                    JOptionPane.showMessageDialog(this, string, Messages.getString("PreprocessPanel_SetInstancesFromURLQ_JOptionPaneShowMessageDialog_Text_Fourth"), 0);
                }
            } else {
                Messages.getInstance();
                String string = Messages.getString("PreprocessPanel_SetInstancesFromURLQ_JOptionPaneShowMessageDialog_Text_Fifth");
                Messages.getInstance();
                JOptionPane.showMessageDialog(this, string, Messages.getString("PreprocessPanel_SetInstancesFromURLQ_JOptionPaneShowMessageDialog_Text_Sixth"), 2);
            }
        }
    }

    public void generateInstances() {
        if (this.m_IOThread == null) {
            this.m_IOThread = new Thread(){

                public void run() {
                    try {
                        final DataGeneratorPanel generatorPanel = new DataGeneratorPanel();
                        final JDialog dialog = new JDialog();
                        Messages.getInstance();
                        JButton generateButton = new JButton(Messages.getString("PreprocessPanel_GenerateInstances_Run_GenerateButton_JButton_Text"));
                        Messages.getInstance();
                        final JCheckBox showOutputCheckBox = new JCheckBox(Messages.getString("PreprocessPanel_GenerateInstances_Run_ShowOutputCheckBox_JCheckBox_Text"));
                        showOutputCheckBox.setMnemonic('S');
                        generatorPanel.setLog(PreprocessPanel.this.m_Log);
                        generatorPanel.setGenerator(PreprocessPanel.this.m_DataGenerator);
                        generatorPanel.setPreferredSize(new Dimension(300, (int)generatorPanel.getPreferredSize().getHeight()));
                        generateButton.setMnemonic('G');
                        Messages.getInstance();
                        generateButton.setToolTipText(Messages.getString("PreprocessPanel_GenerateInstances_Run_GenerateButton_SetToolTipText_Text"));
                        generateButton.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent evt) {
                                boolean generated;
                                generatorPanel.execute();
                                boolean bl = generated = generatorPanel.getInstances() != null;
                                if (generated) {
                                    PreprocessPanel.this.setInstances(generatorPanel.getInstances());
                                }
                                dialog.dispose();
                                PreprocessPanel.this.m_DataGenerator = generatorPanel.getGenerator();
                                if (generated && showOutputCheckBox.isSelected()) {
                                    PreprocessPanel.this.showGeneratedInstances(generatorPanel.getOutput());
                                }
                            }
                        });
                        Messages.getInstance();
                        dialog.setTitle(Messages.getString("PreprocessPanel_GenerateInstances_Run_Dialog_Text"));
                        dialog.getContentPane().add((Component)generatorPanel, "Center");
                        dialog.getContentPane().add((Component)generateButton, "East");
                        dialog.getContentPane().add((Component)showOutputCheckBox, "South");
                        dialog.pack();
                        dialog.setVisible(true);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        PreprocessPanel.this.m_Log.logMessage(ex.getMessage());
                    }
                    PreprocessPanel.this.m_IOThread = null;
                }
            };
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        } else {
            Messages.getInstance();
            String string = Messages.getString("PreprocessPanel_GenerateInstances_Run_JOptionPaneShowMessageDialog_Text_First");
            Messages.getInstance();
            JOptionPane.showMessageDialog(this, string, Messages.getString("PreprocessPanel_GenerateInstances_Run_JOptionPaneShowMessageDialog_Text_Second"), 2);
        }
    }

    protected void showGeneratedInstances(String data) {
        final JDialog dialog = new JDialog();
        Messages.getInstance();
        JButton saveButton = new JButton(Messages.getString("PreprocessPanel_ShowGeneratedInstances_SaveButton_JButton_Text"));
        Messages.getInstance();
        JButton closeButton = new JButton(Messages.getString("PreprocessPanel_ShowGeneratedInstances_CloseButton_JButton_Text"));
        final JTextArea textData = new JTextArea(data);
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(2));
        textData.setEditable(false);
        textData.setFont(new Font("Monospaced", 0, textData.getFont().getSize()));
        saveButton.setMnemonic('S');
        Messages.getInstance();
        saveButton.setToolTipText(Messages.getString("PreprocessPanel_ShowGeneratedInstances_SaveButton_SetToolTipText_Text"));
        saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JFileChooser filechooser = new JFileChooser();
                int result = filechooser.showSaveDialog(dialog);
                if (result == 0) {
                    try {
                        BufferedWriter writer = new BufferedWriter(new FileWriter(filechooser.getSelectedFile()));
                        writer.write(textData.getText());
                        writer.flush();
                        writer.close();
                        StringBuilder stringBuilder = new StringBuilder();
                        Messages.getInstance();
                        StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("PreprocessPanel_ShowGeneratedInstances_SaveButton_JOptionPaneShowMessageDialog_Text_First")).append(filechooser.getSelectedFile());
                        Messages.getInstance();
                        String string = stringBuilder2.append(Messages.getString("PreprocessPanel_ShowGeneratedInstances_SaveButton_JOptionPaneShowMessageDialog_Text_Second")).toString();
                        Messages.getInstance();
                        JOptionPane.showMessageDialog(dialog, string, Messages.getString("PreprocessPanel_ShowGeneratedInstances_SaveButton_JOptionPaneShowMessageDialog_Text_Third"), 1);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    dialog.dispose();
                }
            }
        });
        closeButton.setMnemonic('C');
        Messages.getInstance();
        closeButton.setToolTipText(Messages.getString("PreprocessPanel_ShowGeneratedInstances_CloseButton_SetToolTipText_Text"));
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                dialog.dispose();
            }
        });
        panel.add(saveButton);
        panel.add(closeButton);
        Messages.getInstance();
        dialog.setTitle(Messages.getString("PreprocessPanel_ShowGeneratedInstances_Dialog_SetToolTipText_Text"));
        dialog.getContentPane().add((Component)new JScrollPane(textData), "Center");
        dialog.getContentPane().add((Component)panel, "South");
        dialog.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int width = (double)dialog.getWidth() > screen.getWidth() * 0.8 ? (int)(screen.getWidth() * 0.8) : dialog.getWidth();
        int height = (double)dialog.getHeight() > screen.getHeight() * 0.8 ? (int)(screen.getHeight() * 0.8) : dialog.getHeight();
        dialog.setSize(width, height);
        dialog.setVisible(true);
    }

    private void converterQuery(final File f) {
        final GenericObjectEditor convEd = new GenericObjectEditor(true);
        try {
            convEd.setClassType(Loader.class);
            convEd.setValue(new CSVLoader());
            ((GenericObjectEditor.GOEPanel)convEd.getCustomEditor()).addOkListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PreprocessPanel.this.tryConverter((Loader)convEd.getValue(), f);
                }
            });
        }
        catch (Exception ex) {
            // empty catch block
        }
        PropertyDialog pd = PropertyDialog.getParentDialog(this) != null ? new PropertyDialog(PropertyDialog.getParentDialog(this), (PropertyEditor)convEd, 100, 100) : new PropertyDialog(PropertyDialog.getParentFrame(this), (PropertyEditor)convEd, 100, 100);
        pd.setVisible(true);
    }

    private void tryConverter(final Loader cnv, final File f) {
        if (this.m_IOThread == null) {
            this.m_IOThread = new Thread(){

                public void run() {
                    try {
                        cnv.setSource(f);
                        Instances inst = cnv.getDataSet();
                        PreprocessPanel.this.setInstances(inst);
                    }
                    catch (Exception ex) {
                        Logger logger = PreprocessPanel.this.m_Log;
                        StringBuilder stringBuilder = new StringBuilder().append(cnv.getClass().getName());
                        Messages.getInstance();
                        logger.statusMessage(stringBuilder.append(Messages.getString("PreprocessPanel_TryConverter_Log_StatusMessage_Text")).append(f.getName()).toString());
                        StringBuilder stringBuilder2 = new StringBuilder().append(cnv.getClass().getName());
                        Messages.getInstance();
                        StringBuilder stringBuilder3 = stringBuilder2.append(Messages.getString("PreprocessPanel_TryConverter_JOptionPaneShowMessageDialog_Text_First")).append(f.getName());
                        Messages.getInstance();
                        StringBuilder stringBuilder4 = stringBuilder3.append(Messages.getString("PreprocessPanel_TryConverter_JOptionPaneShowMessageDialog_Text_Second"));
                        Messages.getInstance();
                        String string = stringBuilder4.append(Messages.getString("PreprocessPanel_TryConverter_JOptionPaneShowMessageDialog_Text_Third")).append(ex.getMessage()).toString();
                        Messages.getInstance();
                        JOptionPane.showMessageDialog(PreprocessPanel.this, string, Messages.getString("PreprocessPanel_TryConverter_JOptionPaneShowMessageDialog_Text_Fourth"), 0);
                        PreprocessPanel.this.m_IOThread = null;
                        PreprocessPanel.this.converterQuery(f);
                    }
                    PreprocessPanel.this.m_IOThread = null;
                }
            };
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        }
    }

    public void setInstancesFromFile(final AbstractFileLoader loader) {
        if (this.m_IOThread == null) {
            this.m_IOThread = new Thread(){

                public void run() {
                    block2: {
                        try {
                            Logger logger = PreprocessPanel.this.m_Log;
                            Messages.getInstance();
                            logger.statusMessage(Messages.getString("PreprocessPanel_SetInstancesFromFile_Run_Log_StatusMessage_Text_First"));
                            Instances inst = loader.getDataSet();
                            PreprocessPanel.this.setInstances(inst);
                        }
                        catch (Exception ex) {
                            Logger logger = PreprocessPanel.this.m_Log;
                            StringBuilder stringBuilder = new StringBuilder();
                            Messages.getInstance();
                            StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("PreprocessPanel_SetInstancesFromFile_Run_Log_StatusMessage_Text_Second")).append(loader.retrieveFile());
                            Messages.getInstance();
                            StringBuilder stringBuilder3 = stringBuilder2.append(Messages.getString("PreprocessPanel_SetInstancesFromFile_Run_Log_StatusMessage_Text_Third")).append(loader.getFileDescription());
                            Messages.getInstance();
                            logger.statusMessage(stringBuilder3.append(Messages.getString("PreprocessPanel_SetInstancesFromFile_Run_Log_StatusMessage_Text_Fourth")).toString());
                            PreprocessPanel.this.m_IOThread = null;
                            StringBuilder stringBuilder4 = new StringBuilder();
                            Messages.getInstance();
                            StringBuilder stringBuilder5 = stringBuilder4.append(Messages.getString("PreprocessPanel_SetInstancesFromFile_Run_JOptionPaneShowOptionDialog_Text_First")).append(loader.retrieveFile());
                            Messages.getInstance();
                            StringBuilder stringBuilder6 = stringBuilder5.append(Messages.getString("PreprocessPanel_SetInstancesFromFile_Run_JOptionPaneShowOptionDialog_Text_Second")).append(loader.getFileDescription());
                            Messages.getInstance();
                            StringBuilder stringBuilder7 = stringBuilder6.append(Messages.getString("PreprocessPanel_SetInstancesFromFile_Run_JOptionPaneShowOptionDialog_Text_Third"));
                            Messages.getInstance();
                            String string = stringBuilder7.append(Messages.getString("PreprocessPanel_SetInstancesFromFile_Run_JOptionPaneShowOptionDialog_Text_Fourth")).append(ex.getMessage()).toString();
                            Messages.getInstance();
                            String string2 = Messages.getString("PreprocessPanel_SetInstancesFromFile_Run_JOptionPaneShowOptionDialog_Text_Fifth");
                            Object[] objectArray = new String[2];
                            Messages.getInstance();
                            objectArray[0] = Messages.getString("PreprocessPanel_SetInstancesFromFile_Run_JOptionPaneShowOptionDialog_Text_Sixth");
                            Messages.getInstance();
                            objectArray[1] = Messages.getString("PreprocessPanel_SetInstancesFromFile_Run_JOptionPaneShowOptionDialog_Text_Seventh");
                            if (JOptionPane.showOptionDialog(PreprocessPanel.this, string, string2, 0, 0, null, objectArray, null) != 1) break block2;
                            PreprocessPanel.this.converterQuery(loader.retrieveFile());
                        }
                    }
                    PreprocessPanel.this.m_IOThread = null;
                }
            };
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        } else {
            Messages.getInstance();
            String string = Messages.getString("PreprocessPanel_SetInstancesFromFile_Run_JOptionPaneShowOptionDialog_Text_Eigth");
            Messages.getInstance();
            JOptionPane.showMessageDialog(this, string, Messages.getString("PreprocessPanel_SetInstancesFromFile_Run_JOptionPaneShowOptionDialog_Text_Nineth"), 2);
        }
    }

    public void setInstancesFromDB(final InstanceQuery iq) {
        if (this.m_IOThread == null) {
            this.m_IOThread = new Thread(){

                public void run() {
                    try {
                        Logger logger = PreprocessPanel.this.m_Log;
                        Messages.getInstance();
                        logger.statusMessage(Messages.getString("PreprocessPanel_SetInstancesFromDB_Run_Log_StatusMessage_Text_First"));
                        final Instances i = iq.retrieveInstances();
                        SwingUtilities.invokeAndWait(new Runnable(){

                            public void run() {
                                PreprocessPanel.this.setInstances(new Instances(i));
                            }
                        });
                        iq.disconnectFromDatabase();
                    }
                    catch (Exception ex) {
                        Logger logger = PreprocessPanel.this.m_Log;
                        StringBuilder stringBuilder = new StringBuilder();
                        Messages.getInstance();
                        logger.statusMessage(stringBuilder.append(Messages.getString("PreprocessPanel_SetInstancesFromDB_Run_Log_StatusMessage_Text_Second")).append(PreprocessPanel.this.m_SQLQ).toString());
                        StringBuilder stringBuilder2 = new StringBuilder();
                        Messages.getInstance();
                        String string = stringBuilder2.append(Messages.getString("PreprocessPanel_SetInstancesFromDB_Run_JOptionPaneShowMessageDialog_Text_First")).append(ex.getMessage()).toString();
                        Messages.getInstance();
                        JOptionPane.showMessageDialog(PreprocessPanel.this, string, Messages.getString("PreprocessPanel_SetInstancesFromDB_Run_JOptionPaneShowMessageDialog_Text_Second"), 0);
                    }
                    PreprocessPanel.this.m_IOThread = null;
                }
            };
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        } else {
            Messages.getInstance();
            String string = Messages.getString("PreprocessPanel_SetInstancesFromDB_Run_JOptionPaneShowMessageDialog_Text_Third");
            Messages.getInstance();
            JOptionPane.showMessageDialog(this, string, Messages.getString("PreprocessPanel_SetInstancesFromDB_Run_JOptionPaneShowMessageDialog_Text_Fourth"), 2);
        }
    }

    public void setInstancesFromURL(final URL u) {
        if (this.m_IOThread == null) {
            this.m_IOThread = new Thread(){

                public void run() {
                    try {
                        Logger logger = PreprocessPanel.this.m_Log;
                        Messages.getInstance();
                        logger.statusMessage(Messages.getString("PreprocessPanel_SetInstancesFromURL_Run_Log_StatusMessage_Text_First"));
                        AbstractFileLoader loader = ConverterUtils.getURLLoaderForFile(u.toString());
                        if (loader == null) {
                            StringBuilder stringBuilder = new StringBuilder();
                            Messages.getInstance();
                            throw new Exception(stringBuilder.append(Messages.getString("PreprocessPanel_SetInstancesFromURL_Run_Exception_Text_First")).append(u).toString());
                        }
                        ((URLSourcedLoader)((Object)loader)).setURL(u.toString());
                        PreprocessPanel.this.setInstances(loader.getDataSet());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        Logger logger = PreprocessPanel.this.m_Log;
                        StringBuilder stringBuilder = new StringBuilder();
                        Messages.getInstance();
                        logger.statusMessage(stringBuilder.append(Messages.getString("PreprocessPanel_SetInstancesFromURL_Run_Log_StatusMessage_Text_Second")).append(u).toString());
                        StringBuilder stringBuilder2 = new StringBuilder();
                        Messages.getInstance();
                        StringBuilder stringBuilder3 = stringBuilder2.append(Messages.getString("PreprocessPanel_SetInstancesFromDB_Run_JOptionPaneShowMessageDialog_Text_Fifth")).append(u);
                        Messages.getInstance();
                        String string = stringBuilder3.append(Messages.getString("PreprocessPanel_SetInstancesFromDB_Run_JOptionPaneShowMessageDialog_Text_Sixth")).append(ex.getMessage()).toString();
                        Messages.getInstance();
                        JOptionPane.showMessageDialog(PreprocessPanel.this, string, Messages.getString("PreprocessPanel_SetInstancesFromDB_Run_JOptionPaneShowMessageDialog_Text_Seventh"), 0);
                    }
                    PreprocessPanel.this.m_IOThread = null;
                }
            };
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        } else {
            Messages.getInstance();
            String string = Messages.getString("PreprocessPanel_SetInstancesFromDB_Run_JOptionPaneShowMessageDialog_Text_Eighth");
            Messages.getInstance();
            JOptionPane.showMessageDialog(this, string, Messages.getString("PreprocessPanel_SetInstancesFromDB_Run_JOptionPaneShowMessageDialog_Text_Nineth"), 2);
        }
    }

    public void addUndoPoint() throws Exception {
        if (!ExplorerDefaults.get("enableUndo", "true").equalsIgnoreCase("true")) {
            return;
        }
        if (this.m_Instances != null) {
            File tempFile = File.createTempFile("weka", SerializedInstancesLoader.FILE_EXTENSION);
            tempFile.deleteOnExit();
            if (!ExplorerDefaults.get("undoDirectory", "%t").equalsIgnoreCase("%t")) {
                String dir = ExplorerDefaults.get("undoDirectory", "%t");
                File undoDir = new File(dir);
                if (undoDir.exists()) {
                    String fileName = tempFile.getName();
                    File newFile = new File(dir + File.separator + fileName);
                    if (undoDir.canWrite()) {
                        newFile.deleteOnExit();
                        tempFile = newFile;
                    } else {
                        System.err.println("Explorer: it doesn't look like we have permission to write to the user-specified undo directory '" + dir + "'");
                    }
                } else {
                    System.err.println("Explorer: user-specified undo directory '" + dir + "' does not exist!");
                }
            }
            ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(tempFile)));
            oos.writeObject(this.m_Instances);
            oos.flush();
            oos.close();
            if (this.m_tempUndoFiles[this.m_tempUndoIndex] != null) {
                this.m_tempUndoFiles[this.m_tempUndoIndex].delete();
            }
            this.m_tempUndoFiles[this.m_tempUndoIndex] = tempFile;
            if (++this.m_tempUndoIndex >= this.m_tempUndoFiles.length) {
                this.m_tempUndoIndex = 0;
            }
            this.m_UndoBut.setEnabled(true);
        }
    }

    public void undo() {
        int temp;
        if (--this.m_tempUndoIndex < 0) {
            this.m_tempUndoIndex = this.m_tempUndoFiles.length - 1;
        }
        if (this.m_tempUndoFiles[this.m_tempUndoIndex] != null) {
            AbstractFileLoader loader = ConverterUtils.getLoaderForFile(this.m_tempUndoFiles[this.m_tempUndoIndex]);
            try {
                loader.setFile(this.m_tempUndoFiles[this.m_tempUndoIndex]);
                this.setInstancesFromFile(loader);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.m_Log.logMessage(e.toString());
                StringBuilder stringBuilder = new StringBuilder();
                Messages.getInstance();
                String string = stringBuilder.append(Messages.getString("PreprocessPanel_Undo_JOptionPaneShowMessageDialog_Text_First")).append(e.toString()).toString();
                Messages.getInstance();
                JOptionPane.showMessageDialog(this, string, Messages.getString("PreprocessPanel_Undo_JOptionPaneShowMessageDialog_Text_Second"), 0);
            }
            this.m_tempUndoFiles[this.m_tempUndoIndex] = null;
        }
        if ((temp = this.m_tempUndoIndex - 1) < 0) {
            temp = this.m_tempUndoFiles.length - 1;
        }
        this.m_UndoBut.setEnabled(this.m_tempUndoFiles[temp] != null);
    }

    public void edit() {
        int classIndex = this.m_AttVisualizePanel.getColoringIndex();
        Instances copy = new Instances(this.m_Instances);
        copy.setClassIndex(classIndex);
        ViewerDialog dialog = new ViewerDialog(null);
        int result = dialog.showDialog(copy);
        if (result == 0) {
            try {
                this.addUndoPoint();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Instances newInstances = dialog.getInstances();
            if (this.m_Instances.classIndex() < 0) {
                newInstances.setClassIndex(-1);
            }
            this.setInstances(newInstances);
        }
    }

    public void setExplorer(Explorer parent) {
        this.m_Explorer = parent;
    }

    public Explorer getExplorer() {
        return this.m_Explorer;
    }

    protected void updateCapabilitiesFilter(Capabilities filter) {
        Capabilities filterClass;
        if (filter == null) {
            this.m_FilterEditor.setCapabilitiesFilter(new Capabilities(null));
            return;
        }
        Instances tempInst = !ExplorerDefaults.getInitGenericObjectEditorFilter() ? new Instances(this.m_Instances, 0) : new Instances(this.m_Instances);
        tempInst.setClassIndex(this.m_AttVisualizePanel.getColorBox().getSelectedIndex() - 1);
        try {
            filterClass = Capabilities.forInstances(tempInst);
        }
        catch (Exception e) {
            filterClass = new Capabilities(null);
        }
        this.m_FilterEditor.setCapabilitiesFilter(filterClass);
        this.m_ApplyFilterBut.setEnabled(true);
        Capabilities currentCapabilitiesFilter = this.m_FilterEditor.getCapabilitiesFilter();
        Filter currentFilter = (Filter)this.m_FilterEditor.getValue();
        Capabilities currentFilterCapabilities = null;
        if (currentFilter != null && currentCapabilitiesFilter != null && currentFilter instanceof CapabilitiesHandler && !(currentFilterCapabilities = currentFilter.getCapabilities()).supportsMaybe(currentCapabilitiesFilter) && !currentFilterCapabilities.supports(currentCapabilitiesFilter)) {
            this.m_ApplyFilterBut.setEnabled(false);
        }
    }

    public void capabilitiesFilterChanged(Explorer.CapabilitiesFilterChangeEvent e) {
        if (e.getFilter() == null) {
            this.updateCapabilitiesFilter(null);
        } else {
            this.updateCapabilitiesFilter((Capabilities)e.getFilter().clone());
        }
    }

    public String getTabTitle() {
        Messages.getInstance();
        return Messages.getString("PreprocessPanel_GetTitle_Text");
    }

    public String getTabTitleToolTip() {
        Messages.getInstance();
        return Messages.getString("PreprocessPanel_GetTabTitleToolTip_Text");
    }

    public static void main(String[] args) {
        try {
            Messages.getInstance();
            final JFrame jf = new JFrame(Messages.getString("PreprocessPanel_Main_JFRame_Text"));
            jf.getContentPane().setLayout(new BorderLayout());
            PreprocessPanel sp = new PreprocessPanel();
            jf.getContentPane().add((Component)sp, "Center");
            LogPanel lp = new LogPanel();
            sp.setLog(lp);
            jf.getContentPane().add((Component)lp, "South");
            jf.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setSize(800, 600);
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    static {
        GenericObjectEditor.registerEditors();
    }
}

