/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.filewrappers;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.DecoderException;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.SampleBuffer;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.math.MathUtils;
import jp.crestmuse.cmx.sound.AudioDataCompatible;

public class MP3Wrapper
implements AudioDataCompatible {
    public List<short[]> data = new ArrayList<short[]>();
    public DoubleArray[] dataInDouble;
    public byte[] bytearray;
    public Header header = null;
    public int ch;
    public int sampleRate = -1;
    private int next = 0;

    public MP3Wrapper(InputStream inputStream) throws DecoderException, BitstreamException {
        Header header;
        Bitstream bitstream = new Bitstream(inputStream);
        Decoder decoder = new Decoder();
        while ((header = bitstream.readFrame()) != null) {
            if (this.header == null) {
                this.header = header;
            }
            SampleBuffer sampleBuffer = (SampleBuffer)decoder.decodeFrame(header, bitstream);
            this.data.add((short[])sampleBuffer.getBuffer().clone());
            bitstream.closeFrame();
        }
        int n = this.data.size();
        int n2 = decoder.getOutputBlockSize();
        int n3 = this.header.mode();
        if (n3 == 3) {
            this.ch = 1;
        } else if (n3 == 0 || n3 == 1 || n3 == 2) {
            this.ch = 2;
        } else {
            throw new IllegalArgumentException("Unsupported MP3");
        }
        this.dataInDouble = new DoubleArray[this.ch];
        for (int i = 0; i < this.ch; ++i) {
            this.dataInDouble[i] = MathUtils.createDoubleArray(n * n2 / this.ch);
        }
        this.bytearray = new byte[n * n2 * 2];
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.bytearray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.dataInDouble[n4 % this.ch].set(n4 / this.ch, (double)this.data.get(i)[j] / 32768.0);
                byteBuffer.putShort(this.data.get(i)[j]);
                ++n4;
            }
        }
    }

    public static MP3Wrapper readfile(String string) throws IOException, DecoderException, BitstreamException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        return new MP3Wrapper(bufferedInputStream);
    }

    public static MP3Wrapper read(InputStream inputStream) throws IOException, DecoderException, BitstreamException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        return new MP3Wrapper(bufferedInputStream);
    }

    public int channels() {
        return this.ch;
    }

    public int sampleRate() {
        if (this.sampleRate < 0) {
            String string = this.header.sample_frequency_string();
            if (string.endsWith("kHz")) {
                this.sampleRate = (int)(Double.parseDouble(string.substring(0, string.indexOf("kHz")).trim()) * 1000.0);
            } else {
                throw new IllegalArgumentException();
            }
        }
        return this.sampleRate;
    }

    public DoubleArray[] getDoubleArrayWaveform() {
        return this.dataInDouble;
    }

    public byte[] getByteArrayWaveform() {
        return this.bytearray;
    }

    public DoubleArray[] read(long l, int n) {
        DoubleArray[] doubleArrayArray = new DoubleArray[this.channels()];
        int n2 = (int)((long)this.sampleRate() * l / 1000000L);
        for (int i = 0; i < doubleArrayArray.length; ++i) {
            doubleArrayArray[i] = this.getDoubleArrayWaveform()[i].subarrayX(n2, n2 + n);
        }
        return doubleArrayArray;
    }

    public DoubleArray[] readNext(int n, int n2) {
        DoubleArray[] doubleArrayArray = new DoubleArray[this.channels()];
        for (int i = 0; i < doubleArrayArray.length; ++i) {
            doubleArrayArray[i] = this.getDoubleArrayWaveform()[i].subarrayX(this.next, this.next + n);
        }
        this.next += n - n2;
        return doubleArrayArray;
    }

    public boolean hasNext(int n) {
        return this.next + n <= this.getDoubleArrayWaveform()[0].length();
    }

    public boolean supportsRandomAccess() {
        return true;
    }

    public AudioFormat getAudioFormat() {
        return new AudioFormat(this.sampleRate(), 16, this.ch, true, false);
    }
}

