/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.sound;

import javax.sound.sampled.AudioFormat;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.math.Operations;
import jp.crestmuse.cmx.math.SP;
import jp.crestmuse.cmx.math.Utils;
import jp.crestmuse.cmx.sound.AudioDataCompatible;

public class MutableWaveform
implements AudioDataCompatible,
Cloneable {
    private DoubleArray[] waveform;
    private int sampleRate;
    private int next = 0;

    public MutableWaveform(double d, int n, int n2) {
        int n3 = (int)(d * (double)n);
        this.waveform = new DoubleArray[n2];
        for (int i = 0; i < n2; ++i) {
            this.waveform[i] = Utils.createDoubleArray(n3);
        }
        this.sampleRate = n;
    }

    public MutableWaveform(DoubleArray[] doubleArrayArray, int n) {
        this.waveform = doubleArrayArray;
        this.sampleRate = n;
    }

    public MutableWaveform(AudioDataCompatible audioDataCompatible) {
        this.waveform = audioDataCompatible.getDoubleArrayWaveform();
        this.sampleRate = audioDataCompatible.sampleRate();
    }

    public Object clone() {
        try {
            DoubleArray[] doubleArrayArray = new DoubleArray[this.waveform.length];
            for (int i = 0; i < this.waveform.length; ++i) {
                doubleArrayArray[i] = (DoubleArray)this.waveform[i].clone();
            }
            return new MutableWaveform(doubleArrayArray, this.sampleRate);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new UnsupportedOperationException("Clone not supported");
        }
    }

    public int sampleRate() {
        return this.sampleRate;
    }

    private int indexOfLast() {
        for (int i = this.waveform[0].length() - 1; i >= 0; --i) {
            for (int j = 0; j < this.waveform.length; ++j) {
                if (this.waveform[j].get(i) == 0.0) continue;
                return i;
            }
        }
        return 0;
    }

    public void trim() {
        this.cutAfter(this.indexOfLast());
    }

    public void trim(int n) {
        this.cutAfter(this.indexOfLast() + n);
    }

    public void cutAfter(int n) {
        for (int i = 0; i < this.waveform.length; ++i) {
            this.waveform[i] = this.waveform[i].subarrayX(0, Math.min(n + 1, this.waveform[i].length()));
        }
    }

    public void smoothOffset() {
        for (int i = 0; i < this.waveform.length; ++i) {
            for (int j = 1; j < 100; ++j) {
                Operations.mulX(this.waveform[i], this.waveform[i].length() - j, (double)j / 100.0);
            }
        }
    }

    public void cutBefore(int n) {
        for (int i = 0; i < this.waveform.length; ++i) {
            this.waveform[i] = this.waveform[i].subarrayX(n, this.waveform[i].length());
        }
    }

    int calcOnset(int n, double d) {
        int n2 = Integer.MAX_VALUE;
        for (int i = 0; i < this.waveform.length; ++i) {
            int n3 = SP.detectOnset(this.waveform[i], n, d);
            if (n3 >= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    public void cutBeforeOnset(int n, double d) {
        this.cutBefore(this.calcOnset(n, d));
    }

    public void mix(AudioDataCompatible audioDataCompatible, int n, double d) {
        if (n < 0) {
            return;
        }
        if (this.sampleRate != audioDataCompatible.sampleRate()) {
            throw new IllegalStateException("Sample rate mismatch");
        }
        DoubleArray[] doubleArrayArray = audioDataCompatible.getDoubleArrayWaveform();
        if (this.waveform.length == doubleArrayArray.length) {
            for (int i = 0; i < this.waveform.length; ++i) {
                for (int j = 0; j < doubleArrayArray[0].length(); ++j) {
                    Operations.addX(this.waveform[i], j + n, doubleArrayArray[i].get(j) * d);
                }
            }
        } else if (doubleArrayArray.length == 1) {
            for (int i = 0; i < this.waveform.length; ++i) {
                for (int j = 0; j < doubleArrayArray[0].length(); ++j) {
                    Operations.addX(this.waveform[i], j + n, doubleArrayArray[0].get(j) * d);
                }
            }
        } else if (doubleArrayArray.length == 2) {
            for (int i = 0; i < this.waveform.length; ++i) {
                for (int j = 0; j < doubleArrayArray[0].length(); ++j) {
                    Operations.addX(this.waveform[i], j + n, (doubleArrayArray[0].get(j) + doubleArrayArray[1].get(j)) * d / 2.0);
                }
            }
        } else {
            throw new IllegalStateException("Num of channels mismatch");
        }
    }

    public void mix_st(AudioDataCompatible audioDataCompatible, int n, int n2, double d, double d2) {
        if (n < 0 || n2 < 0) {
            return;
        }
        if (this.sampleRate != audioDataCompatible.sampleRate()) {
            throw new IllegalStateException("Sample rate mismatch");
        }
        DoubleArray[] doubleArrayArray = audioDataCompatible.getDoubleArrayWaveform();
        if (doubleArrayArray.length == 1) {
            for (int i = 0; i < doubleArrayArray[0].length(); ++i) {
                Operations.addX(this.waveform[0], i + n, doubleArrayArray[0].get(i) * d);
                Operations.addX(this.waveform[1], i + n2, doubleArrayArray[0].get(i) * d2);
            }
        } else if (doubleArrayArray.length == 2) {
            for (int i = 0; i < doubleArrayArray[0].length(); ++i) {
                Operations.addX(this.waveform[0], i + n, doubleArrayArray[0].get(i) * d);
                Operations.addX(this.waveform[1], i + n2, doubleArrayArray[1].get(i) * d2);
            }
        } else {
            throw new IllegalStateException("Num of channels mismatch");
        }
    }

    public void conv(DoubleArray doubleArray) {
        for (int i = 0; i < this.waveform.length; ++i) {
            this.waveform[i] = Operations.conv(this.waveform[i], doubleArray);
        }
    }

    public void conv_st(DoubleArray doubleArray, DoubleArray doubleArray2) {
        this.waveform[0] = Operations.conv(this.waveform[0], doubleArray);
        this.waveform[1] = Operations.conv(this.waveform[1], doubleArray2);
    }

    public void normalize() {
        int n;
        double d = 0.0;
        for (n = 0; n < this.waveform.length; ++n) {
            double d2;
            double d3 = Operations.absmax(this.waveform[n]);
            if (!(d2 > d)) continue;
            d = d3;
        }
        for (n = 0; n < this.waveform.length; ++n) {
            Operations.divX(this.waveform[n], d * 1.01);
        }
    }

    public boolean supportsRandomAccess() {
        return true;
    }

    public DoubleArray[] read(long l, int n) {
        throw new UnsupportedOperationException();
    }

    public DoubleArray[] readNext(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    public boolean hasNext(int n) {
        throw new UnsupportedOperationException();
    }

    public AudioFormat getAudioFormat() {
        throw new UnsupportedOperationException();
    }

    public byte[] getByteArrayWaveform() {
        throw new UnsupportedOperationException();
    }

    public DoubleArray[] getDoubleArrayWaveform() {
        return this.waveform;
    }

    public int channels() {
        return this.waveform.length;
    }

    public MutableWaveform changeSampleRate(int n) {
        DoubleArray[] doubleArrayArray = new DoubleArray[this.waveform.length];
        for (int i = 0; i < this.waveform.length; ++i) {
            doubleArrayArray[i] = SP.changeRate(this.waveform[i], this.sampleRate, n);
        }
        return new MutableWaveform(doubleArrayArray, n);
    }
}

