/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import jp.crestmuse.cmx.math.DoubleArray;

abstract class AbstractInterpolationModule {
    private int idxFrom;
    private int idxThru;

    AbstractInterpolationModule() {
    }

    abstract boolean isMissing(double var1);

    abstract void calcCoefficient(int var1, double var2, int var4, double var5);

    abstract double calcValue(int var1, int var2, double var3, int var5, double var6);

    synchronized void run(DoubleArray doubleArray, int n) {
        this.run(doubleArray, 0, doubleArray.length(), n);
    }

    synchronized void run(DoubleArray doubleArray, int n, int n2, int n3) {
        int n4 = n;
        while (true) {
            this.findDataToBeInterpolated(doubleArray, n4, n2);
            if (this.idxThru == -1) break;
            if (this.idxFrom >= 0 && this.idxThru >= 0 && this.idxThru - this.idxFrom <= n3) {
                this.interpolate(doubleArray);
            }
            n4 = this.idxThru;
        }
    }

    private void interpolate(DoubleArray doubleArray) {
        int n = this.idxFrom - 1;
        int n2 = this.idxThru;
        double d = doubleArray.get(n);
        double d2 = doubleArray.get(n2);
        this.calcCoefficient(n, d, n2, d2);
        for (int i = this.idxFrom; i < this.idxThru; ++i) {
            doubleArray.set(i, this.calcValue(i, n, d, n2, d2));
        }
    }

    private void findDataToBeInterpolated(DoubleArray doubleArray, int n, int n2) {
        this.idxFrom = -1;
        this.idxThru = -1;
        for (int i = n + 1; i < n2; ++i) {
            if (!this.isMissing(doubleArray.get(i - 1)) && this.isMissing(doubleArray.get(i))) {
                this.idxFrom = i;
                continue;
            }
            if (!this.isMissing(doubleArray.get(i - 1)) || this.isMissing(doubleArray.get(i))) continue;
            this.idxThru = i;
            break;
        }
    }
}

