/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import jp.crestmuse.cmx.math.AbstractComplexArrayImpl;
import jp.crestmuse.cmx.math.AbstractDoubleArrayImpl;
import jp.crestmuse.cmx.math.ComplexArray;
import jp.crestmuse.cmx.math.DoubleArray;

public class HarkObject {
    public HD_Header header;
    public HDH_MicData mic_wave_head;
    public float[] mic_wave_data;
    public HDH_MicData mic_fft_head;
    public float[] mic_fft_real;
    public float[] mic_fft_imag;
    public int src_num;
    public SrcObject[] src;
    public long music_position = 0L;
    private byte[] bytearray = new byte[4];
    private ByteBuffer bytebuff = ByteBuffer.wrap(this.bytearray);

    public HarkObject(InputStream inputStream) throws IOException {
        this.bytebuff.order(ByteOrder.LITTLE_ENDIAN);
        this.header = new HD_Header(this.readInt(inputStream), this.readInt(inputStream), this.readInt(inputStream));
        if (this.hasMicWave()) {
            this.mic_wave_head = new HDH_MicData(this.readInt(inputStream), this.readInt(inputStream), this.readInt(inputStream));
            this.mic_wave_data = this.readFloatArray(inputStream, this.mic_wave_head.data_bytes);
        } else {
            this.mic_wave_head = null;
            this.mic_wave_data = null;
        }
        if (this.hasMicFFT()) {
            this.mic_fft_head = new HDH_MicData(this.readInt(inputStream), this.readInt(inputStream), this.readInt(inputStream));
            this.mic_fft_real = this.readFloatArray(inputStream, this.mic_fft_head.data_bytes);
            this.mic_fft_imag = this.readFloatArray(inputStream, this.mic_fft_head.data_bytes);
        } else {
            this.mic_fft_head = null;
            this.mic_fft_real = null;
            this.mic_fft_imag = null;
        }
        if (this.hasSrcInfo()) {
            this.src_num = this.readInt(inputStream);
            this.src = new SrcObject[this.src_num];
            for (int i = 0; i < this.src_num; ++i) {
                this.src[i] = new SrcObject(inputStream);
            }
        } else {
            this.src_num = 0;
            this.src = new SrcObject[0];
        }
    }

    private int readInt(InputStream inputStream) throws IOException {
        inputStream.read(this.bytearray);
        return this.bytebuff.getInt(0);
    }

    private float readFloat(InputStream inputStream) throws IOException {
        inputStream.read(this.bytearray);
        return this.bytebuff.getFloat(0);
    }

    private float[] readFloatArray(InputStream inputStream, int n) throws IOException {
        float[] fArray = new float[n / 4];
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; i += inputStream.read(byArray, i, n - i)) {
        }
        FloatBuffer floatBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer();
        floatBuffer.get(fArray);
        return fArray;
    }

    public boolean hasMicWave() {
        return (this.header.type & 1) == 1;
    }

    public boolean hasMicFFT() {
        return (this.header.type & 2) == 2;
    }

    public boolean hasSrcInfo() {
        return (this.header.type & 4) == 4;
    }

    public boolean hasSrcWave() {
        return (this.header.type & 8) == 8;
    }

    public boolean hasSrcFFT() {
        return (this.header.type & 0x10) == 16;
    }

    public boolean hasSrcFeature() {
        return (this.header.type & 0x20) == 32;
    }

    public boolean hasSrcReliability() {
        return (this.header.type & 0x40) == 64;
    }

    public DoubleArray[] getMicWave() {
        DoubleArray[] doubleArrayArray = new DoubleArray[this.mic_wave_head.nch];
        for (int i = 0; i < doubleArrayArray.length; ++i) {
            doubleArrayArray[i] = new MyDoubleArray2(this.mic_wave_head, i, this.mic_wave_data);
        }
        return doubleArrayArray;
    }

    public ComplexArray[] getMicFFT() {
        ComplexArray[] complexArrayArray = new ComplexArray[this.mic_fft_head.nch];
        for (int i = 0; i < complexArrayArray.length; ++i) {
            complexArrayArray[i] = new MyComplexArray2(this.mic_fft_head, i, this.mic_fft_real, this.mic_fft_imag);
        }
        return complexArrayArray;
    }

    private class MyComplexArray2
    extends AbstractComplexArrayImpl {
        private HDH_MicData head;
        private int ch;
        private float[] real;
        private float[] imag;

        private MyComplexArray2(HDH_MicData hDH_MicData, int n, float[] fArray, float[] fArray2) {
            this.head = hDH_MicData;
            this.ch = n;
            this.real = fArray;
            this.imag = fArray2;
        }

        public int length() {
            return this.head.length;
        }

        public double getReal(int n) {
            return this.real[n * this.head.nch + this.ch];
        }

        public double getImag(int n) {
            return this.imag[n * this.head.nch + this.ch];
        }

        public void setReal(int n, double d) {
            this.real[n * this.head.nch + this.ch] = (float)d;
        }

        public void setImag(int n, double d) {
            this.imag[n * this.head.nch + this.ch] = (float)d;
        }
    }

    private class MyDoubleArray2
    extends AbstractDoubleArrayImpl {
        private HDH_MicData head;
        private int ch;
        private float[] data;

        private MyDoubleArray2(HDH_MicData hDH_MicData, int n, float[] fArray) {
            this.head = hDH_MicData;
            this.ch = n;
            this.data = fArray;
        }

        public int length() {
            return this.head.length;
        }

        public double get(int n) {
            return this.data[n * this.head.nch + this.ch];
        }

        public void set(int n, double d) {
            this.data[n * this.head.nch + this.ch] = (float)d;
        }
    }

    private class MyComplexArray
    extends AbstractComplexArrayImpl {
        private HDH_SrcData head;
        private float[] real;
        private float[] imag;

        private MyComplexArray(HDH_SrcData hDH_SrcData, float[] fArray, float[] fArray2) {
            this.head = hDH_SrcData;
            this.real = fArray;
            this.imag = fArray2;
        }

        public int length() {
            return this.head.length;
        }

        public double getReal(int n) {
            return this.real[n];
        }

        public double getImag(int n) {
            return this.imag[n];
        }

        public void setReal(int n, double d) {
            this.real[n] = (float)d;
        }

        public void setImag(int n, double d) {
            this.imag[n] = (float)d;
        }
    }

    private class MyDoubleArray
    extends AbstractDoubleArrayImpl {
        private HDH_SrcData head;
        private float[] data;

        private MyDoubleArray(HDH_SrcData hDH_SrcData, float[] fArray) {
            this.head = hDH_SrcData;
            this.data = fArray;
        }

        public int length() {
            return this.head.length;
        }

        public double get(int n) {
            return this.data[n];
        }

        public void set(int n, double d) {
            this.data[n] = (float)d;
        }
    }

    public class SrcObject {
        public HDH_SrcInfo info;
        public HDH_SrcData wave_head;
        public float[] wave_data;
        public HDH_SrcData fft_head;
        public float[] fft_real;
        public float[] fft_imag;
        public HDH_SrcData feature_head;
        public float[] feature_data;
        public HDH_SrcData reliability_head;
        public float[] reliability_data;

        private SrcObject(InputStream inputStream) throws IOException {
            this.info = new HDH_SrcInfo(HarkObject.this.readInt(inputStream), HarkObject.this.readFloat(inputStream), HarkObject.this.readFloat(inputStream), HarkObject.this.readFloat(inputStream), HarkObject.this.readFloat(inputStream));
            if (HarkObject.this.hasSrcWave()) {
                this.wave_head = new HDH_SrcData(HarkObject.this.readInt(inputStream), HarkObject.this.readInt(inputStream));
                this.wave_data = HarkObject.this.readFloatArray(inputStream, this.wave_head.data_bytes);
            } else {
                this.wave_head = null;
                this.wave_data = null;
            }
            if (HarkObject.this.hasSrcFFT()) {
                this.fft_head = new HDH_SrcData(HarkObject.this.readInt(inputStream), HarkObject.this.readInt(inputStream));
                this.fft_real = HarkObject.this.readFloatArray(inputStream, this.fft_head.data_bytes);
                this.fft_imag = HarkObject.this.readFloatArray(inputStream, this.fft_head.data_bytes);
            } else {
                this.fft_head = null;
                this.fft_real = null;
                this.fft_imag = null;
            }
            if (HarkObject.this.hasSrcFeature()) {
                this.feature_head = new HDH_SrcData(HarkObject.this.readInt(inputStream), HarkObject.this.readInt(inputStream));
                this.feature_data = HarkObject.this.readFloatArray(inputStream, this.feature_head.data_bytes);
            } else {
                this.feature_head = null;
                this.feature_data = null;
            }
            if (HarkObject.this.hasSrcReliability()) {
                this.reliability_head = new HDH_SrcData(HarkObject.this.readInt(inputStream), HarkObject.this.readInt(inputStream));
                this.reliability_data = HarkObject.this.readFloatArray(inputStream, this.reliability_head.data_bytes);
            } else {
                this.reliability_head = null;
                this.reliability_data = null;
            }
        }

        public DoubleArray getSrcWave() {
            return new MyDoubleArray(this.wave_head, this.wave_data);
        }

        public ComplexArray getSrcFFT() {
            return new MyComplexArray(this.fft_head, this.fft_real, this.fft_imag);
        }

        public DoubleArray getSrcFeature() {
            return new MyDoubleArray(this.feature_head, this.feature_data);
        }

        public DoubleArray getSrcReliability() {
            return new MyDoubleArray(this.reliability_head, this.reliability_data);
        }
    }

    public class HDH_SrcData {
        int length;
        int data_bytes;

        private HDH_SrcData(int n, int n2) {
            this.length = n;
            this.data_bytes = n2;
        }

        public String toString() {
            return "length: " + this.length + ", data_bytes: " + this.data_bytes;
        }
    }

    public class HDH_SrcInfo {
        int src_d;
        float[] x;
        float power;

        private HDH_SrcInfo(int n, float f, float f2, float f3, float f4) {
            this.src_d = n;
            this.x = new float[3];
            this.x[0] = f;
            this.x[1] = f2;
            this.x[2] = f3;
            this.power = f4;
        }

        public String toString() {
            return "src_d: " + this.src_d + ", x: [" + this.x[0] + ", " + this.x[1] + ", " + this.x[2] + "], power:" + this.power;
        }
    }

    public class HDH_MicData {
        public int nch;
        public int length;
        public int data_bytes;

        private HDH_MicData(int n, int n2, int n3) {
            this.nch = n;
            this.length = n2;
            this.data_bytes = n3;
        }

        public String toString() {
            return "nch: " + this.nch + ", length: " + this.length + ", data_bytes: " + this.data_bytes;
        }
    }

    public class HD_Header {
        public int type;
        public int advance;
        public int count;

        private HD_Header(int n, int n2, int n3) {
            this.type = n;
            this.advance = n2;
            this.count = n3;
        }

        public String toString() {
            return "type: " + this.type + ", advance: " + this.advance + ", count: " + this.count;
        }
    }
}

