/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.filewrappers;

import groovy.lang.Closure;
import java.util.TreeMap;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.elements.MutableAnnotation;
import jp.crestmuse.cmx.elements.MutableMusicEvent;
import jp.crestmuse.cmx.elements.MutableNote;
import jp.crestmuse.cmx.filewrappers.SCC;
import jp.crestmuse.cmx.filewrappers.SCCDataSet;
import jp.crestmuse.cmx.misc.ChordSymbol;

public class SCCUtils {
    static SCC.HeaderElement getFirstHeader(SCC sCC, String string) {
        SCC.HeaderElement[] headerElementArray;
        for (SCC.HeaderElement headerElement : headerElementArray = sCC.getHeaderElementList()) {
            if (!headerElement.name().equals(string)) continue;
            return headerElement;
        }
        return null;
    }

    static SCC.Annotation[] getChordList(SCC sCC) {
        SCC.Annotation[] annotationArray = sCC.getAnnotationList();
        if (annotationArray == null) {
            return null;
        }
        int n = 0;
        for (int i = 0; i < annotationArray.length; ++i) {
            if (!annotationArray[i].type().equals("chord")) continue;
            ++n;
        }
        SCC.Annotation[] annotationArray2 = new SCC.Annotation[n];
        int n2 = 0;
        for (int i = 0; i < annotationArray.length; ++i) {
            if (!annotationArray[i].type().equals("chord")) continue;
            annotationArray2[n2] = annotationArray[i];
            ++n2;
        }
        return annotationArray2;
    }

    static SCC.Annotation[] getBarlineList(SCC sCC) {
        SCC.Annotation[] annotationArray = sCC.getAnnotationList();
        if (annotationArray == null) {
            return null;
        }
        int n = 0;
        for (int i = 0; i < annotationArray.length; ++i) {
            if (!annotationArray[i].type().equals("barline")) continue;
            ++n;
        }
        SCC.Annotation[] annotationArray2 = new SCC.Annotation[n];
        int n2 = 0;
        for (int i = 0; i < annotationArray.length; ++i) {
            if (!annotationArray[i].type().equals("barline")) continue;
            annotationArray2[n2] = annotationArray[i];
            ++n2;
        }
        return annotationArray2;
    }

    public static SCC transpose(SCC sCC, int n, boolean bl) throws TransformerException {
        Object object;
        int n2;
        SCCDataSet sCCDataSet = sCC.toDataSet().clone();
        int n3 = 0;
        while (n3 * 7 % 12 != n) {
            if (n > 0) {
                ++n3;
                continue;
            }
            --n3;
        }
        SCCDataSet.HeaderElement[] headerElementArray = sCCDataSet.getHeaderElementList();
        Object[] objectArray = headerElementArray;
        int n4 = objectArray.length;
        for (n2 = 0; n2 < n4; ++n2) {
            SCCDataSet.HeaderElement headerElement = objectArray[n2];
            if (!headerElement.name().equals("KEY")) continue;
            object = headerElement.content.split(" ");
            int n5 = Integer.parseInt((String)(object[0].startsWith("+") ? ((String)object[0]).substring(1) : object[0])) + n3;
            headerElement.content = (n5 > 0 ? "+" + n5 : Integer.valueOf(n5)) + " " + (String)object[1];
        }
        Object[] objectArray2 = objectArray = sCCDataSet.getPartList();
        n2 = objectArray2.length;
        for (int i = 0; i < n2; ++i) {
            object = objectArray2[i];
            if (((SCCDataSet.Part)object).channel() == 10) continue;
            MutableMusicEvent[] mutableMusicEventArray = ((SCCDataSet.Part)object).getNoteList();
            for (MutableMusicEvent mutableMusicEvent : mutableMusicEventArray) {
                if (!(mutableMusicEvent instanceof MutableNote)) continue;
                MutableNote mutableNote = (MutableNote)mutableMusicEvent;
                mutableNote.setNoteNum(mutableNote.notenum() + n);
            }
        }
        for (Object object2 : objectArray2 = sCCDataSet.getChordList()) {
            MutableAnnotation mutableAnnotation = (MutableAnnotation)object2;
            mutableAnnotation.setContent(ChordSymbol.parse(mutableAnnotation.content()).transpose(n, bl).encode());
        }
        return sCCDataSet;
    }

    public static SCCDataSet createVoicewiseSCC(SCC sCC) throws TransformerException {
        int n;
        int n2 = 0;
        TreeMap<String, SCCDataSet.Part> treeMap = new TreeMap<String, SCCDataSet.Part>();
        int n3 = sCC.getDivision();
        SCCDataSet sCCDataSet = new SCCDataSet(n3);
        SCC.HeaderElement[] headerElementArray = sCC.getHeaderElementList();
        Object[] objectArray = headerElementArray;
        int n4 = objectArray.length;
        for (n = 0; n < n4; ++n) {
            SCC.HeaderElement headerElement = objectArray[n];
            sCCDataSet.addHeaderElement(headerElement.time(), headerElement.name(), headerElement.content());
        }
        Object[] objectArray2 = objectArray = sCC.getPartList();
        n = objectArray2.length;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray2[i];
            Object object2 = object.getNoteList();
            for (SCC.Note note : object2) {
                String string = object.name() + "; oldserial=" + object.serial() + (note.hasAttribute("voice") ? " voice=" + note.getAttribute("voice") : "");
                SCCDataSet.Part part = (SCCDataSet.Part)treeMap.get(string);
                if (part == null) {
                    part = sCCDataSet.addPart(++n2, (int)object.channel(), object.prognum(), object.volume(), string);
                    treeMap.put(string, part);
                }
                part.addNoteElement(note.onset(n3), note.offset(n3), note.notenum(), note.velocity(), note.offVelocity(), note.getAttributes());
            }
        }
        for (Object object2 : objectArray2 = sCC.getAnnotationList()) {
            sCCDataSet.addAnnotation(object2.type(), object2.onset(n3), object2.offset(n3), object2.content());
        }
        return sCCDataSet;
    }

    static void eachnote(SCC sCC, Closure closure) throws TransformerException {
        SCC.Part[] partArray;
        for (SCC.Part part : partArray = sCC.getPartList()) {
            SCC.Note[] noteArray;
            for (SCC.Note note : noteArray = part.getNoteList()) {
                closure.call(new Object[]{note});
            }
        }
    }

    static void eachpart(SCC sCC, Closure closure) throws TransformerException {
        SCC.Part[] partArray;
        for (SCC.Part part : partArray = sCC.getPartList()) {
            closure.call(new Object[]{part});
        }
    }

    static void eachnote(SCC.Part part, Closure closure) throws TransformerException {
        SCC.Note[] noteArray;
        for (SCC.Note note : noteArray = part.getNoteList()) {
            closure.call(new Object[]{note});
        }
    }

    static void eachchord(SCC sCC, Closure closure) throws TransformerException {
        SCC.Annotation[] annotationArray;
        for (SCC.Annotation annotation : annotationArray = sCC.getChordList()) {
            closure.call(new Object[]{annotation});
        }
    }

    static void eachbarline(SCC sCC, Closure closure) throws TransformerException {
        SCC.Annotation[] annotationArray;
        for (SCC.Annotation annotation : annotationArray = sCC.getBarlineList()) {
            closure.call(new Object[]{annotation});
        }
    }
}

