/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.misc;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.crestmuse.cmx.misc.NoteSymbol;

public final class ChordSymbol {
    private NoteSymbol root;
    private Mode mode;
    private Seventh seventh;
    private NoteSymbol bass = null;
    private static Pattern p = Pattern.compile("([CDEFGAB])(|\\#|b)(|M|maj|major|m|min|minor|aug|augument|augumented|dim|diminish|diminished)(|7|M7|maj7|major7)");
    private static Pattern p2 = Pattern.compile("([CDEFGAB])(|\\#|b)");

    public ChordSymbol(NoteSymbol noteSymbol, Mode mode, Seventh seventh) {
        this.root = noteSymbol;
        this.mode = mode;
        this.seventh = seventh;
    }

    public ChordSymbol(NoteSymbol noteSymbol, Mode mode, Seventh seventh, NoteSymbol noteSymbol2) {
        this.root = noteSymbol;
        this.mode = mode;
        this.seventh = seventh;
        this.bass = noteSymbol2;
    }

    public static ChordSymbol[] getChordSymbolList(String[] stringArray) {
        ChordSymbol[] chordSymbolArray = new ChordSymbol[stringArray.length];
        for (int i = 0; i < chordSymbolArray.length; ++i) {
            chordSymbolArray[i] = ChordSymbol.parse(stringArray[i]);
        }
        return chordSymbolArray;
    }

    public static ChordSymbol parse(String string) {
        return ChordSymbol.parse(string, false);
    }

    public static ChordSymbol parse(String string, boolean bl) {
        String[] stringArray = string.trim().split("/");
        Matcher matcher = p.matcher(stringArray[0]);
        if (matcher.matches()) {
            if (stringArray.length >= 2) {
                Matcher matcher2 = p2.matcher(stringArray[1]);
                if (matcher2.matches()) {
                    return new ChordSymbol(new NoteSymbol(ChordSymbol.parseRoot(matcher.group(1)), ChordSymbol.parseSign(matcher.group(2))), ChordSymbol.parseMode(matcher.group(3)), bl ? Seventh.NONE : ChordSymbol.parseSeventh(matcher.group(4), matcher.group(3)), new NoteSymbol(ChordSymbol.parseRoot(matcher2.group(1)), ChordSymbol.parseSign(matcher2.group(2))));
                }
                throw new IllegalStateException("Invalid chord symbol: " + string);
            }
            return new ChordSymbol(new NoteSymbol(ChordSymbol.parseRoot(matcher.group(1)), ChordSymbol.parseSign(matcher.group(2))), ChordSymbol.parseMode(matcher.group(3)), bl ? Seventh.NONE : ChordSymbol.parseSeventh(matcher.group(4), matcher.group(3)));
        }
        throw new IllegalStateException("Invalid chord symbol: " + string);
    }

    public static void addStringMap(String string, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        Mode.strings.put(string, stringArray2);
        Seventh.strings.put(string, stringArray3);
    }

    public String encode() {
        return this.encode("default", false);
    }

    public String encode(String string, boolean bl) {
        return this.root.toString() + this.mode.toString(string) + (bl ? "" : this.seventh.toString(string)) + (this.bass == null ? "" : "/" + this.bass.toString());
    }

    public static String[] encodeAll(ChordSymbol[] chordSymbolArray) {
        String[] stringArray = new String[chordSymbolArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = chordSymbolArray[i].encode();
        }
        return stringArray;
    }

    public static String[] encodeAll(ChordSymbol[] chordSymbolArray, String string, boolean bl) {
        String[] stringArray = new String[chordSymbolArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = chordSymbolArray[i].encode(string, bl);
        }
        return stringArray;
    }

    private static NoteSymbol.NoteName parseRoot(String string) {
        if (string.equals("C")) {
            return NoteSymbol.NoteName.C;
        }
        if (string.equals("D")) {
            return NoteSymbol.NoteName.D;
        }
        if (string.equals("E")) {
            return NoteSymbol.NoteName.E;
        }
        if (string.equals("F")) {
            return NoteSymbol.NoteName.F;
        }
        if (string.equals("G")) {
            return NoteSymbol.NoteName.G;
        }
        if (string.equals("A")) {
            return NoteSymbol.NoteName.A;
        }
        if (string.equals("B")) {
            return NoteSymbol.NoteName.B;
        }
        throw new IllegalStateException("Invalid root note: " + string);
    }

    private static NoteSymbol.Sign parseSign(String string) {
        if (string.equals("")) {
            return NoteSymbol.Sign.NONE;
        }
        if (string.equals("#")) {
            return NoteSymbol.Sign.SHARP;
        }
        if (string.equals("b")) {
            return NoteSymbol.Sign.FLAT;
        }
        throw new IllegalStateException("Invalid sign: " + string);
    }

    private static Mode parseMode(String string) {
        if (string.equals("") || string.equals("M") || string.startsWith("maj")) {
            return Mode.MAJ;
        }
        if (string.equals("m") || string.startsWith("min")) {
            return Mode.MIN;
        }
        if (string.startsWith("aug")) {
            return Mode.AUG;
        }
        if (string.startsWith("dim")) {
            return Mode.DIM;
        }
        throw new IllegalStateException("Invalid mode: " + string);
    }

    private static Seventh parseSeventh(String string, String string2) {
        if (string.equals("")) {
            return Seventh.NONE;
        }
        if (string.equals("7") && (string2.equals("M") || string2.startsWith("maj"))) {
            return Seventh.MAJ7;
        }
        if (string.equals("7")) {
            return Seventh.DOM7;
        }
        if (string.startsWith("M7") || string.startsWith("maj")) {
            return Seventh.MAJ7;
        }
        throw new IllegalStateException("Invalid seventh: " + string);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof ChordSymbol) {
            ChordSymbol chordSymbol = (ChordSymbol)object;
            return this.root.equals(chordSymbol.root) && this.mode.equals((Object)chordSymbol.mode) && this.seventh.equals((Object)chordSymbol.seventh);
        }
        return false;
    }

    public int hashCode() {
        return this.root.hashCode() + this.mode.hashCode() + this.seventh.hashCode();
    }

    public String toString() {
        return this.encode();
    }

    public ChordSymbol transpose(int n, boolean bl) {
        System.err.println("diff: " + n);
        System.err.println("num: " + this.root.number());
        int n2 = (this.root.number() + n) % 12;
        if (n2 < 0) {
            n2 += 12;
        }
        return new ChordSymbol(new NoteSymbol(n2, bl), this.mode, this.seventh);
    }

    static {
        ChordSymbol.addStringMap("default", new String[]{"", "#", "b"}, new String[]{"", "m", "aug", "dim"}, new String[]{"", "7", "maj7"});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Seventh {
        NONE,
        DOM7,
        MAJ7;

        static Map<String, String[]> strings;

        public String toString(String string) {
            return strings.get(string)[this.ordinal()];
        }

        static {
            strings = new HashMap<String, String[]>();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        MAJ,
        MIN,
        AUG,
        DIM;

        static Map<String, String[]> strings;

        public String toString(String string) {
            return strings.get(string)[this.ordinal()];
        }

        static {
            strings = new HashMap<String, String[]>();
        }
    }
}

