/*
 * Created on 2005/04/01 by abe (hidenao@users.sourceforge.jp)
 *
 */

/*
 * LICENSE:
 * 
 *     Copyright (C) 2006 Hidenao Abe (COIN Project)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
package coin.data_sinker;

import java.io.FileOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;

import coin.Attribute;
import coin.Attributes;
import coin.Instance;
import coin.Instances;
import coin.dataset_loader.ArffDatasetLoader; // for test

/**
 * @author abe(abe@med.shimane-u.ac.jp)
 *
 */
public class C45DataSinker extends DataSinker{

	public C45DataSinker(){
		super();
	}
	
	public C45DataSinker(Instances instances){
		super(instances);
	}
	
	public String toString(){
		
		StringBuffer dataset_buf = new StringBuffer();
		
		Attributes attInfo = instances.getAttributeInfo();
		StringBuffer att_buf = new StringBuffer();
		
		int i=0;
		for(i=0; i<attInfo.getNumAttributes(); i++){
			Attribute att = attInfo.getAttribute(i);
			att_buf.append(att.getName());
			if(i< attInfo.getNumAttributes()-1){
				att_buf.append("\n");
			}
		}
		att_buf.append("\n");
		
		dataset_buf.append(att_buf.toString());
		
		for(i=0; i<instances.size(); i++){
			Instance inst = instances.getInstance(i);
			StringBuffer inst_buf = new StringBuffer();
			int j=0;
			for(j=0; j<attInfo.getNumAttributes(); j++){
				inst_buf.append(inst.getValueAt(j));
				if(j< attInfo.getNumAttributes()-1){
					inst_buf.append(",");
				}
			}
			inst_buf.append("\n");
			dataset_buf.append(inst_buf.toString());
		}
		
		return(dataset_buf.toString());
	}
	
	public void store(String fileName){
		
		if(instances==null){
			makeInstances(false);
		}
	
		try{
			FileOutputStream fos = new FileOutputStream(fileName);
			BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(fos));
		
			try{
				bw.write(this.toString());
				bw.flush();
			}
			catch(IOException ioe){
				ioe.printStackTrace();
			}
		
			try{
				bw.close();
			}
			catch(IOException ioe){
				ioe.printStackTrace();
			}
		}
		catch(IOException ioe){
			ioe.printStackTrace();
		}

		
	}
	
	public void storeUnnormalized(String fileName){
		makeInstances(false);
		store(fileName);
	}
	
	public void storeNormalized(String fileName){
		
		makeInstances(true);
		store(fileName);
		
	}
	
	public static void main(String[] argv){
		
		ArffDatasetLoader dsl = new ArffDatasetLoader(argv[1]);
		
		C45DataSinker ds = new C45DataSinker(dsl.getInstances());
		
		ds.store(argv[2]);
	}
	
}
