/*
 * Created on 2005/02/17 by abe (hidenao@users.sourceforge.jp)
 *
 */

/*
 * LICENSE:
 * 
 *     Copyright (C) 2006 Hidenao Abe (COIN Project)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
package coin.data_sinker;

import java.io.FileOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;

import coin.Attribute;
import coin.Attributes;
import coin.Instance;
import coin.Instances;
import coin.dataset_loader.ArffDatasetLoader; // for test

/**
 * @author abe hidenao@users.sourceforge.jp
 *
 */
public class CSVDataSinker extends DataSinker{

	public CSVDataSinker(){
		super();
	}
	
	public CSVDataSinker(Instances instances){
		super(instances);
	}
	
	public String toString(){
		
		StringBuffer dataset_buf = new StringBuffer();
		
		Attributes attInfo = instances.getAttributeInfo();
		StringBuffer att_buf = new StringBuffer();
		
		int i=0;
		for(i=0; i<attInfo.getNumAttributes(); i++){
			Attribute att = attInfo.getAttribute(i);
			att_buf.append(att.getName());
			if(i< attInfo.getNumAttributes()-1){
				att_buf.append(",");
			}
		}
		att_buf.append("\n");
		
		dataset_buf.append(att_buf.toString());
		
		for(i=0; i<instances.size(); i++){
			Instance inst = instances.getInstance(i);
			StringBuffer inst_buf = new StringBuffer();
			int j=0;
			for(j=0; j<attInfo.getNumAttributes(); j++){
				inst_buf.append(inst.getValueAt(j));
				if(j< attInfo.getNumAttributes()-1){
					inst_buf.append(",");
				}
			}
			inst_buf.append("\n");
			dataset_buf.append(inst_buf.toString());
		}
		
		return(dataset_buf.toString());
	}
	
	public void store(){
		
		if(instances==null){
			makeInstances(false);
		}
	
		try{
			
			FileOutputStream fos = new FileOutputStream(fileName);
			BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(fos));
		
			try{
				bw.write(this.toString());
				bw.flush();
			}
			catch(IOException ioe){
				ioe.printStackTrace();
			}
		
			try{
				bw.close();
			}
			catch(IOException ioe){
				ioe.printStackTrace();
			}
		}
		catch(IOException ioe){
			ioe.printStackTrace();
		}

		
	}
	
	public void storeUnnormalized(){
		makeInstances(false);
		StringBuffer stb = new StringBuffer(dataName);
		stb.append("_all.cvs");
		fileName = stb.toString();
		store();
	}
	
	public void storeNormalized(){
		
		makeInstances(true);
		StringBuffer stb = new StringBuffer(dataName);
		stb.append("_normalized.cvs");
		fileName = stb.toString();
		store();
		
	}
	
	public static void main(String[] argv){
		
		ArffDatasetLoader dsl = new ArffDatasetLoader(argv[1]);
		
		CSVDataSinker ds = new CSVDataSinker(dsl.getInstances());
		
		ds.setName(argv[2]);
		ds.storeUnnormalized();
	}
	
}
