/*
 * Created on 2005/01/24
 *
 */

/*
 * LICENSE:
 * 
 *     Copyright (C) 2006 Hidenao Abe (COIN Project)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
package coin.data_sinker;

import java.util.Vector;
import java.util.Hashtable;
import coin.Instance;
import coin.Instances;
import coin.Attribute;
import coin.Attributes;
import coin.Evaluator;

/**
 * @author abe(hidenao@users.sourceforge.jp)
 *
 */
public abstract class DataSinker {

	Hashtable evaluators = null;
	Vector measures = null;
	Vector sortedObjects = null;
	Instances instances = null;
	String dataName = null;
	String fileName = null;
	
	String baseMeasureName = null;
	
	public DataSinker(){
		this.evaluators = new Hashtable();
		this.measures = new Vector();
		this.sortedObjects = new Vector();
	}
	
	public DataSinker(String name){
		this.evaluators = new Hashtable();
		this.measures = new Vector();
		this.sortedObjects = new Vector();
		this.dataName = new String(name);
	}
	
	public DataSinker(Instances instances){
		this.instances = instances;
	}
	
	public void putEvaluator(String eName, Evaluator ev){
		evaluators.put(eName,ev);
		measures.add(eName);
	}
	
	public void setBaseMeasure(String measureName, boolean lower_best){
		Evaluator base = null;
		
		base = (Evaluator)evaluators.get(measureName);
		Object[] objects = new Object[base.getNumOfResults()];
		objects = base.sort();
		
		int i=0;
		if(lower_best){
			for(i=0; i<objects.length; i++){
				sortedObjects.add(objects[i]);
			}
		}
		else{
			for(i=objects.length -1; i>=0; i--){
				sortedObjects.add(objects[i]);
			}
		}
		
		baseMeasureName = measureName;
	}
	
	protected boolean makeInstances(boolean normalize){
		boolean result = false;
		
		if(sortedObjects != null){
			
			Attributes attInfo = new Attributes();
			instances = new Instances();
			int i=0;
			for(i=0; i<sortedObjects.size(); i++){
				Instance inst = new Instance(evaluators.size()+1);
				instances.addInstance(inst);
			}

			
			int attIndex=0;
//			append overall sequential number
			Attribute att = new Attribute();
			
			att.setId(attIndex);
			att.setName("SequentialID");
			att.setType(Attribute.IGNORE);
		
			attInfo.addAttribute(att);
			
			for(i=0; i<sortedObjects.size(); i++){
				Instance inst = instances.getInstance(i);
				inst.addValue(attIndex,Integer.toString(i));
			}
			attIndex++;
			
			for(i=0; i<measures.size(); i++,attIndex++){
					
				Evaluator ev = null;
				ev = (Evaluator)evaluators.get(measures.elementAt(i));
				
				Attribute t_att = new Attribute();

				// append attribute information to internal data set
				t_att.setId(attIndex);
				t_att.setName(ev.getName());
				if(ev.getType().equals(Evaluator.TYPE_VALUE)){
					t_att.setType(Attribute.NUMERIC);
				}
				else if(ev.getType().equals(Evaluator.TYPE_STRING)){
					t_att.setType(Attribute.NOMINAL);
				}
				else{
					t_att.setType(Attribute.UNKNOWN);
				}
				attInfo.addAttribute(t_att);
				
				Vector values = new Vector();
				
				// append value to internal data set
				int j=0;
				for(j=0; j<sortedObjects.size(); j++){
					Instance inst = instances.getInstance(j);
					String val = null;
					if(normalize==false){
						val = ev.getStringResult(sortedObjects.elementAt(j));
					}
					else{
						val = ev.getStringNormResult(sortedObjects.elementAt(j));
					}
					
					if(val==null){
						val = Instance.UNKNOWN_VALUE;
					}
					else{
						values.add(val);
					}
					//inst.addValue(attIndex,ev.getStringResult(sortedObjects.elementAt(j)));
					inst.addValue(attIndex,val);
				}
				
				if(t_att.getType()==Attribute.NOMINAL){
					t_att.setNominalValues(values.toString()," ");
				}
			}
			
			// set attribute information to internal data set
			instances.setAttributeInfo(attInfo);
			
			result = true;
		}
		
		return result;
	}
	
	public void setName(String name){
		if(dataName==null){
			dataName=name;
		}
	}
	
	public String getName(){
		return(dataName);
	}
	
	public String toString(){
		return(instances.toString());
	}
	
	public static void main(String[] args){
	}
}
