/*
 * Original coded: 2003/12/04 by abe
 *
 */

/*
 * LICENSE:
 * 
 *     Copyright (C) 2006 Hidenao Abe (COIN Project)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
package coin.dataset_loader;

import coin.Attributes;
import coin.Instances;

/**
 * @author Hidenao Abe  (hidneao@users.sourceforge.jp)
 *
 */
public abstract class DatasetLoader {
	
	protected char commentChar;
	protected String fieldDelimiter;
	
	protected Attributes attributeInfo;
	protected Instances instances;
	
	public DatasetLoader(){
		this.attributeInfo = new Attributes();
		this.instances = new Instances();
	}
	
	private void readAttributes(String str){
	}
	
	private void readInstances(String str){
	}

	public Attributes getAttributes(){
		return(attributeInfo);
	}
	
	public Instances getInstances(){
		return(instances);
	}

}
